/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.RspecKey;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="MaximumInheritanceDepth")
@RspecKey(value="S110")
public class DITCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final int DEFAULT_MAX = 5;
    private JavaFileScannerContext context;
    @RuleProperty(key="max", description="Maximum depth of the inheritance tree. (Number)", defaultValue="5")
    private Integer max = 5;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitClass(ClassTree tree) {
        Type superClass = tree.symbol().superClass();
        int dit = 0;
        while (superClass != null) {
            ++dit;
            superClass = superClass.symbol().superClass();
        }
        if (dit > this.max) {
            IdentifierTree reportTree = tree.simpleName();
            if (tree.parent().is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                reportTree = ((NewClassTree)tree.parent()).newKeyword();
            }
            this.context.reportIssue((JavaCheck)this, (Tree)reportTree, "This class has " + dit + " parents which is greater than " + this.max + " authorized.", new ArrayList(), Integer.valueOf(dit - this.max));
        }
        super.visitClass(tree);
    }

    @VisibleForTesting
    void setMax(int max) {
        this.max = max;
    }
}

