/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S1697")
public class NullDereferenceInConditionalCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        ExpressionTree nonNullOperand;
        IdentifierTree identifierTree;
        if ((NullDereferenceInConditionalCheck.isAndWithNullComparison(tree) || NullDereferenceInConditionalCheck.isOrWithNullExclusion(tree)) && (identifierTree = NullDereferenceInConditionalCheck.getIdentifier(nonNullOperand = NullDereferenceInConditionalCheck.getNonNullOperand(tree.leftOperand()))) != null) {
            IdentifierVisitor visitor = new IdentifierVisitor(identifierTree);
            tree.rightOperand().accept((TreeVisitor)visitor);
            if (visitor.raiseIssue) {
                this.context.reportIssue((JavaCheck)this, (Tree)tree, "Either reverse the equality operator in the \"" + identifierTree.name() + "\" null test, or reverse the logical operator that follows it.");
            }
        }
        super.visitBinaryExpression(tree);
    }

    private static IdentifierTree getIdentifier(ExpressionTree tree) {
        ExpressionTree nonNullOperand = ExpressionsHelper.skipParentheses(tree);
        if (nonNullOperand.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return (IdentifierTree)nonNullOperand;
        }
        return null;
    }

    private static boolean isAndWithNullComparison(BinaryExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_AND}) && NullDereferenceInConditionalCheck.isEqualNullComparison(tree.leftOperand());
    }

    private static boolean isOrWithNullExclusion(BinaryExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_OR}) && NullDereferenceInConditionalCheck.isNotEqualNullComparison(tree.leftOperand());
    }

    private static boolean isEqualNullComparison(ExpressionTree tree) {
        return NullDereferenceInConditionalCheck.isNullComparison(tree, Tree.Kind.EQUAL_TO);
    }

    private static boolean isNotEqualNullComparison(ExpressionTree tree) {
        return NullDereferenceInConditionalCheck.isNullComparison(tree, Tree.Kind.NOT_EQUAL_TO);
    }

    private static boolean isNullComparison(ExpressionTree expressionTree, Tree.Kind comparatorKind) {
        ExpressionTree tree = ExpressionsHelper.skipParentheses(expressionTree);
        if (tree.is(new Tree.Kind[]{comparatorKind})) {
            BinaryExpressionTree binary = (BinaryExpressionTree)tree;
            return binary.leftOperand().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) || binary.rightOperand().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
        }
        return false;
    }

    private static ExpressionTree getNonNullOperand(ExpressionTree expressionTree) {
        BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)ExpressionsHelper.skipParentheses(expressionTree);
        if (binaryExpressionTree.leftOperand().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            return binaryExpressionTree.rightOperand();
        }
        return binaryExpressionTree.leftOperand();
    }

    private static class IdentifierVisitor
    extends BaseTreeVisitor {
        private IdentifierTree identifierTree;
        boolean raiseIssue = false;

        IdentifierVisitor(IdentifierTree identifierTree) {
            this.identifierTree = identifierTree;
        }

        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            if (tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || tree.expression().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                this.scan((Tree)tree.expression());
            }
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (!this.isIdentifierWithSameName(tree.variable())) {
                this.scan((Tree)tree.variable());
            }
            this.scan((Tree)tree.expression());
        }

        public void visitBinaryExpression(BinaryExpressionTree tree) {
            boolean scanLeft = true;
            boolean scanRight = true;
            if (tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}) || tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO})) {
                scanLeft = !this.isIdentifierWithSameName(tree.leftOperand());
                boolean bl = scanRight = !this.isIdentifierWithSameName(tree.rightOperand());
            }
            if (scanLeft) {
                this.scan((Tree)tree.leftOperand());
            }
            if (scanRight) {
                this.scan((Tree)tree.rightOperand());
            }
        }

        public void visitIdentifier(IdentifierTree tree) {
            this.raiseIssue |= this.equalsIdentName(tree);
        }

        private boolean equalsIdentName(IdentifierTree tree) {
            return this.identifierTree.name().equals(tree.name());
        }

        private boolean isIdentifierWithSameName(ExpressionTree tree) {
            return tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.equalsIdentName((IdentifierTree)tree);
        }
    }
}

