/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1612")
public class ReplaceLambdaByMethodRefCheck
extends BaseTreeVisitor
implements JavaFileScanner,
JavaVersionAwareVisitor {
    private JavaFileScannerContext context;

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitLambdaExpression(LambdaExpressionTree tree) {
        if (ReplaceLambdaByMethodRefCheck.isSingleMethodInvocationUsingLambdaParamAsArg(tree) || ReplaceLambdaByMethodRefCheck.isBodyBlockInvokingMethod(tree)) {
            this.context.reportIssue((JavaCheck)this, (Tree)tree.arrowToken(), "Replace this lambda with a method reference." + this.context.getJavaVersion().java8CompatibilityMessage());
        }
        super.visitLambdaExpression(tree);
    }

    private static boolean isSingleMethodInvocationUsingLambdaParamAsArg(LambdaExpressionTree lambdaTree) {
        return ReplaceLambdaByMethodRefCheck.isMethodInvocation(lambdaTree.body(), lambdaTree);
    }

    private static boolean isBodyBlockInvokingMethod(LambdaExpressionTree lambdaTree) {
        Tree lambdaBody = lambdaTree.body();
        if (ReplaceLambdaByMethodRefCheck.isBlockWithOneStatement(lambdaBody)) {
            Tree statement = (Tree)((BlockTree)lambdaBody).body().get(0);
            return ReplaceLambdaByMethodRefCheck.isExpressionStatementInvokingMethod(statement, lambdaTree) || ReplaceLambdaByMethodRefCheck.isReturnStatementInvokingMethod(statement, lambdaTree);
        }
        return false;
    }

    private static boolean isBlockWithOneStatement(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.BLOCK}) && ((BlockTree)tree).body().size() == 1;
    }

    private static boolean isExpressionStatementInvokingMethod(Tree statement, LambdaExpressionTree lambdaTree) {
        return statement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) && ReplaceLambdaByMethodRefCheck.isMethodInvocation((Tree)((ExpressionStatementTree)statement).expression(), lambdaTree);
    }

    private static boolean isReturnStatementInvokingMethod(Tree statement, LambdaExpressionTree lambdaTree) {
        return statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT}) && ReplaceLambdaByMethodRefCheck.isMethodInvocation((Tree)((ReturnStatementTree)statement).expression(), lambdaTree);
    }

    private static boolean isMethodInvocation(@Nullable Tree tree, LambdaExpressionTree lambdaTree) {
        if (tree != null && tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS})) {
            Arguments arguments;
            if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                if (((NewClassTree)tree).classBody() != null) {
                    return false;
                }
                arguments = ((NewClassTree)tree).arguments();
            } else {
                arguments = ((MethodInvocationTree)tree).arguments();
            }
            return arguments.size() == lambdaTree.parameters().size() && IntStream.range(0, arguments.size()).allMatch(i -> {
                List usages = ((VariableTree)lambdaTree.parameters().get(i)).symbol().usages();
                return usages.size() == 1 && ((IdentifierTree)usages.get(0)).equals(arguments.get(i));
            });
        }
        return false;
    }
}

