/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1448")
public class TooManyMethodsCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAXIMUM = 35;
    @RuleProperty(key="maximumMethodThreshold", description="The maximum number of methods authorized in a class.", defaultValue="35")
    public int maximumMethodThreshold = 35;
    @RuleProperty(key="countNonpublicMethods", description="Whether or not to include non-public methods in the count.", defaultValue="true")
    public boolean countNonPublic = true;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ANNOTATION_TYPE);
    }

    public void visitNode(Tree tree) {
        ArrayList<Object> count = new ArrayList<Object>();
        ClassTree classTree = (ClassTree)tree;
        for (Object member : classTree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR}) || !this.countNonPublic && !((MethodTree)member).symbol().isPublic()) continue;
            count.add(member);
        }
        if (count.size() > this.maximumMethodThreshold) {
            ArrayList<JavaFileScannerContext.Location> secondary = new ArrayList<JavaFileScannerContext.Location>();
            for (Tree tree2 : count) {
                secondary.add(new JavaFileScannerContext.Location("Method + 1", tree2));
            }
            String classDescription = classTree.simpleName() == null ? "Anonymous class \"" + ((NewClassTree)classTree.parent()).identifier().symbolType().name() + "\"" : classTree.declarationKeyword().text() + " \"" + classTree.simpleName() + "\"";
            this.reportIssue(ExpressionsHelper.reportOnClassTree(classTree), String.format("%s has %d%s methods, which is greater than the %d authorized. Split it into smaller classes.", classDescription, count.size(), this.countNonPublic ? "" : " public", this.maximumMethodThreshold), secondary, null);
        }
    }
}

