/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2166")
public class ClassNamedLikeExceptionCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree;
        Symbol.TypeSymbol symbol;
        String className;
        if (this.hasSemantic() && (className = (symbol = (classTree = (ClassTree)tree).symbol()).name()).toLowerCase(Locale.US).endsWith("exception") && !symbol.type().isSubtypeOf("java.lang.Exception")) {
            String suffix = className.substring(className.length() - "exception".length());
            this.reportIssue((Tree)classTree.simpleName(), "Rename this class to remove \"" + suffix + "\" or correct its inheritance.");
        }
    }
}

