/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.serialization;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2441")
public class SerializableObjectInSessionCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("javax.servlet.http.HttpSession").name("setAttribute").addParameter("java.lang.String").addParameter(TypeCriteria.anyType()));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree argument = (ExpressionTree)mit.arguments().get(1);
        Type type = argument.symbolType();
        if (!type.isPrimitive() && !type.isSubtypeOf("java.io.Serializable")) {
            this.reportIssue((Tree)argument, "Make \"" + type + "\" serializable or don't store it in the session.");
        }
    }
}

