/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

public class ComplexityVisitor
extends SubscriptionVisitor {
    private List<Tree> blame = new ArrayList<Tree>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object)Tree.Kind.METHOD).add((Object)Tree.Kind.CONSTRUCTOR).add((Object)Tree.Kind.IF_STATEMENT).add((Object)Tree.Kind.FOR_STATEMENT).add((Object)Tree.Kind.FOR_EACH_STATEMENT).add((Object)Tree.Kind.DO_STATEMENT).add((Object)Tree.Kind.WHILE_STATEMENT).add((Object)Tree.Kind.RETURN_STATEMENT).add((Object)Tree.Kind.THROW_STATEMENT).add((Object)Tree.Kind.CASE_LABEL).add((Object)Tree.Kind.CATCH).add((Object)Tree.Kind.CONDITIONAL_EXPRESSION).add((Object)Tree.Kind.CONDITIONAL_AND).add((Object)Tree.Kind.CONDITIONAL_OR).build();
    }

    public List<Tree> scan(Tree tree) {
        this.blame.clear();
        super.scanTree(tree);
        return this.blame;
    }

    @Override
    public void visitNode(Tree tree) {
        switch (tree.kind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                this.computeMethodComplexity((MethodTree)tree);
                break;
            }
            case CASE_LABEL: {
                CaseLabelTree caseLabelTree = (CaseLabelTree)tree;
                if ("default".equals(caseLabelTree.caseOrDefaultKeyword().text())) break;
                this.blame.add(caseLabelTree.caseOrDefaultKeyword());
                break;
            }
            case IF_STATEMENT: 
            case FOR_STATEMENT: 
            case FOR_EACH_STATEMENT: 
            case DO_STATEMENT: 
            case WHILE_STATEMENT: 
            case RETURN_STATEMENT: 
            case THROW_STATEMENT: 
            case CATCH: {
                this.blame.add(tree.firstToken());
                break;
            }
            case CONDITIONAL_EXPRESSION: {
                this.blame.add(((ConditionalExpressionTree)tree).questionToken());
                break;
            }
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: {
                this.blame.add(((BinaryExpressionTree)tree).operatorToken());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void computeMethodComplexity(MethodTree methodTree) {
        BlockTree block = methodTree.block();
        if (block != null) {
            this.blame.add(methodTree.simpleName().identifierToken());
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        switch (tree.kind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                this.leaveMethod((MethodTree)tree);
                break;
            }
        }
    }

    private void leaveMethod(MethodTree tree) {
        StatementTree last;
        BlockTree block = tree.block();
        if (block != null && !block.body().isEmpty() && (last = (StatementTree)Iterables.getLast(block.body())).is(Tree.Kind.RETURN_STATEMENT)) {
            this.blame.remove(last.firstToken());
        }
    }
}

