/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.visitor;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.java.SonarComponents;
import org.sonar.java.bytecode.visitor.BytecodeContext;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class DefaultBytecodeContext
implements BytecodeContext {
    private final SonarComponents sonarComponents;
    JavaResourceLocator javaResourceLocator;

    @VisibleForTesting
    public DefaultBytecodeContext(JavaResourceLocator javaResourceLocator) {
        this(null, javaResourceLocator);
    }

    public DefaultBytecodeContext(@Nullable SonarComponents sonarComponents, JavaResourceLocator javaResourceLocator) {
        this.sonarComponents = sonarComponents;
        this.javaResourceLocator = javaResourceLocator;
    }

    @Override
    public void setJavaResourceLocator(JavaResourceLocator javaResourceLocator) {
        this.javaResourceLocator = javaResourceLocator;
    }

    @Override
    public JavaResourceLocator getJavaResourceLocator() {
        return this.javaResourceLocator;
    }

    @Override
    public void reportIssue(JavaCheck check, InputFile resource, String message, int line) {
        if (this.sonarComponents != null) {
            this.sonarComponents.addIssue(new File(resource.absolutePath()), check, line, message, null);
        }
    }
}

