/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.java.se.ExplodedGraphWalker;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.constraint.TypedConstraint;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.java.se.symbolicvalues.BinarySymbolicValue;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;

public class SymbolicValue {
    public static final SymbolicValue NULL_LITERAL = new SymbolicValue(0){

        @Override
        public String toString() {
            return super.toString() + "_NULL";
        }
    };
    public static final SymbolicValue TRUE_LITERAL = new SymbolicValue(1){

        @Override
        public String toString() {
            return super.toString() + "_TRUE";
        }
    };
    public static final SymbolicValue FALSE_LITERAL = new SymbolicValue(2){

        @Override
        public String toString() {
            return super.toString() + "_FALSE";
        }
    };
    public static final List<SymbolicValue> PROTECTED_SYMBOLIC_VALUES = ImmutableList.of((Object)NULL_LITERAL, (Object)TRUE_LITERAL, (Object)FALSE_LITERAL);
    private final int id;

    public SymbolicValue(int id) {
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    public static boolean isDisposable(SymbolicValue symbolicValue) {
        if (symbolicValue instanceof NotSymbolicValue) {
            NotSymbolicValue notSV = (NotSymbolicValue)symbolicValue;
            return !(notSV.operand instanceof RelationalSymbolicValue);
        }
        return !PROTECTED_SYMBOLIC_VALUES.contains(symbolicValue) && !(symbolicValue instanceof RelationalSymbolicValue);
    }

    public boolean references(SymbolicValue other) {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolicValue that = (SymbolicValue)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "SV_" + this.id;
    }

    public void computedFrom(List<SymbolicValue> symbolicValues) {
    }

    public List<ProgramState> setConstraint(ProgramState programState, ObjectConstraint nullConstraint) {
        Constraint data = programState.getConstraint(this);
        if (data instanceof ObjectConstraint) {
            ObjectConstraint nc = (ObjectConstraint)data;
            if (nc.isNull() ^ nullConstraint.isNull()) {
                return ImmutableList.of();
            }
            if (SymbolicValue.hasAnyStatus(nc) && SymbolicValue.hasNoStatus(nullConstraint)) {
                return ImmutableList.of((Object)programState);
            }
        }
        if (data instanceof BooleanConstraint) {
            return nullConstraint.isNull() ? ImmutableList.of() : ImmutableList.of((Object)programState);
        }
        if (data == null || !data.equals(nullConstraint)) {
            return ImmutableList.of((Object)programState.addConstraint(this, nullConstraint));
        }
        return ImmutableList.of((Object)programState);
    }

    private static boolean hasAnyStatus(ObjectConstraint constraint) {
        return !SymbolicValue.hasNoStatus(constraint);
    }

    private static boolean hasNoStatus(ObjectConstraint constraint) {
        return constraint.hasStatus(null);
    }

    public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
        Constraint data = programState.getConstraint(this);
        if (data instanceof BooleanConstraint && !data.equals(booleanConstraint)) {
            return ImmutableList.of();
        }
        if ((data == null || SymbolicValue.isNonNullConstraint(data)) && programState.canReach(this)) {
            return ImmutableList.of((Object)programState.addConstraint(this, booleanConstraint));
        }
        return ImmutableList.of((Object)programState);
    }

    private static boolean isNonNullConstraint(Object data) {
        return data instanceof ObjectConstraint && !((ObjectConstraint)data).isNull();
    }

    public ProgramState setSingleConstraint(ProgramState programState, ObjectConstraint nullConstraint) {
        List<ProgramState> states = this.setConstraint(programState, nullConstraint);
        if (states.size() != 1) {
            throw new IllegalStateException("Only a single program state is expected at this location");
        }
        return states.get(0);
    }

    public SymbolicValue wrappedValue() {
        return this;
    }

    @CheckForNull
    public BinaryRelation binaryRelation() {
        return null;
    }

    public static class XorSymbolicValue
    extends BooleanExpressionSymbolicValue {
        public XorSymbolicValue(int id) {
            super(id);
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            List<ProgramState> trueFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.TRUE);
            for (ProgramState ps : trueFirstOp) {
                XorSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, booleanConstraint.inverse()));
            }
            List<ProgramState> falseFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.FALSE);
            for (ProgramState ps : falseFirstOp) {
                XorSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, booleanConstraint));
            }
            return states;
        }

        @Override
        public String toString() {
            return this.leftOp + " ^ " + this.rightOp;
        }
    }

    public static class OrSymbolicValue
    extends BooleanExpressionSymbolicValue {
        public OrSymbolicValue(int id) {
            super(id);
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            if (booleanConstraint.isTrue()) {
                List<ProgramState> trueFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.TRUE);
                for (ProgramState ps : trueFirstOp) {
                    OrSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, BooleanConstraint.TRUE));
                    OrSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, BooleanConstraint.FALSE));
                }
            }
            List<ProgramState> falseFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.FALSE);
            for (ProgramState ps : falseFirstOp) {
                OrSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, booleanConstraint));
            }
            return states;
        }

        @Override
        public String toString() {
            return this.leftOp + " | " + this.rightOp;
        }
    }

    public static class AndSymbolicValue
    extends BooleanExpressionSymbolicValue {
        public AndSymbolicValue(int id) {
            super(id);
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            if (booleanConstraint.isFalse()) {
                List<ProgramState> falseFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.FALSE);
                for (ProgramState ps : falseFirstOp) {
                    AndSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, BooleanConstraint.TRUE));
                    AndSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, BooleanConstraint.FALSE));
                }
            }
            List<ProgramState> trueFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.TRUE);
            for (ProgramState ps : trueFirstOp) {
                AndSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, booleanConstraint));
            }
            return states;
        }

        @Override
        public String toString() {
            return this.leftOp + " & " + this.rightOp;
        }
    }

    public static abstract class BooleanExpressionSymbolicValue
    extends BinarySymbolicValue {
        protected BooleanExpressionSymbolicValue(int id) {
            super(id);
        }

        @Override
        public BooleanConstraint shouldNotInverse() {
            return BooleanConstraint.TRUE;
        }

        protected static void addStates(List<ProgramState> states, List<ProgramState> newStates) {
            if (states.size() > 10000 || newStates.size() > 10000) {
                throw new ExplodedGraphWalker.TooManyNestedBooleanStatesException();
            }
            states.addAll(newStates);
        }
    }

    public static class InstanceOfSymbolicValue
    extends UnarySymbolicValue {
        public InstanceOfSymbolicValue(int id) {
            super(id);
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            if (booleanConstraint.isTrue()) {
                Constraint constraint = programState.getConstraint(this.operand);
                if (constraint != null && constraint.isNull()) {
                    return ImmutableList.of();
                }
                List<ProgramState> ps = this.operand.setConstraint(programState, ObjectConstraint.NOT_NULL);
                if (ps.size() == 1 && ps.get(0).equals(programState)) {
                    return ImmutableList.of((Object)programState.addConstraint(this, new TypedConstraint()));
                }
                return ps;
            }
            return ImmutableList.of((Object)programState);
        }
    }

    public static class NotSymbolicValue
    extends UnarySymbolicValue {
        public NotSymbolicValue(int id) {
            super(id);
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            return this.operand.setConstraint(programState, booleanConstraint.inverse());
        }

        @Override
        public String toString() {
            return "!" + this.operand;
        }
    }

    public static abstract class UnarySymbolicValue
    extends SymbolicValue {
        protected SymbolicValue operand;

        public UnarySymbolicValue(int id) {
            super(id);
        }

        @Override
        public boolean references(SymbolicValue other) {
            return this.operand.equals(other) || this.operand.references(other);
        }

        @Override
        public void computedFrom(List<SymbolicValue> symbolicValues) {
            Preconditions.checkArgument((symbolicValues.size() == 1 ? 1 : 0) != 0);
            this.operand = symbolicValues.get(0);
        }
    }
}

