/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.typed.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.ArgumentListTreeImpl;
import org.sonar.java.ast.parser.BlockStatementListTreeImpl;
import org.sonar.java.ast.parser.BoundListTreeImpl;
import org.sonar.java.ast.parser.FormalParametersListTreeImpl;
import org.sonar.java.ast.parser.InitializerListTreeImpl;
import org.sonar.java.ast.parser.JavaLexer;
import org.sonar.java.ast.parser.LambdaParameterListTreeImpl;
import org.sonar.java.ast.parser.QualifiedIdentifierListTreeImpl;
import org.sonar.java.ast.parser.ResourceListTreeImpl;
import org.sonar.java.ast.parser.StatementExpressionListTreeImpl;
import org.sonar.java.ast.parser.TypeParameterListTreeImpl;
import org.sonar.java.ast.parser.TypeUnionListTreeImpl;
import org.sonar.java.ast.parser.VariableDeclaratorListTreeImpl;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.ArrayDimensionTreeImpl;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.KindMaps;
import org.sonar.java.model.TypeParameterTreeImpl;
import org.sonar.java.model.declaration.AnnotationTreeImpl;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.model.declaration.EnumConstantTreeImpl;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.model.declaration.ModifierKeywordTreeImpl;
import org.sonar.java.model.declaration.ModifiersTreeImpl;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.model.expression.ArrayAccessExpressionTreeImpl;
import org.sonar.java.model.expression.AssignmentExpressionTreeImpl;
import org.sonar.java.model.expression.BinaryExpressionTreeImpl;
import org.sonar.java.model.expression.ConditionalExpressionTreeImpl;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.java.model.expression.InstanceOfTreeImpl;
import org.sonar.java.model.expression.InternalPostfixUnaryExpression;
import org.sonar.java.model.expression.InternalPrefixUnaryExpression;
import org.sonar.java.model.expression.LambdaExpressionTreeImpl;
import org.sonar.java.model.expression.LiteralTreeImpl;
import org.sonar.java.model.expression.MemberSelectExpressionTreeImpl;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.java.model.expression.MethodReferenceTreeImpl;
import org.sonar.java.model.expression.NewArrayTreeImpl;
import org.sonar.java.model.expression.NewClassTreeImpl;
import org.sonar.java.model.expression.ParenthesizedTreeImpl;
import org.sonar.java.model.expression.TypeArgumentListTreeImpl;
import org.sonar.java.model.expression.TypeCastExpressionTreeImpl;
import org.sonar.java.model.statement.AssertStatementTreeImpl;
import org.sonar.java.model.statement.BlockTreeImpl;
import org.sonar.java.model.statement.BreakStatementTreeImpl;
import org.sonar.java.model.statement.CaseGroupTreeImpl;
import org.sonar.java.model.statement.CaseLabelTreeImpl;
import org.sonar.java.model.statement.CatchTreeImpl;
import org.sonar.java.model.statement.ContinueStatementTreeImpl;
import org.sonar.java.model.statement.DoWhileStatementTreeImpl;
import org.sonar.java.model.statement.EmptyStatementTreeImpl;
import org.sonar.java.model.statement.ExpressionStatementTreeImpl;
import org.sonar.java.model.statement.ForEachStatementImpl;
import org.sonar.java.model.statement.ForStatementTreeImpl;
import org.sonar.java.model.statement.IfStatementTreeImpl;
import org.sonar.java.model.statement.LabeledStatementTreeImpl;
import org.sonar.java.model.statement.ReturnStatementTreeImpl;
import org.sonar.java.model.statement.StaticInitializerTreeImpl;
import org.sonar.java.model.statement.SwitchStatementTreeImpl;
import org.sonar.java.model.statement.SynchronizedStatementTreeImpl;
import org.sonar.java.model.statement.ThrowStatementTreeImpl;
import org.sonar.java.model.statement.TryStatementTreeImpl;
import org.sonar.java.model.statement.WhileStatementTreeImpl;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.ModifierTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeArguments;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class TreeFactory {
    private final KindMaps kindMaps = new KindMaps();

    public ModifiersTreeImpl modifiers(Optional<List<ModifierTree>> modifierNodes) {
        if (!modifierNodes.isPresent()) {
            return ModifiersTreeImpl.emptyModifiers();
        }
        return new ModifiersTreeImpl((List)modifierNodes.get());
    }

    public ModifierKeywordTreeImpl modifierKeyword(InternalSyntaxToken token) {
        JavaKeyword keyword = (JavaKeyword)token.getGrammarRuleKey();
        return new ModifierKeywordTreeImpl(this.kindMaps.getModifier(keyword), token);
    }

    public ExpressionTree literal(InternalSyntaxToken token) {
        return new LiteralTreeImpl(this.kindMaps.getLiteral(token.getGrammarRuleKey()), token);
    }

    public JavaTree.CompilationUnitTreeImpl newCompilationUnit(JavaTree spacing, Optional<PackageDeclarationTree> packageDeclaration, Optional<List<ImportClauseTree>> importDeclarations, Optional<List<Tree>> typeDeclarations, InternalSyntaxToken eof) {
        ImmutableList.Builder imports = ImmutableList.builder();
        if (importDeclarations.isPresent()) {
            for (ImportClauseTree child : (List)importDeclarations.get()) {
                imports.add((Object)child);
            }
        }
        ImmutableList.Builder types = ImmutableList.builder();
        if (typeDeclarations.isPresent()) {
            for (Tree child : (List)typeDeclarations.get()) {
                types.add((Object)child);
            }
        }
        return new JavaTree.CompilationUnitTreeImpl((PackageDeclarationTree)packageDeclaration.orNull(), (List<ImportClauseTree>)imports.build(), (List<Tree>)types.build(), eof);
    }

    public JavaTree.PackageDeclarationTreeImpl newPackageDeclaration(Optional<List<AnnotationTreeImpl>> annotations, InternalSyntaxToken packageToken, ExpressionTree qualifiedIdentifier, InternalSyntaxToken semicolonToken) {
        ImmutableList annotationList = Collections.emptyList();
        if (annotations.isPresent()) {
            annotationList = ImmutableList.builder().addAll((Iterable)annotations.get()).build();
        }
        return new JavaTree.PackageDeclarationTreeImpl((List<AnnotationTree>)annotationList, packageToken, qualifiedIdentifier, semicolonToken);
    }

    public ImportClauseTree newEmptyImport(InternalSyntaxToken semicolonToken) {
        return new EmptyStatementTreeImpl(semicolonToken);
    }

    public JavaTree.ImportTreeImpl newImportDeclaration(InternalSyntaxToken importToken, Optional<InternalSyntaxToken> staticToken, ExpressionTree qualifiedIdentifier, Optional<Tuple<InternalSyntaxToken, InternalSyntaxToken>> dotStar, InternalSyntaxToken semicolonToken) {
        ExpressionTree target = qualifiedIdentifier;
        if (dotStar.isPresent()) {
            IdentifierTreeImpl identifier = new IdentifierTreeImpl((InternalSyntaxToken)((Tuple)dotStar.get()).second());
            InternalSyntaxToken dotToken = (InternalSyntaxToken)((Tuple)dotStar.get()).first();
            target = new MemberSelectExpressionTreeImpl(qualifiedIdentifier, dotToken, (IdentifierTree)identifier);
        }
        InternalSyntaxToken staticKeyword = (InternalSyntaxToken)staticToken.orNull();
        return new JavaTree.ImportTreeImpl(importToken, staticKeyword, target, semicolonToken);
    }

    public ClassTreeImpl newTypeDeclaration(ModifiersTreeImpl modifiers, ClassTreeImpl partial) {
        return partial.completeModifiers(modifiers);
    }

    public Tree newEmptyType(InternalSyntaxToken semicolonToken) {
        return new EmptyStatementTreeImpl(semicolonToken);
    }

    public TypeTree newType(TypeTree basicOrClassType, Optional<List<Tuple<Optional<List<AnnotationTreeImpl>>, Tuple<InternalSyntaxToken, InternalSyntaxToken>>>> dims) {
        if (!dims.isPresent()) {
            return basicOrClassType;
        }
        TypeTree result = basicOrClassType;
        for (Tuple dim : (List)dims.get()) {
            result = TreeFactory.newArrayTypeTreeWithAnnotations(result, dim);
        }
        return result;
    }

    public TypeArgumentListTreeImpl newTypeArgumentList(InternalSyntaxToken openBracketToken, Tree typeArgument, Optional<List<Tuple<InternalSyntaxToken, Tree>>> rests, InternalSyntaxToken closeBracketToken) {
        ImmutableList.Builder typeArguments = ImmutableList.builder();
        ImmutableList.Builder separators = ImmutableList.builder();
        typeArguments.add((Object)typeArgument);
        if (rests.isPresent()) {
            for (Tuple rest : (List)rests.get()) {
                separators.add(rest.first());
                typeArguments.add(rest.second());
            }
        }
        return new TypeArgumentListTreeImpl(openBracketToken, (List<Tree>)typeArguments.build(), (List<SyntaxToken>)separators.build(), closeBracketToken);
    }

    public TypeArgumentListTreeImpl newDiamondTypeArgument(InternalSyntaxToken openBracketToken, InternalSyntaxToken closeBracketToken) {
        return new TypeArgumentListTreeImpl(openBracketToken, (List<Tree>)ImmutableList.of(), (List<SyntaxToken>)ImmutableList.of(), closeBracketToken);
    }

    public Tree completeTypeArgument(Optional<List<AnnotationTreeImpl>> annotations, Tree partial) {
        if (partial.is(Tree.Kind.UNBOUNDED_WILDCARD, Tree.Kind.EXTENDS_WILDCARD, Tree.Kind.SUPER_WILDCARD)) {
            ImmutableList annotationList = annotations.isPresent() ? ImmutableList.builder().addAll((Iterable)annotations.get()).build() : ImmutableList.of();
            ((JavaTree.WildcardTreeImpl)partial).complete((List<AnnotationTree>)annotationList);
        } else {
            TreeFactory.completeTypeTreeWithAnnotations((TypeTree)partial, annotations);
        }
        return partial;
    }

    public TypeTree newBasicTypeArgument(TypeTree type) {
        return type;
    }

    public JavaTree.WildcardTreeImpl completeWildcardTypeArgument(InternalSyntaxToken queryToken, Optional<JavaTree.WildcardTreeImpl> partial) {
        return partial.isPresent() ? ((JavaTree.WildcardTreeImpl)partial.get()).complete(queryToken) : new JavaTree.WildcardTreeImpl(queryToken);
    }

    public JavaTree.WildcardTreeImpl newWildcardTypeArguments(InternalSyntaxToken extendsOrSuperToken, Optional<List<AnnotationTreeImpl>> annotations, TypeTree type) {
        TreeFactory.completeTypeTreeWithAnnotations(type, annotations);
        return new JavaTree.WildcardTreeImpl(JavaKeyword.EXTENDS.getValue().equals(extendsOrSuperToken.text()) ? Tree.Kind.EXTENDS_WILDCARD : Tree.Kind.SUPER_WILDCARD, extendsOrSuperToken, type);
    }

    public TypeParameterListTreeImpl newTypeParameterList(InternalSyntaxToken openBracketToken, TypeParameterTreeImpl typeParameter, Optional<List<Tuple<InternalSyntaxToken, TypeParameterTreeImpl>>> rests, InternalSyntaxToken closeBracketToken) {
        ImmutableList.Builder typeParameters = ImmutableList.builder();
        typeParameters.add((Object)typeParameter);
        ImmutableList.Builder separators = ImmutableList.builder();
        if (rests.isPresent()) {
            for (Tuple rest : (List)rests.get()) {
                separators.add(rest.first());
                typeParameters.add(rest.second());
            }
        }
        return new TypeParameterListTreeImpl(openBracketToken, (List<TypeParameterTree>)typeParameters.build(), (List<SyntaxToken>)separators.build(), closeBracketToken);
    }

    public TypeParameterTreeImpl completeTypeParameter(Optional<List<AnnotationTreeImpl>> annotations, InternalSyntaxToken identifierToken, Optional<TypeParameterTreeImpl> partial) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(identifierToken);
        TreeFactory.completeTypeTreeWithAnnotations((TypeTree)identifier, annotations);
        return partial.isPresent() ? ((TypeParameterTreeImpl)partial.get()).complete(identifier) : new TypeParameterTreeImpl(identifier);
    }

    public TypeParameterTreeImpl newTypeParameter(InternalSyntaxToken extendsToken, BoundListTreeImpl bounds) {
        return new TypeParameterTreeImpl(extendsToken, bounds);
    }

    public BoundListTreeImpl newBounds(TypeTree classType, Optional<List<Tuple<InternalSyntaxToken, Tree>>> rests) {
        ImmutableList.Builder classTypes = ImmutableList.builder();
        ImmutableList.Builder separators = ImmutableList.builder();
        classTypes.add((Object)classType);
        if (rests.isPresent()) {
            for (Tuple rest : (List)rests.get()) {
                separators.add(rest.first());
                classTypes.add(rest.second());
            }
        }
        return new BoundListTreeImpl((List<? extends Tree>)classTypes.build(), (List<SyntaxToken>)separators.build());
    }

    public ClassTreeImpl completeClassDeclaration(InternalSyntaxToken classSyntaxToken, InternalSyntaxToken identifierToken, Optional<TypeParameterListTreeImpl> typeParameters, Optional<Tuple<InternalSyntaxToken, TypeTree>> extendsClause, Optional<Tuple<InternalSyntaxToken, QualifiedIdentifierListTreeImpl>> implementsClause, ClassTreeImpl partial) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(identifierToken);
        partial.completeDeclarationKeyword(classSyntaxToken);
        partial.completeIdentifier(identifier);
        if (typeParameters.isPresent()) {
            partial.completeTypeParameters((TypeParameterListTreeImpl)typeParameters.get());
        }
        if (extendsClause.isPresent()) {
            partial.completeSuperclass((SyntaxToken)((Tuple)extendsClause.get()).first(), (TypeTree)((Tuple)extendsClause.get()).second());
        }
        if (implementsClause.isPresent()) {
            InternalSyntaxToken implementsKeyword = (InternalSyntaxToken)((Tuple)implementsClause.get()).first();
            QualifiedIdentifierListTreeImpl interfaces = (QualifiedIdentifierListTreeImpl)((Tuple)implementsClause.get()).second();
            partial.completeInterfaces(implementsKeyword, interfaces);
        }
        return partial;
    }

    private static ClassTreeImpl newClassBody(Tree.Kind kind, InternalSyntaxToken openBraceSyntaxToken, Optional<List<JavaTree>> members, InternalSyntaxToken closeBraceTokenSyntaxToken) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (members.isPresent()) {
            for (JavaTree member : (List)members.get()) {
                if (member instanceof VariableDeclaratorListTreeImpl) {
                    for (VariableTreeImpl variable : (VariableDeclaratorListTreeImpl)member) {
                        builder.add((Object)variable);
                    }
                    continue;
                }
                builder.add((Object)member);
            }
        }
        return new ClassTreeImpl(kind, (SyntaxToken)openBraceSyntaxToken, (List<Tree>)builder.build(), (SyntaxToken)closeBraceTokenSyntaxToken);
    }

    public ClassTreeImpl newClassBody(InternalSyntaxToken openBraceToken, Optional<List<JavaTree>> members, InternalSyntaxToken closeBraceToken) {
        return TreeFactory.newClassBody(Tree.Kind.CLASS, openBraceToken, members, closeBraceToken);
    }

    public ClassTreeImpl newEnumDeclaration(InternalSyntaxToken enumToken, InternalSyntaxToken identifierToken, Optional<Tuple<InternalSyntaxToken, QualifiedIdentifierListTreeImpl>> implementsClause, InternalSyntaxToken openBraceToken, Optional<List<EnumConstantTreeImpl>> enumConstants, Optional<InternalSyntaxToken> semicolonToken, Optional<List<JavaTree>> enumDeclarations, InternalSyntaxToken closeBraceToken) {
        LinkedList members = Lists.newLinkedList();
        VariableTreeImpl lastEnumConstant = null;
        if (enumConstants.isPresent()) {
            for (EnumConstantTreeImpl enumConstant : (List)enumConstants.get()) {
                members.add(enumConstant);
                lastEnumConstant = enumConstant;
            }
        }
        if (semicolonToken.isPresent()) {
            InternalSyntaxToken semicolon = (InternalSyntaxToken)semicolonToken.get();
            if (lastEnumConstant != null) {
                lastEnumConstant.setEndToken(semicolon);
            } else {
                members.add(this.newEmptyMember(semicolon));
            }
        }
        if (enumDeclarations.isPresent()) {
            for (JavaTree enumDeclaration : (List)enumDeclarations.get()) {
                members.add(enumDeclaration);
            }
        }
        ClassTreeImpl result = TreeFactory.newClassBody(Tree.Kind.ENUM, openBraceToken, (Optional<List<JavaTree>>)Optional.of((Object)ImmutableList.builder().addAll((Iterable)members).build()), closeBraceToken);
        result.completeDeclarationKeyword(enumToken);
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(identifierToken);
        result.completeIdentifier(identifier);
        if (implementsClause.isPresent()) {
            InternalSyntaxToken implementsKeyword = (InternalSyntaxToken)((Tuple)implementsClause.get()).first();
            QualifiedIdentifierListTreeImpl interfaces = (QualifiedIdentifierListTreeImpl)((Tuple)implementsClause.get()).second();
            result.completeInterfaces(implementsKeyword, interfaces);
        }
        return result;
    }

    public EnumConstantTreeImpl newEnumConstant(Optional<List<AnnotationTreeImpl>> annotations, InternalSyntaxToken identifierToken, Optional<ArgumentListTreeImpl> arguments, Optional<ClassTreeImpl> classBody, Optional<InternalSyntaxToken> commaToken) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(identifierToken);
        ArgumentListTreeImpl defaultArguments = new ArgumentListTreeImpl((List<ExpressionTree>)ImmutableList.of(), (List<SyntaxToken>)ImmutableList.of());
        NewClassTreeImpl newClass = new NewClassTreeImpl((Arguments)arguments.or((Object)defaultArguments), (ClassTreeImpl)classBody.orNull());
        newClass.completeWithIdentifier(identifier);
        return new EnumConstantTreeImpl(this.modifiers(annotations), identifier, newClass, (InternalSyntaxToken)commaToken.orNull());
    }

    public ClassTreeImpl completeInterfaceDeclaration(InternalSyntaxToken interfaceToken, InternalSyntaxToken identifierToken, Optional<TypeParameterListTreeImpl> typeParameters, Optional<Tuple<InternalSyntaxToken, QualifiedIdentifierListTreeImpl>> extendsClause, ClassTreeImpl partial) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(identifierToken);
        partial.completeDeclarationKeyword(interfaceToken);
        partial.completeIdentifier(identifier);
        if (typeParameters.isPresent()) {
            partial.completeTypeParameters((TypeParameterListTreeImpl)typeParameters.get());
        }
        if (extendsClause.isPresent()) {
            InternalSyntaxToken extendsKeyword = (InternalSyntaxToken)((Tuple)extendsClause.get()).first();
            QualifiedIdentifierListTreeImpl interfaces = (QualifiedIdentifierListTreeImpl)((Tuple)extendsClause.get()).second();
            partial.completeInterfaces(extendsKeyword, interfaces);
        }
        return partial;
    }

    public ClassTreeImpl newInterfaceBody(InternalSyntaxToken openBraceToken, Optional<List<JavaTree>> members, InternalSyntaxToken closeBraceToken) {
        return TreeFactory.newClassBody(Tree.Kind.INTERFACE, openBraceToken, members, closeBraceToken);
    }

    public JavaTree completeMember(ModifiersTreeImpl modifiers, JavaTree partial) {
        if (partial instanceof ClassTreeImpl) {
            ((ClassTreeImpl)partial).completeModifiers(modifiers);
        } else if (partial instanceof VariableDeclaratorListTreeImpl) {
            for (VariableTreeImpl variable : (VariableDeclaratorListTreeImpl)partial) {
                variable.completeModifiers(modifiers);
            }
        } else if (partial instanceof MethodTreeImpl) {
            ((MethodTreeImpl)partial).completeWithModifiers(modifiers);
        } else {
            throw new IllegalArgumentException();
        }
        return partial;
    }

    public BlockTreeImpl newInitializerMember(Optional<InternalSyntaxToken> staticToken, BlockTreeImpl block) {
        if (staticToken.isPresent()) {
            return new StaticInitializerTreeImpl((InternalSyntaxToken)staticToken.get(), (InternalSyntaxToken)block.openBraceToken(), block.body(), (InternalSyntaxToken)block.closeBraceToken());
        }
        return new BlockTreeImpl(Tree.Kind.INITIALIZER, (InternalSyntaxToken)block.openBraceToken(), block.body(), (InternalSyntaxToken)block.closeBraceToken());
    }

    public EmptyStatementTreeImpl newEmptyMember(InternalSyntaxToken semicolonToken) {
        return new EmptyStatementTreeImpl(semicolonToken);
    }

    public MethodTreeImpl completeGenericMethodOrConstructorDeclaration(TypeParameterListTreeImpl typeParameters, MethodTreeImpl partial) {
        return partial.completeWithTypeParameters(typeParameters);
    }

    private MethodTreeImpl newMethodOrConstructor(Optional<TypeTree> type, InternalSyntaxToken identifierToken, FormalParametersListTreeImpl parameters, Optional<List<Tuple<Optional<List<AnnotationTreeImpl>>, Tuple<InternalSyntaxToken, InternalSyntaxToken>>>> annotatedDimensions, Optional<Tuple<InternalSyntaxToken, QualifiedIdentifierListTreeImpl>> throwsClause, JavaTree blockOrSemicolon) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(identifierToken);
        JavaTree.ArrayTypeTreeImpl nestedDimensions = TreeFactory.newArrayTypeTreeWithAnnotations(annotatedDimensions);
        TypeTree actualType = type.isPresent() ? TreeFactory.applyDim((TypeTree)type.get(), nestedDimensions) : null;
        BlockTreeImpl block = null;
        InternalSyntaxToken semicolonToken = null;
        if (blockOrSemicolon.is(Tree.Kind.BLOCK)) {
            block = (BlockTreeImpl)blockOrSemicolon;
        } else {
            semicolonToken = (InternalSyntaxToken)blockOrSemicolon;
        }
        InternalSyntaxToken throwsToken = null;
        ListTree<TypeTree> throwsClauses = QualifiedIdentifierListTreeImpl.emptyList();
        if (throwsClause.isPresent()) {
            throwsToken = (InternalSyntaxToken)((Tuple)throwsClause.get()).first();
            throwsClauses = (ListTree)((Tuple)throwsClause.get()).second();
        }
        return new MethodTreeImpl(actualType, identifier, parameters, throwsToken, throwsClauses, block, semicolonToken);
    }

    public MethodTreeImpl newMethod(TypeTree type, InternalSyntaxToken identifierToken, FormalParametersListTreeImpl parameters, Optional<List<Tuple<Optional<List<AnnotationTreeImpl>>, Tuple<InternalSyntaxToken, InternalSyntaxToken>>>> annotatedDimensions, Optional<Tuple<InternalSyntaxToken, QualifiedIdentifierListTreeImpl>> throwsClause, JavaTree blockOrSemicolon) {
        return this.newMethodOrConstructor((Optional<TypeTree>)Optional.of((Object)type), identifierToken, parameters, annotatedDimensions, throwsClause, blockOrSemicolon);
    }

    public MethodTreeImpl newConstructor(InternalSyntaxToken identifierToken, FormalParametersListTreeImpl parameters, Optional<List<Tuple<Optional<List<AnnotationTreeImpl>>, Tuple<InternalSyntaxToken, InternalSyntaxToken>>>> annotatedDimensions, Optional<Tuple<InternalSyntaxToken, QualifiedIdentifierListTreeImpl>> throwsClause, JavaTree blockOrSemicolon) {
        return this.newMethodOrConstructor((Optional<TypeTree>)Optional.absent(), identifierToken, parameters, annotatedDimensions, throwsClause, blockOrSemicolon);
    }

    public VariableDeclaratorListTreeImpl completeFieldDeclaration(TypeTree type, VariableDeclaratorListTreeImpl partial, InternalSyntaxToken semicolonToken) {
        for (VariableTreeImpl variable : partial) {
            variable.completeType(type);
        }
        ((VariableTreeImpl)partial.get(partial.size() - 1)).setEndToken(semicolonToken);
        return partial;
    }

    public ClassTreeImpl completeAnnotationType(InternalSyntaxToken atToken, InternalSyntaxToken interfaceToken, InternalSyntaxToken identifier, ClassTreeImpl partial) {
        return partial.complete(atToken, interfaceToken, new IdentifierTreeImpl(identifier));
    }

    public ClassTreeImpl newAnnotationType(InternalSyntaxToken openBraceToken, Optional<List<JavaTree>> annotationTypeElementDeclarations, InternalSyntaxToken closeBraceToken) {
        ModifiersTreeImpl emptyModifiers = ModifiersTreeImpl.emptyModifiers();
        ImmutableList.Builder members = ImmutableList.builder();
        if (annotationTypeElementDeclarations.isPresent()) {
            for (JavaTree annotationTypeElementDeclaration : (List)annotationTypeElementDeclarations.get()) {
                if (annotationTypeElementDeclaration.getGrammarRuleKey().equals((Object)JavaLexer.VARIABLE_DECLARATORS)) {
                    for (VariableTreeImpl variable : (VariableDeclaratorListTreeImpl)annotationTypeElementDeclaration) {
                        members.add((Object)variable);
                    }
                    continue;
                }
                if (annotationTypeElementDeclaration.is(Tree.Kind.TOKEN)) continue;
                members.add((Object)annotationTypeElementDeclaration);
            }
        }
        return new ClassTreeImpl(emptyModifiers, (SyntaxToken)openBraceToken, (List<Tree>)members.build(), (SyntaxToken)closeBraceToken);
    }

    public JavaTree completeAnnotationTypeMember(ModifiersTreeImpl modifiers, JavaTree partial) {
        if (partial.getGrammarRuleKey().equals((Object)JavaLexer.VARIABLE_DECLARATORS)) {
            for (VariableTreeImpl variable : (VariableDeclaratorListTreeImpl)partial) {
                variable.completeModifiers(modifiers);
            }
        } else if (partial.is(Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE)) {
            ((ClassTreeImpl)partial).completeModifiers(modifiers);
        } else if (partial.is(Tree.Kind.METHOD)) {
            ((MethodTreeImpl)partial).completeWithModifiers(modifiers);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + partial);
        }
        return partial;
    }

    public MethodTreeImpl completeAnnotationMethod(TypeTree type, InternalSyntaxToken identifierToken, MethodTreeImpl partial, InternalSyntaxToken semiToken) {
        partial.complete(type, new IdentifierTreeImpl(identifierToken), semiToken);
        return partial;
    }

    public MethodTreeImpl newAnnotationTypeMethod(InternalSyntaxToken openParenToken, InternalSyntaxToken closeParenToken, Optional<Tuple<InternalSyntaxToken, ExpressionTree>> defaultValue) {
        FormalParametersListTreeImpl parameters = new FormalParametersListTreeImpl(openParenToken, closeParenToken);
        InternalSyntaxToken defaultToken = null;
        ExpressionTree defaultExpression = null;
        if (defaultValue.isPresent()) {
            defaultToken = (InternalSyntaxToken)((Tuple)defaultValue.get()).first();
            defaultExpression = (ExpressionTree)((Tuple)defaultValue.get()).second();
        }
        return new MethodTreeImpl(parameters, defaultToken, defaultExpression);
    }

    public Tuple<InternalSyntaxToken, ExpressionTree> newDefaultValue(InternalSyntaxToken defaultToken, ExpressionTree elementValue) {
        return new Tuple<InternalSyntaxToken, ExpressionTree>(defaultToken, elementValue);
    }

    public AnnotationTreeImpl newAnnotation(InternalSyntaxToken atToken, TypeTree qualifiedIdentifier, Optional<ArgumentListTreeImpl> arguments) {
        ArgumentListTreeImpl defaultValue = new ArgumentListTreeImpl((List<ExpressionTree>)ImmutableList.of(), (List<SyntaxToken>)ImmutableList.of());
        return new AnnotationTreeImpl(atToken, qualifiedIdentifier, (ArgumentListTreeImpl)arguments.or((Object)defaultValue));
    }

    public ArgumentListTreeImpl completeNormalAnnotation(InternalSyntaxToken openParenToken, Optional<ArgumentListTreeImpl> partial, InternalSyntaxToken closeParenToken) {
        if (!partial.isPresent()) {
            return new ArgumentListTreeImpl(openParenToken, closeParenToken);
        }
        ArgumentListTreeImpl elementValuePairs = (ArgumentListTreeImpl)partial.get();
        elementValuePairs.complete(openParenToken, closeParenToken);
        return elementValuePairs;
    }

    public ArgumentListTreeImpl newNormalAnnotation(AssignmentExpressionTreeImpl elementValuePair, Optional<List<Tuple<InternalSyntaxToken, AssignmentExpressionTreeImpl>>> rests) {
        ImmutableList.Builder expressions = ImmutableList.builder();
        expressions.add((Object)elementValuePair);
        ImmutableList.Builder separators = ImmutableList.builder();
        if (rests.isPresent()) {
            for (Tuple rest : (List)rests.get()) {
                separators.add(rest.first());
                expressions.add(rest.second());
            }
        }
        return new ArgumentListTreeImpl((List<ExpressionTree>)expressions.build(), (List<SyntaxToken>)separators.build());
    }

    public AssignmentExpressionTreeImpl newElementValuePair(InternalSyntaxToken identifierToken, InternalSyntaxToken operator, ExpressionTree elementValue) {
        return new AssignmentExpressionTreeImpl(this.kindMaps.getAssignmentOperator((JavaPunctuator)operator.getGrammarRuleKey()), new IdentifierTreeImpl(identifierToken), operator, elementValue);
    }

    public NewArrayTreeImpl completeElementValueArrayInitializer(InternalSyntaxToken openBraceToken, Optional<NewArrayTreeImpl> partial, InternalSyntaxToken closeBraceToken) {
        NewArrayTreeImpl elementValues = (NewArrayTreeImpl)partial.or((Object)new NewArrayTreeImpl((List<ArrayDimensionTree>)ImmutableList.of(), InitializerListTreeImpl.emptyList()));
        return elementValues.completeWithCurlyBraces(openBraceToken, closeBraceToken);
    }

    public NewArrayTreeImpl newElementValueArrayInitializer(List<Tuple<ExpressionTree, Optional<InternalSyntaxToken>>> rests) {
        ImmutableList.Builder expressions = ImmutableList.builder();
        ImmutableList.Builder separators = ImmutableList.builder();
        for (Tuple<ExpressionTree, Optional<InternalSyntaxToken>> tuple : rests) {
            expressions.add((Object)tuple.first());
            if (!tuple.second().isPresent()) continue;
            separators.add(tuple.second().get());
        }
        return new NewArrayTreeImpl((List<ArrayDimensionTree>)ImmutableList.of(), new InitializerListTreeImpl((List<ExpressionTree>)expressions.build(), (List<SyntaxToken>)separators.build()));
    }

    public ArgumentListTreeImpl newSingleElementAnnotation(InternalSyntaxToken openParenToken, ExpressionTree elementValue, InternalSyntaxToken closeParenToken) {
        return new ArgumentListTreeImpl(openParenToken, elementValue, closeParenToken);
    }

    public FormalParametersListTreeImpl completeParenFormalParameters(InternalSyntaxToken openParenToken, Optional<FormalParametersListTreeImpl> partial, InternalSyntaxToken closeParenToken) {
        return partial.isPresent() ? ((FormalParametersListTreeImpl)partial.get()).complete(openParenToken, closeParenToken) : new FormalParametersListTreeImpl(openParenToken, closeParenToken);
    }

    public FormalParametersListTreeImpl completeTypeFormalParameters(ModifiersTreeImpl modifiers, TypeTree type, FormalParametersListTreeImpl partial) {
        VariableTreeImpl variable = (VariableTreeImpl)partial.get(0);
        variable.completeModifiersAndType(modifiers, type);
        return partial;
    }

    public FormalParametersListTreeImpl prependNewFormalParameter(VariableTreeImpl variable, Optional<Tuple<InternalSyntaxToken, FormalParametersListTreeImpl>> rest) {
        if (rest.isPresent()) {
            InternalSyntaxToken comma = (InternalSyntaxToken)((Tuple)rest.get()).first();
            FormalParametersListTreeImpl partial = (FormalParametersListTreeImpl)((Tuple)rest.get()).second();
            partial.add(0, variable);
            variable.setEndToken(comma);
            return partial;
        }
        return new FormalParametersListTreeImpl(variable);
    }

    public FormalParametersListTreeImpl newVariableArgumentFormalParameter(Optional<List<AnnotationTreeImpl>> annotations, InternalSyntaxToken ellipsisToken, VariableTreeImpl variable) {
        variable.addEllipsisDimension(new JavaTree.ArrayTypeTreeImpl(null, (List)annotations.or((Object)ImmutableList.of()), ellipsisToken));
        return new FormalParametersListTreeImpl((List)annotations.or((Object)ImmutableList.of()), ellipsisToken, variable);
    }

    public VariableTreeImpl newVariableDeclaratorId(InternalSyntaxToken identifierToken, Optional<List<Tuple<Optional<List<AnnotationTreeImpl>>, Tuple<InternalSyntaxToken, InternalSyntaxToken>>>> dims) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(identifierToken);
        JavaTree.ArrayTypeTreeImpl nestedDimensions = TreeFactory.newArrayTypeTreeWithAnnotations(dims);
        return new VariableTreeImpl(identifier, nestedDimensions);
    }

    public VariableTreeImpl newFormalParameter(ModifiersTreeImpl modifiers, TypeTree type, VariableTreeImpl variable) {
        return variable.completeType(type);
    }

    public VariableDeclaratorListTreeImpl completeLocalVariableDeclaration(ModifiersTreeImpl modifiers, TypeTree type, VariableDeclaratorListTreeImpl variables, InternalSyntaxToken semicolonSyntaxToken) {
        for (VariableTreeImpl variable : variables) {
            variable.completeModifiersAndType(modifiers, type);
        }
        ((VariableTreeImpl)variables.get(variables.size() - 1)).setEndToken(semicolonSyntaxToken);
        return variables;
    }

    public VariableDeclaratorListTreeImpl newVariableDeclarators(VariableTreeImpl variable, Optional<List<Tuple<InternalSyntaxToken, VariableTreeImpl>>> rests) {
        ImmutableList.Builder variables = ImmutableList.builder();
        variables.add((Object)variable);
        if (rests.isPresent()) {
            VariableTreeImpl previousVariable = variable;
            for (Tuple rest : (List)rests.get()) {
                VariableTreeImpl newVariable = (VariableTreeImpl)rest.second();
                InternalSyntaxToken separator = (InternalSyntaxToken)rest.first();
                variables.add((Object)newVariable);
                previousVariable.setEndToken(separator);
                previousVariable = newVariable;
            }
        }
        return new VariableDeclaratorListTreeImpl((List<VariableTreeImpl>)variables.build());
    }

    public VariableTreeImpl completeVariableDeclarator(InternalSyntaxToken identifierToken, Optional<List<Tuple<Optional<List<AnnotationTreeImpl>>, Tuple<InternalSyntaxToken, InternalSyntaxToken>>>> dimensions, Optional<VariableTreeImpl> partial) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(identifierToken);
        JavaTree.ArrayTypeTreeImpl nestedDimensions = TreeFactory.newArrayTypeTreeWithAnnotations(dimensions);
        if (partial.isPresent()) {
            return ((VariableTreeImpl)partial.get()).completeIdentifierAndDims(identifier, nestedDimensions);
        }
        return new VariableTreeImpl(identifier, nestedDimensions);
    }

    public VariableTreeImpl newVariableDeclarator(InternalSyntaxToken equalToken, ExpressionTree initializer) {
        return new VariableTreeImpl(equalToken, initializer);
    }

    public BlockTreeImpl block(InternalSyntaxToken openBraceToken, BlockStatementListTreeImpl blockStatements, InternalSyntaxToken closeBraceToken) {
        return new BlockTreeImpl(openBraceToken, blockStatements, closeBraceToken);
    }

    public AssertStatementTreeImpl completeAssertStatement(InternalSyntaxToken assertToken, ExpressionTree expression, Optional<AssertStatementTreeImpl> detailExpression, InternalSyntaxToken semicolonSyntaxToken) {
        return detailExpression.isPresent() ? ((AssertStatementTreeImpl)detailExpression.get()).complete(assertToken, expression, semicolonSyntaxToken) : new AssertStatementTreeImpl(assertToken, expression, semicolonSyntaxToken);
    }

    public AssertStatementTreeImpl newAssertStatement(InternalSyntaxToken colonToken, ExpressionTree expression) {
        return new AssertStatementTreeImpl(colonToken, expression);
    }

    public IfStatementTreeImpl completeIf(InternalSyntaxToken ifToken, InternalSyntaxToken openParenToken, ExpressionTree condition, InternalSyntaxToken closeParenToken, StatementTree statement, Optional<IfStatementTreeImpl> elseClause) {
        if (elseClause.isPresent()) {
            return ((IfStatementTreeImpl)elseClause.get()).complete(ifToken, openParenToken, condition, closeParenToken, statement);
        }
        return new IfStatementTreeImpl(ifToken, openParenToken, condition, closeParenToken, statement);
    }

    public IfStatementTreeImpl newIfWithElse(InternalSyntaxToken elseToken, StatementTree elseStatement) {
        return new IfStatementTreeImpl(elseToken, elseStatement);
    }

    public ForStatementTreeImpl newStandardForStatement(InternalSyntaxToken forTokenKeyword, InternalSyntaxToken openParenToken, Optional<StatementExpressionListTreeImpl> forInit, InternalSyntaxToken forInitSemicolonToken, Optional<ExpressionTree> expression, InternalSyntaxToken expressionSemicolonToken, Optional<StatementExpressionListTreeImpl> forUpdate, InternalSyntaxToken closeParenToken, StatementTree statement) {
        StatementExpressionListTreeImpl forInitStatement = (StatementExpressionListTreeImpl)forInit.or((Object)new StatementExpressionListTreeImpl((List<? extends StatementTree>)ImmutableList.of(), (List<SyntaxToken>)ImmutableList.of()));
        StatementExpressionListTreeImpl forUpdateStatement = (StatementExpressionListTreeImpl)forUpdate.or((Object)new StatementExpressionListTreeImpl((List<? extends StatementTree>)ImmutableList.of(), (List<SyntaxToken>)ImmutableList.of()));
        return new ForStatementTreeImpl(forTokenKeyword, openParenToken, forInitStatement, forInitSemicolonToken, (ExpressionTree)expression.orNull(), expressionSemicolonToken, forUpdateStatement, closeParenToken, statement);
    }

    public StatementExpressionListTreeImpl newForInitDeclaration(ModifiersTreeImpl modifiers, TypeTree type, VariableDeclaratorListTreeImpl variables) {
        for (VariableTreeImpl variable : variables) {
            variable.completeModifiersAndType(modifiers, type);
        }
        return new StatementExpressionListTreeImpl(variables, (List<SyntaxToken>)ImmutableList.of());
    }

    public StatementExpressionListTreeImpl newStatementExpressions(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> rests) {
        ImmutableList.Builder statements = ImmutableList.builder();
        statements.add((Object)new ExpressionStatementTreeImpl(expression, null));
        ImmutableList.Builder separators = ImmutableList.builder();
        if (rests.isPresent()) {
            for (Tuple rest : (List)rests.get()) {
                separators.add(rest.first());
                statements.add((Object)new ExpressionStatementTreeImpl((ExpressionTree)rest.second(), null));
            }
        }
        return new StatementExpressionListTreeImpl((List<? extends StatementTree>)statements.build(), (List<SyntaxToken>)separators.build());
    }

    public ForEachStatementImpl newForeachStatement(InternalSyntaxToken forKeyword, InternalSyntaxToken openParenToken, VariableTreeImpl variable, InternalSyntaxToken colonToken, ExpressionTree expression, InternalSyntaxToken closeParenToken, StatementTree statement) {
        return new ForEachStatementImpl(forKeyword, openParenToken, variable, colonToken, expression, closeParenToken, statement);
    }

    public WhileStatementTreeImpl whileStatement(InternalSyntaxToken whileToken, InternalSyntaxToken openParen, ExpressionTree expression, InternalSyntaxToken closeParen, StatementTree statement) {
        return new WhileStatementTreeImpl(whileToken, openParen, expression, closeParen, statement);
    }

    public DoWhileStatementTreeImpl doWhileStatement(InternalSyntaxToken doToken, StatementTree statement, InternalSyntaxToken whileToken, InternalSyntaxToken openParen, ExpressionTree expression, InternalSyntaxToken closeParen, InternalSyntaxToken semicolon) {
        return new DoWhileStatementTreeImpl(doToken, statement, whileToken, openParen, expression, closeParen, semicolon);
    }

    public TryStatementTreeImpl completeStandardTryStatement(InternalSyntaxToken tryToken, BlockTreeImpl block, TryStatementTreeImpl partial) {
        return partial.completeStandardTry(tryToken, block);
    }

    public TryStatementTreeImpl newTryCatch(Optional<List<CatchTreeImpl>> catches, Optional<TryStatementTreeImpl> finallyBlock) {
        List catchTrees = (List)catches.or((Object)ImmutableList.of());
        if (finallyBlock.isPresent()) {
            return ((TryStatementTreeImpl)finallyBlock.get()).completeWithCatches(catchTrees);
        }
        return new TryStatementTreeImpl(catchTrees, null, null);
    }

    public CatchTreeImpl newCatchClause(InternalSyntaxToken catchToken, InternalSyntaxToken openParenToken, VariableTreeImpl parameter, InternalSyntaxToken closeParenToken, BlockTreeImpl block) {
        return new CatchTreeImpl(catchToken, openParenToken, parameter, closeParenToken, block);
    }

    public VariableTreeImpl newCatchFormalParameter(ModifiersTreeImpl modifiers, TypeTree type, VariableTreeImpl parameter) {
        if (!modifiers.isEmpty()) {
            parameter.completeModifiers(modifiers);
        }
        return parameter.completeType(type);
    }

    public TypeTree newCatchType(TypeTree qualifiedIdentifier, Optional<List<Tuple<InternalSyntaxToken, TypeTree>>> rests) {
        if (!rests.isPresent()) {
            return qualifiedIdentifier;
        }
        ImmutableList.Builder types = ImmutableList.builder();
        types.add((Object)qualifiedIdentifier);
        ImmutableList.Builder separators = ImmutableList.builder();
        for (Tuple rest : (List)rests.get()) {
            separators.add(rest.first());
            types.add(rest.second());
        }
        return new JavaTree.UnionTypeTreeImpl(new TypeUnionListTreeImpl((List<TypeTree>)types.build(), (List<SyntaxToken>)separators.build()));
    }

    public TryStatementTreeImpl newFinallyBlock(InternalSyntaxToken finallyToken, BlockTreeImpl block) {
        return new TryStatementTreeImpl(finallyToken, block);
    }

    public TryStatementTreeImpl newTryWithResourcesStatement(InternalSyntaxToken tryToken, InternalSyntaxToken openParenToken, ResourceListTreeImpl resources, InternalSyntaxToken closeParenToken, BlockTreeImpl block, Optional<List<CatchTreeImpl>> catches, Optional<TryStatementTreeImpl> finallyBlock) {
        List catchTrees = (List)catches.or((Object)ImmutableList.of());
        if (finallyBlock.isPresent()) {
            return ((TryStatementTreeImpl)finallyBlock.get()).completeTryWithResources(tryToken, openParenToken, resources, closeParenToken, block, catchTrees);
        }
        return new TryStatementTreeImpl(tryToken, openParenToken, resources, closeParenToken, block, catchTrees);
    }

    public ResourceListTreeImpl newResources(List<Tuple<VariableTreeImpl, Optional<InternalSyntaxToken>>> rests) {
        ImmutableList.Builder resources = ImmutableList.builder();
        ImmutableList.Builder separators = ImmutableList.builder();
        for (Tuple<VariableTreeImpl, Optional<InternalSyntaxToken>> rest : rests) {
            if (rest.second().isPresent()) {
                separators.add(rest.second().get());
            }
            resources.add((Object)rest.first());
        }
        return new ResourceListTreeImpl((List<VariableTree>)resources.build(), (List<SyntaxToken>)separators.build());
    }

    public VariableTreeImpl newResource(ModifiersTreeImpl modifiers, TypeTree classType, VariableTreeImpl partial, InternalSyntaxToken equalToken, ExpressionTree expression) {
        if (!modifiers.isEmpty()) {
            partial.completeModifiers(modifiers);
        }
        return partial.completeTypeAndInitializer(classType, equalToken, expression);
    }

    public SwitchStatementTreeImpl switchStatement(InternalSyntaxToken switchToken, InternalSyntaxToken openParenToken, ExpressionTree expression, InternalSyntaxToken closeParenToken, InternalSyntaxToken openBraceToken, Optional<List<CaseGroupTreeImpl>> optionalGroups, InternalSyntaxToken closeBraceToken) {
        List groups = (List)optionalGroups.or(Collections.emptyList());
        return new SwitchStatementTreeImpl(switchToken, openParenToken, expression, closeParenToken, openBraceToken, groups, closeBraceToken);
    }

    public CaseGroupTreeImpl switchGroup(List<CaseLabelTreeImpl> labels, BlockStatementListTreeImpl blockStatements) {
        return new CaseGroupTreeImpl(labels, blockStatements);
    }

    public CaseLabelTreeImpl newCaseSwitchLabel(InternalSyntaxToken caseSyntaxToken, ExpressionTree expression, InternalSyntaxToken colonSyntaxToken) {
        return new CaseLabelTreeImpl(caseSyntaxToken, expression, colonSyntaxToken);
    }

    public CaseLabelTreeImpl newDefaultSwitchLabel(InternalSyntaxToken defaultToken, InternalSyntaxToken colonToken) {
        return new CaseLabelTreeImpl(defaultToken, null, colonToken);
    }

    public SynchronizedStatementTreeImpl synchronizedStatement(InternalSyntaxToken synchronizedToken, InternalSyntaxToken openParenToken, ExpressionTree expression, InternalSyntaxToken closeParenToken, BlockTreeImpl block) {
        return new SynchronizedStatementTreeImpl(synchronizedToken, openParenToken, expression, closeParenToken, block);
    }

    public BreakStatementTreeImpl breakStatement(InternalSyntaxToken breakToken, Optional<InternalSyntaxToken> identifierToken, InternalSyntaxToken semicolonSyntaxToken) {
        IdentifierTreeImpl identifier = null;
        if (identifierToken.isPresent()) {
            identifier = new IdentifierTreeImpl((InternalSyntaxToken)identifierToken.get());
        }
        return new BreakStatementTreeImpl(breakToken, identifier, semicolonSyntaxToken);
    }

    public ContinueStatementTreeImpl continueStatement(InternalSyntaxToken continueToken, Optional<InternalSyntaxToken> identifierToken, InternalSyntaxToken semicolonToken) {
        IdentifierTreeImpl identifier = null;
        if (identifierToken.isPresent()) {
            identifier = new IdentifierTreeImpl((InternalSyntaxToken)identifierToken.get());
        }
        return new ContinueStatementTreeImpl(continueToken, identifier, semicolonToken);
    }

    public ReturnStatementTreeImpl returnStatement(InternalSyntaxToken returnToken, Optional<ExpressionTree> expression, InternalSyntaxToken semicolonSyntaxToken) {
        return new ReturnStatementTreeImpl(returnToken, (ExpressionTree)expression.orNull(), semicolonSyntaxToken);
    }

    public ThrowStatementTreeImpl throwStatement(InternalSyntaxToken throwToken, ExpressionTree expression, InternalSyntaxToken semicolonToken) {
        return new ThrowStatementTreeImpl(throwToken, expression, semicolonToken);
    }

    public LabeledStatementTreeImpl labeledStatement(InternalSyntaxToken identifierToken, InternalSyntaxToken colon, StatementTree statement) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(identifierToken);
        return new LabeledStatementTreeImpl(identifier, colon, statement);
    }

    public ExpressionStatementTreeImpl expressionStatement(ExpressionTree expression, InternalSyntaxToken semicolonToken) {
        return new ExpressionStatementTreeImpl(expression, semicolonToken);
    }

    public EmptyStatementTreeImpl emptyStatement(InternalSyntaxToken semicolon) {
        return new EmptyStatementTreeImpl(semicolon);
    }

    public BlockStatementListTreeImpl blockStatements(Optional<List<BlockStatementListTreeImpl>> blockStatements) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (blockStatements.isPresent()) {
            for (BlockStatementListTreeImpl blockStatement : (List)blockStatements.get()) {
                builder.addAll((Iterable)blockStatement);
            }
        }
        return new BlockStatementListTreeImpl((List<? extends StatementTree>)builder.build());
    }

    public BlockStatementListTreeImpl wrapInBlockStatements(VariableDeclaratorListTreeImpl variables) {
        return new BlockStatementListTreeImpl(variables);
    }

    public BlockStatementListTreeImpl newInnerClassOrEnum(ModifiersTreeImpl modifiers, ClassTreeImpl classTree) {
        classTree.completeModifiers(modifiers);
        return new BlockStatementListTreeImpl((List<? extends StatementTree>)ImmutableList.of((Object)classTree));
    }

    public BlockStatementListTreeImpl wrapInBlockStatements(StatementTree statement) {
        return new BlockStatementListTreeImpl((List<? extends StatementTree>)ImmutableList.of((Object)statement));
    }

    public ExpressionTree assignmentExpression(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        if (!operatorAndOperands.isPresent()) {
            return expression;
        }
        ExpressionTree result = null;
        JavaTree lastOperator = null;
        for (OperatorAndOperand operatorAndOperand : Lists.reverse((List)((List)operatorAndOperands.get()))) {
            result = lastOperator == null ? operatorAndOperand.operand() : new AssignmentExpressionTreeImpl(this.kindMaps.getAssignmentOperator((JavaPunctuator)lastOperator.getGrammarRuleKey()), operatorAndOperand.operand(), (InternalSyntaxToken)lastOperator, result);
            lastOperator = operatorAndOperand.operator();
        }
        result = new AssignmentExpressionTreeImpl(this.kindMaps.getAssignmentOperator((JavaPunctuator)lastOperator.getGrammarRuleKey()), expression, (InternalSyntaxToken)lastOperator, result);
        return result;
    }

    public ExpressionTree completeTernaryExpression(ExpressionTree expression, Optional<ConditionalExpressionTreeImpl> partial) {
        return partial.isPresent() ? ((ConditionalExpressionTreeImpl)partial.get()).complete(expression) : expression;
    }

    public ConditionalExpressionTreeImpl newTernaryExpression(InternalSyntaxToken queryToken, ExpressionTree trueExpression, InternalSyntaxToken colonToken, ExpressionTree falseExpression) {
        return new ConditionalExpressionTreeImpl(queryToken, trueExpression, colonToken, falseExpression);
    }

    public ExpressionTree completeInstanceofExpression(ExpressionTree expression, Optional<InstanceOfTreeImpl> partial) {
        return partial.isPresent() ? ((InstanceOfTreeImpl)partial.get()).complete(expression) : expression;
    }

    public InstanceOfTreeImpl newInstanceofExpression(InternalSyntaxToken instanceofToken, TypeTree type) {
        return new InstanceOfTreeImpl(instanceofToken, type);
    }

    public VariableTreeImpl receiverParameterId(InternalSyntaxToken thisToken) {
        return new VariableTreeImpl(new IdentifierTreeImpl(thisToken), null);
    }

    private ExpressionTree binaryExpression(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        if (!operatorAndOperands.isPresent()) {
            return expression;
        }
        ExpressionTree result = expression;
        for (OperatorAndOperand operatorAndOperand : (List)operatorAndOperands.get()) {
            result = new BinaryExpressionTreeImpl(this.kindMaps.getBinaryOperator((JavaPunctuator)operatorAndOperand.operator().getGrammarRuleKey()), result, operatorAndOperand.operator(), operatorAndOperand.operand());
        }
        return result;
    }

    private OperatorAndOperand newOperatorAndOperand(InternalSyntaxToken operator, ExpressionTree operand) {
        return new OperatorAndOperand(operator, operand);
    }

    public OperatorAndOperand newOperatorAndOperand11(InternalSyntaxToken operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression10(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand10(InternalSyntaxToken operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression9(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand9(InternalSyntaxToken operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression8(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand8(InternalSyntaxToken operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression7(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand7(InternalSyntaxToken operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression6(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand6(InternalSyntaxToken operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression5(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand5(InternalSyntaxToken operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression4(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand4(InternalSyntaxToken operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression3(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand3(InternalSyntaxToken operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression2(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand2(InternalSyntaxToken operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression1(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand1(InternalSyntaxToken operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree newPrefixedExpression(InternalSyntaxToken operatorToken, ExpressionTree expression) {
        return new InternalPrefixUnaryExpression(this.kindMaps.getPrefixOperator((JavaPunctuator)operatorToken.getGrammarRuleKey()), operatorToken, expression);
    }

    public ExpressionTree newPostfixExpression(ExpressionTree expression, Optional<InternalSyntaxToken> postfixOperator) {
        ExpressionTree result = expression;
        if (postfixOperator.isPresent()) {
            InternalSyntaxToken postfixOperatorToken = (InternalSyntaxToken)postfixOperator.get();
            result = new InternalPostfixUnaryExpression(this.kindMaps.getPostfixOperator((JavaPunctuator)((InternalSyntaxToken)postfixOperator.get()).getGrammarRuleKey()), result, postfixOperatorToken);
        }
        return result;
    }

    public ExpressionTree newTildaExpression(InternalSyntaxToken tildaToken, ExpressionTree expression) {
        return new InternalPrefixUnaryExpression(Tree.Kind.BITWISE_COMPLEMENT, tildaToken, expression);
    }

    public ExpressionTree newBangExpression(InternalSyntaxToken bangToken, ExpressionTree expression) {
        return new InternalPrefixUnaryExpression(Tree.Kind.LOGICAL_COMPLEMENT, bangToken, expression);
    }

    public ExpressionTree completeCastExpression(InternalSyntaxToken openParenToken, TypeCastExpressionTreeImpl partial) {
        return partial.complete(openParenToken);
    }

    public TypeCastExpressionTreeImpl newBasicTypeCastExpression(JavaTree.PrimitiveTypeTreeImpl basicType, InternalSyntaxToken closeParenToken, ExpressionTree expression) {
        return new TypeCastExpressionTreeImpl(basicType, closeParenToken, expression);
    }

    public TypeCastExpressionTreeImpl newClassCastExpression(TypeTree type, Optional<Tuple<InternalSyntaxToken, BoundListTreeImpl>> classTypes, InternalSyntaxToken closeParenToken, ExpressionTree expression) {
        BoundListTreeImpl bounds = BoundListTreeImpl.emptyList();
        InternalSyntaxToken andToken = null;
        if (classTypes.isPresent()) {
            andToken = (InternalSyntaxToken)((Tuple)classTypes.get()).first();
            bounds = (BoundListTreeImpl)((Tuple)classTypes.get()).second();
        }
        return new TypeCastExpressionTreeImpl(type, andToken, bounds, closeParenToken, expression);
    }

    public ExpressionTree completeMethodReference(MethodReferenceTreeImpl partial, Optional<TypeArgumentListTreeImpl> typeArguments, InternalSyntaxToken newOrIdentifierToken) {
        TypeArguments typeArgs = null;
        if (typeArguments.isPresent()) {
            typeArgs = (TypeArguments)typeArguments.get();
        }
        partial.complete(typeArgs, new IdentifierTreeImpl(newOrIdentifierToken));
        return partial;
    }

    public MethodReferenceTreeImpl newSuperMethodReference(InternalSyntaxToken superToken, InternalSyntaxToken doubleColonToken) {
        IdentifierTreeImpl superIdentifier = new IdentifierTreeImpl(superToken);
        return new MethodReferenceTreeImpl(superIdentifier, doubleColonToken);
    }

    public MethodReferenceTreeImpl newTypeMethodReference(Tree type, InternalSyntaxToken doubleColonToken) {
        return new MethodReferenceTreeImpl(type, doubleColonToken);
    }

    public MethodReferenceTreeImpl newPrimaryMethodReference(ExpressionTree expression, InternalSyntaxToken doubleColonToken) {
        return new MethodReferenceTreeImpl(expression, doubleColonToken);
    }

    public ExpressionTree lambdaExpression(LambdaParameterListTreeImpl parameters, InternalSyntaxToken arrowToken, Tree body) {
        return new LambdaExpressionTreeImpl(parameters.openParenToken(), (List<VariableTree>)ImmutableList.builder().addAll((Iterable)parameters).build(), parameters.closeParenToken(), arrowToken, body);
    }

    public LambdaParameterListTreeImpl newInferedParameters(InternalSyntaxToken openParenToken, Optional<Tuple<VariableTreeImpl, Optional<List<Tuple<InternalSyntaxToken, VariableTreeImpl>>>>> identifiersOpt, InternalSyntaxToken closeParenToken) {
        ImmutableList.Builder params = ImmutableList.builder();
        if (identifiersOpt.isPresent()) {
            Tuple identifiers = (Tuple)identifiersOpt.get();
            VariableTreeImpl variable = (VariableTreeImpl)identifiers.first();
            params.add((Object)variable);
            VariableTreeImpl previousVariable = variable;
            if (((Optional)identifiers.second()).isPresent()) {
                for (Tuple identifier : (List)((Optional)identifiers.second()).get()) {
                    variable = (VariableTreeImpl)identifier.second();
                    params.add((Object)variable);
                    InternalSyntaxToken comma = (InternalSyntaxToken)identifier.first();
                    previousVariable.setEndToken(comma);
                    previousVariable = variable;
                }
            }
        }
        return new LambdaParameterListTreeImpl(openParenToken, (List<VariableTreeImpl>)params.build(), closeParenToken);
    }

    public LambdaParameterListTreeImpl formalLambdaParameters(FormalParametersListTreeImpl formalParameters) {
        return new LambdaParameterListTreeImpl(formalParameters.openParenToken(), formalParameters, formalParameters.closeParenToken());
    }

    public LambdaParameterListTreeImpl singleInferedParameter(VariableTreeImpl parameter) {
        return new LambdaParameterListTreeImpl(null, (List<VariableTreeImpl>)ImmutableList.of((Object)parameter), null);
    }

    public VariableTreeImpl newSimpleParameter(InternalSyntaxToken identifierToken) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(identifierToken);
        return new VariableTreeImpl(identifier);
    }

    public ParenthesizedTreeImpl parenthesizedExpression(InternalSyntaxToken leftParenSyntaxToken, ExpressionTree expression, InternalSyntaxToken rightParenSyntaxToken) {
        return new ParenthesizedTreeImpl(leftParenSyntaxToken, expression, rightParenSyntaxToken);
    }

    public ExpressionTree newExpression(InternalSyntaxToken newToken, Optional<List<AnnotationTreeImpl>> annotations, ExpressionTree partial) {
        TypeTree typeTree;
        if (partial.is(Tree.Kind.NEW_CLASS)) {
            NewClassTreeImpl newClassTree = (NewClassTreeImpl)partial;
            newClassTree.completeWithNewKeyword(newToken);
            typeTree = newClassTree.identifier();
        } else {
            NewArrayTreeImpl newArrayTree = (NewArrayTreeImpl)partial;
            newArrayTree.completeWithNewKeyword(newToken);
            typeTree = newArrayTree.type();
        }
        TreeFactory.completeTypeTreeWithAnnotations(typeTree, annotations);
        return partial;
    }

    public ExpressionTree newClassCreator(Optional<TypeArgumentListTreeImpl> typeArguments, TypeTree qualifiedIdentifier, NewClassTreeImpl classCreatorRest) {
        if (typeArguments.isPresent()) {
            classCreatorRest.completeWithTypeArguments((TypeArgumentListTreeImpl)typeArguments.get());
        }
        return classCreatorRest.completeWithIdentifier(qualifiedIdentifier);
    }

    public ExpressionTree newArrayCreator(TypeTree type, NewArrayTreeImpl partial) {
        return partial.complete(type);
    }

    public NewArrayTreeImpl completeArrayCreator(Optional<List<AnnotationTreeImpl>> annotations, NewArrayTreeImpl partial) {
        if (annotations.isPresent()) {
            partial.completeFirstDimension((List)annotations.get());
        }
        return partial;
    }

    public NewArrayTreeImpl newArrayCreatorWithInitializer(InternalSyntaxToken openBracketToken, InternalSyntaxToken closeBracketToken, Optional<List<Tuple<Optional<List<AnnotationTreeImpl>>, Tuple<InternalSyntaxToken, InternalSyntaxToken>>>> dimensions, NewArrayTreeImpl partial) {
        ImmutableList.Builder dDimensionsBuilder = ImmutableList.builder();
        dDimensionsBuilder.add((Object)new ArrayDimensionTreeImpl(openBracketToken, null, closeBracketToken));
        if (dimensions.isPresent()) {
            for (Tuple dim : (List)dimensions.get()) {
                List annotations = (List)((Optional)dim.first()).or((Object)ImmutableList.of());
                Tuple brackets = (Tuple)dim.second();
                dDimensionsBuilder.add((Object)new ArrayDimensionTreeImpl(annotations, (SyntaxToken)brackets.first(), null, (SyntaxToken)brackets.second()));
            }
        }
        return partial.completeDimensions((List<ArrayDimensionTree>)dDimensionsBuilder.build());
    }

    public NewArrayTreeImpl newArrayCreatorWithDimension(InternalSyntaxToken openBracketToken, ExpressionTree expression, InternalSyntaxToken closeBracketToken, Optional<List<ArrayAccessExpressionTreeImpl>> arrayAccesses, Optional<List<Tuple<Optional<List<AnnotationTreeImpl>>, Tuple<InternalSyntaxToken, InternalSyntaxToken>>>> dims) {
        ImmutableList.Builder dimensions = ImmutableList.builder();
        dimensions.add((Object)new ArrayDimensionTreeImpl(openBracketToken, expression, closeBracketToken));
        if (arrayAccesses.isPresent()) {
            for (ArrayAccessExpressionTreeImpl arrayAccess : (List)arrayAccesses.get()) {
                dimensions.add((Object)arrayAccess.dimension());
            }
        }
        if (dims.isPresent()) {
            for (Tuple dim : (List)dims.get()) {
                Tuple brackets = (Tuple)dim.second();
                List annotations = (List)((Optional)dim.first()).or((Object)ImmutableList.of());
                dimensions.add((Object)new ArrayDimensionTreeImpl(annotations, (SyntaxToken)brackets.first(), null, (SyntaxToken)brackets.second()));
            }
        }
        return new NewArrayTreeImpl((List<ArrayDimensionTree>)dimensions.build(), InitializerListTreeImpl.emptyList());
    }

    public ExpressionTree basicClassExpression(JavaTree.PrimitiveTypeTreeImpl basicType, Optional<List<Tuple<InternalSyntaxToken, InternalSyntaxToken>>> dimensions, InternalSyntaxToken dotToken, InternalSyntaxToken classToken) {
        IdentifierTreeImpl classIdentifier = new IdentifierTreeImpl(classToken);
        JavaTree.ArrayTypeTreeImpl nestedDimensions = TreeFactory.newArrayTypeTree(dimensions);
        TypeTree typeTree = TreeFactory.applyDim(basicType, nestedDimensions);
        return new MemberSelectExpressionTreeImpl((ExpressionTree)((Object)typeTree), dotToken, (IdentifierTree)classIdentifier);
    }

    public JavaTree.PrimitiveTypeTreeImpl newBasicType(Optional<List<AnnotationTreeImpl>> annotations, InternalSyntaxToken basicType) {
        JavaTree.PrimitiveTypeTreeImpl primitiveTypeTree = new JavaTree.PrimitiveTypeTreeImpl(basicType);
        TreeFactory.completeTypeTreeWithAnnotations((TypeTree)primitiveTypeTree, annotations);
        return primitiveTypeTree;
    }

    public ArgumentListTreeImpl completeArguments(InternalSyntaxToken openParenthesisToken, Optional<ArgumentListTreeImpl> expressions, InternalSyntaxToken closeParenthesisToken) {
        return expressions.isPresent() ? ((ArgumentListTreeImpl)expressions.get()).complete(openParenthesisToken, closeParenthesisToken) : new ArgumentListTreeImpl(openParenthesisToken, closeParenthesisToken);
    }

    public ArgumentListTreeImpl newArguments(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> rests) {
        ImmutableList.Builder expressions = ImmutableList.builder();
        expressions.add((Object)expression);
        ImmutableList.Builder separators = ImmutableList.builder();
        if (rests.isPresent()) {
            for (Tuple rest : (List)rests.get()) {
                separators.add(rest.first());
                expressions.add(rest.second());
            }
        }
        return new ArgumentListTreeImpl((List<ExpressionTree>)expressions.build(), (List<SyntaxToken>)separators.build());
    }

    public TypeTree annotationIdentifier(InternalSyntaxToken firstIdentifier, Optional<List<Tuple<InternalSyntaxToken, InternalSyntaxToken>>> rests) {
        ArrayList children = Lists.newArrayList();
        children.add(firstIdentifier);
        if (rests.isPresent()) {
            for (Tuple rest : (List)rests.get()) {
                children.add(rest.first());
                children.add(rest.second());
            }
        }
        AbstractTypedTree result = null;
        InternalSyntaxToken dotToken = null;
        for (InternalSyntaxToken child : children) {
            if (!child.getGrammarRuleKey().equals((Object)JavaTokenType.IDENTIFIER)) {
                dotToken = child;
                continue;
            }
            InternalSyntaxToken identifierToken = child;
            if (result == null) {
                result = new IdentifierTreeImpl(identifierToken);
                continue;
            }
            IdentifierTreeImpl identifier = new IdentifierTreeImpl(identifierToken);
            result = new MemberSelectExpressionTreeImpl((ExpressionTree)((Object)result), dotToken, (IdentifierTree)identifier);
        }
        return result;
    }

    public <T extends Tree> T newQualifiedIdentifier(ExpressionTree firstIdentifier, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> rests) {
        ExpressionTree result = firstIdentifier;
        if (rests.isPresent()) {
            for (Tuple rest : (List)rests.get()) {
                InternalSyntaxToken dotToken = (InternalSyntaxToken)rest.first();
                if (((ExpressionTree)rest.second()).is(Tree.Kind.IDENTIFIER)) {
                    result = new MemberSelectExpressionTreeImpl(result, dotToken, (IdentifierTree)((IdentifierTreeImpl)rest.second()));
                    continue;
                }
                if (((ExpressionTree)rest.second()).is(Tree.Kind.PARAMETERIZED_TYPE)) {
                    JavaTree.ParameterizedTypeTreeImpl parameterizedType = (JavaTree.ParameterizedTypeTreeImpl)rest.second();
                    IdentifierTreeImpl identifier = (IdentifierTreeImpl)parameterizedType.type();
                    result = new MemberSelectExpressionTreeImpl(result, dotToken, (IdentifierTree)identifier);
                    result = new JavaTree.ParameterizedTypeTreeImpl((TypeTree)((Object)result), (TypeArgumentListTreeImpl)parameterizedType.typeArguments());
                    continue;
                }
                throw new IllegalArgumentException();
            }
            TreeFactory.moveAnnotations(result, firstIdentifier);
        }
        return (T)result;
    }

    private static void moveAnnotations(ExpressionTree result, ExpressionTree firstIdentifier) {
        boolean isParameterizedType = firstIdentifier.is(Tree.Kind.PARAMETERIZED_TYPE);
        List<AnnotationTree> firstIdentifierAnnotations = isParameterizedType ? ((ParameterizedTypeTree)((Object)firstIdentifier)).annotations() : ((IdentifierTree)firstIdentifier).annotations();
        if (!firstIdentifierAnnotations.isEmpty()) {
            if (result.is(Tree.Kind.MEMBER_SELECT)) {
                ((MemberSelectExpressionTreeImpl)result).complete(firstIdentifierAnnotations);
            } else {
                ((JavaTree.ParameterizedTypeTreeImpl)result).complete(firstIdentifierAnnotations);
            }
            if (isParameterizedType) {
                ((JavaTree.ParameterizedTypeTreeImpl)firstIdentifier).complete((List<AnnotationTree>)ImmutableList.of());
            } else {
                ((IdentifierTreeImpl)firstIdentifier).complete((List<AnnotationTree>)ImmutableList.of());
            }
        }
    }

    public ExpressionTree newAnnotatedParameterizedIdentifier(Optional<List<AnnotationTreeImpl>> annotations, InternalSyntaxToken identifierToken, Optional<TypeArgumentListTreeImpl> typeArguments) {
        ImmutableList annotationList = annotations.isPresent() ? ImmutableList.builder().addAll((Iterable)annotations.get()).build() : ImmutableList.of();
        AbstractTypedTree result = new IdentifierTreeImpl(identifierToken);
        result = typeArguments.isPresent() ? new JavaTree.ParameterizedTypeTreeImpl((TypeTree)((Object)result), (TypeArgumentListTreeImpl)typeArguments.get()).complete((List<AnnotationTree>)annotationList) : result.complete((List<AnnotationTree>)annotationList);
        return result;
    }

    public NewArrayTreeImpl newArrayInitializer(InternalSyntaxToken openBraceToken, Optional<InternalSyntaxToken> optionalComma, Optional<List<Tuple<ExpressionTree, Optional<InternalSyntaxToken>>>> rests, InternalSyntaxToken closeBraceToken) {
        ImmutableList.Builder initializers = ImmutableList.builder();
        ImmutableList.Builder separators = ImmutableList.builder();
        if (optionalComma.isPresent()) {
            separators.add(optionalComma.get());
        }
        if (rests.isPresent()) {
            for (Tuple rest : (List)rests.get()) {
                initializers.add(rest.first());
                if (!((Optional)rest.second()).isPresent()) continue;
                separators.add(((Optional)rest.second()).get());
            }
        }
        return new NewArrayTreeImpl((List<ArrayDimensionTree>)ImmutableList.of(), new InitializerListTreeImpl((List<ExpressionTree>)initializers.build(), (List<SyntaxToken>)separators.build())).completeWithCurlyBraces(openBraceToken, closeBraceToken);
    }

    public QualifiedIdentifierListTreeImpl newQualifiedIdentifierList(TypeTree qualifiedIdentifier, Optional<List<Tuple<InternalSyntaxToken, TypeTree>>> rests) {
        ImmutableList.Builder qualifiedIdentifiers = ImmutableList.builder();
        ImmutableList.Builder separators = ImmutableList.builder();
        qualifiedIdentifiers.add((Object)qualifiedIdentifier);
        if (rests.isPresent()) {
            for (Tuple rest : (List)rests.get()) {
                separators.add(rest.first());
                qualifiedIdentifiers.add(rest.second());
            }
        }
        return new QualifiedIdentifierListTreeImpl((List<TypeTree>)qualifiedIdentifiers.build(), (List<SyntaxToken>)separators.build());
    }

    public ArrayAccessExpressionTreeImpl newArrayAccessExpression(Optional<List<AnnotationTreeImpl>> annotations, InternalSyntaxToken openBracketToken, ExpressionTree index, InternalSyntaxToken closeBracketToken) {
        return new ArrayAccessExpressionTreeImpl(new ArrayDimensionTreeImpl((List)annotations.or((Object)ImmutableList.of()), openBracketToken, index, closeBracketToken));
    }

    public NewClassTreeImpl newClassCreatorRest(ArgumentListTreeImpl arguments, Optional<ClassTreeImpl> classBody) {
        return new NewClassTreeImpl(arguments, (ClassTreeImpl)classBody.orNull());
    }

    public ExpressionTree newIdentifierOrMethodInvocation(Optional<TypeArgumentListTreeImpl> typeArguments, InternalSyntaxToken identifierToken, Optional<ArgumentListTreeImpl> arguments) {
        IdentifierTreeImpl identifier;
        AbstractTypedTree result = identifier = new IdentifierTreeImpl(identifierToken);
        if (arguments.isPresent()) {
            result = new MethodInvocationTreeImpl(identifier, (TypeArguments)typeArguments.orNull(), (ArgumentListTreeImpl)arguments.get());
        }
        return result;
    }

    public Tuple<Optional<InternalSyntaxToken>, ExpressionTree> completeMemberSelectOrMethodSelector(InternalSyntaxToken dotToken, ExpressionTree partial) {
        return this.newTuple(Optional.of((Object)dotToken), partial);
    }

    public Tuple<Optional<InternalSyntaxToken>, ExpressionTree> completeCreatorSelector(InternalSyntaxToken dotToken, ExpressionTree partial) {
        ((NewClassTreeImpl)partial).completeWithDotToken(dotToken);
        return this.newTuple(Optional.absent(), partial);
    }

    public ExpressionTree newDotClassSelector(Optional<List<Tuple<InternalSyntaxToken, InternalSyntaxToken>>> dimensions, InternalSyntaxToken dotToken, InternalSyntaxToken classToken) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(classToken);
        JavaTree.ArrayTypeTreeImpl nestedDimensions = TreeFactory.newArrayTypeTree(dimensions);
        return new MemberSelectExpressionTreeImpl(nestedDimensions, dotToken, identifier);
    }

    private static ExpressionTree applySelectors(ExpressionTree primary, Optional<List<Tuple<Optional<InternalSyntaxToken>, ExpressionTree>>> selectors) {
        ExpressionTree result = primary;
        if (selectors.isPresent()) {
            for (Tuple tuple : (List)selectors.get()) {
                Optional dotTokenOptional = (Optional)tuple.first();
                ExpressionTree selector = (ExpressionTree)tuple.second();
                if (dotTokenOptional.isPresent()) {
                    InternalSyntaxToken dotToken = (InternalSyntaxToken)dotTokenOptional.get();
                    if (selector.is(Tree.Kind.IDENTIFIER)) {
                        IdentifierTreeImpl identifier = (IdentifierTreeImpl)selector;
                        result = new MemberSelectExpressionTreeImpl(result, dotToken, (IdentifierTree)identifier);
                        continue;
                    }
                    MethodInvocationTreeImpl methodInvocation = (MethodInvocationTreeImpl)selector;
                    IdentifierTreeImpl identifier = (IdentifierTreeImpl)methodInvocation.methodSelect();
                    MemberSelectExpressionTreeImpl memberSelect = new MemberSelectExpressionTreeImpl(result, dotToken, (IdentifierTree)identifier);
                    result = new MethodInvocationTreeImpl(memberSelect, methodInvocation.typeArguments(), (ArgumentListTreeImpl)methodInvocation.arguments());
                    continue;
                }
                if (selector.is(Tree.Kind.NEW_CLASS)) {
                    NewClassTreeImpl newClass = (NewClassTreeImpl)selector;
                    result = newClass.completeWithEnclosingExpression(result);
                    continue;
                }
                if (selector.is(Tree.Kind.ARRAY_ACCESS_EXPRESSION)) {
                    ArrayAccessExpressionTreeImpl arrayAccess = (ArrayAccessExpressionTreeImpl)selector;
                    result = arrayAccess.complete(result);
                    continue;
                }
                if (selector.is(Tree.Kind.MEMBER_SELECT)) {
                    MemberSelectExpressionTreeImpl memberSelect = (MemberSelectExpressionTreeImpl)selector;
                    result = memberSelect.completeWithExpression(result);
                    continue;
                }
                throw new IllegalStateException();
            }
        }
        return result;
    }

    public ExpressionTree applySelectors1(ExpressionTree primary, Optional<List<Tuple<Optional<InternalSyntaxToken>, ExpressionTree>>> selectors) {
        return TreeFactory.applySelectors(primary, selectors);
    }

    private <T, U> Tuple<T, U> newTuple(T first, U second) {
        return new Tuple<T, U>(first, second);
    }

    public <T, U> Tuple<T, U> newTuple1(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple2(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple3(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple4(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple5(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple6(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple7(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple8(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple10(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple11(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple12(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple14(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple16(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple17(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple18(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple19(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple20(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple21(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple22(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple23(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple24(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple25(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple26(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple27(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple28(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple29(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newAnnotatedDimension(T first, U second) {
        return this.newTuple(first, second);
    }

    public <U> Tuple<Optional<InternalSyntaxToken>, U> newTupleAbsent1(U expression) {
        return this.newTuple(Optional.absent(), expression);
    }

    public <U> Tuple<Optional<InternalSyntaxToken>, U> newTupleAbsent2(U expression) {
        return this.newTuple(Optional.absent(), expression);
    }

    private static TypeTree applyDim(TypeTree expression, @Nullable JavaTree.ArrayTypeTreeImpl dim) {
        if (dim != null) {
            dim.setLastChildType(expression);
            return dim;
        }
        return expression;
    }

    @CheckForNull
    private static JavaTree.ArrayTypeTreeImpl newArrayTypeTreeWithAnnotations(Optional<List<Tuple<Optional<List<AnnotationTreeImpl>>, Tuple<InternalSyntaxToken, InternalSyntaxToken>>>> dims) {
        JavaTree.ArrayTypeTreeImpl result = null;
        if (dims.isPresent()) {
            for (Tuple dim : (List)dims.get()) {
                result = TreeFactory.newArrayTypeTreeWithAnnotations(result, dim);
            }
        }
        return result;
    }

    private static JavaTree.ArrayTypeTreeImpl newArrayTypeTreeWithAnnotations(TypeTree type, Tuple<Optional<List<AnnotationTreeImpl>>, Tuple<InternalSyntaxToken, InternalSyntaxToken>> dim) {
        List annotations = (List)dim.first().or((Object)ImmutableList.of());
        InternalSyntaxToken openBracketToken = dim.second().first();
        InternalSyntaxToken closeBracketToken = dim.second().second();
        return new JavaTree.ArrayTypeTreeImpl(type, annotations, openBracketToken, closeBracketToken);
    }

    @CheckForNull
    private static JavaTree.ArrayTypeTreeImpl newArrayTypeTree(Optional<List<Tuple<InternalSyntaxToken, InternalSyntaxToken>>> dims) {
        JavaTree.ArrayTypeTreeImpl result = null;
        if (dims.isPresent()) {
            for (Tuple dim : (List)dims.get()) {
                InternalSyntaxToken openBracketToken = (InternalSyntaxToken)dim.first();
                InternalSyntaxToken closeBracketToken = (InternalSyntaxToken)dim.second();
                result = new JavaTree.ArrayTypeTreeImpl(result, (List<AnnotationTreeImpl>)ImmutableList.of(), openBracketToken, closeBracketToken);
            }
        }
        return result;
    }

    private static void completeTypeTreeWithAnnotations(TypeTree type, Optional<List<AnnotationTreeImpl>> annotations) {
        if (annotations.isPresent()) {
            ImmutableList typeAnnotations = ImmutableList.builder().addAll((Iterable)annotations.get()).build();
            TreeFactory.completeTypeTreeWithAnnotations(type, (List<AnnotationTree>)typeAnnotations);
        }
    }

    private static void completeTypeTreeWithAnnotations(TypeTree type, List<AnnotationTree> typeAnnotations) {
        if (type.is(Tree.Kind.IDENTIFIER)) {
            ((IdentifierTreeImpl)type).complete(typeAnnotations);
        } else if (type.is(Tree.Kind.MEMBER_SELECT)) {
            ((MemberSelectExpressionTreeImpl)type).complete(typeAnnotations);
        } else if (type.is(Tree.Kind.PARAMETERIZED_TYPE)) {
            ((JavaTree.ParameterizedTypeTreeImpl)type).complete(typeAnnotations);
        } else if (type.is(Tree.Kind.ARRAY_TYPE)) {
            ((JavaTree.ArrayTypeTreeImpl)type).complete(typeAnnotations);
        } else {
            ((JavaTree.PrimitiveTypeTreeImpl)type).complete(typeAnnotations);
        }
    }

    public static class Tuple<T, U> {
        private final T first;
        private final U second;

        public Tuple(T first, U second) {
            this.first = first;
            this.second = second;
        }

        public T first() {
            return this.first;
        }

        public U second() {
            return this.second;
        }
    }

    private static class OperatorAndOperand {
        private final InternalSyntaxToken operator;
        private final ExpressionTree operand;

        public OperatorAndOperand(InternalSyntaxToken operator, ExpressionTree operand) {
            this.operator = operator;
            this.operand = operand;
        }

        public InternalSyntaxToken operator() {
            return this.operator;
        }

        public ExpressionTree operand() {
            return this.operand;
        }
    }
}

