/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.loader;

import com.google.common.collect.Iterators;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.sonar.java.bytecode.loader.FileSystemLoader;
import org.sonar.java.bytecode.loader.JarLoader;
import org.sonar.java.bytecode.loader.Loader;

public class SquidClassLoader
extends ClassLoader
implements Closeable {
    private final List<Loader> loaders = new ArrayList<Loader>();

    public SquidClassLoader(List<File> files) {
        super(null);
        for (File file : files) {
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                this.loaders.add(new FileSystemLoader(file));
                continue;
            }
            if (!file.getName().endsWith(".jar")) continue;
            this.loaders.add(new JarLoader(file));
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String resourceName = name.replace('.', '/') + ".class";
        for (Loader loader : this.loaders) {
            byte[] classBytes = loader.loadBytes(resourceName);
            if (!ArrayUtils.isNotEmpty((byte[])classBytes)) continue;
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL findResource(String name) {
        for (Loader loader : this.loaders) {
            URL url = loader.findResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Loader loader : this.loaders) {
            URL url = loader.findResource(name);
            if (url == null) continue;
            result.add(url);
        }
        return Iterators.asEnumeration(result.iterator());
    }

    @Override
    public void close() {
        for (Loader loader : this.loaders) {
            loader.close();
        }
    }
}

