/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.declaration;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.java.ast.parser.JavaLexer;
import org.sonar.java.ast.parser.ListTreeImpl;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifierTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ModifiersTreeImpl
extends ListTreeImpl<ModifierTree>
implements ModifiersTree {
    private final List<ModifierKeywordTree> modifiers;
    private final List<AnnotationTree> annotations;

    public static ModifiersTreeImpl emptyModifiers() {
        return new ModifiersTreeImpl((List<ModifierTree>)ImmutableList.of());
    }

    public ModifiersTreeImpl(List<ModifierTree> javaTrees) {
        super(JavaLexer.MODIFIERS, javaTrees);
        ImmutableList.Builder modifierBuilder = ImmutableList.builder();
        ImmutableList.Builder annotationBuilder = ImmutableList.builder();
        for (ModifierTree modifierTree : this) {
            if (modifierTree.is(Tree.Kind.ANNOTATION)) {
                annotationBuilder.add((Object)((AnnotationTree)modifierTree));
                continue;
            }
            modifierBuilder.add((Object)((ModifierKeywordTree)modifierTree));
        }
        this.annotations = annotationBuilder.build();
        this.modifiers = modifierBuilder.build();
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.MODIFIERS;
    }

    @Override
    public List<ModifierKeywordTree> modifiers() {
        return this.modifiers;
    }

    @Override
    public List<AnnotationTree> annotations() {
        return this.annotations;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitModifier(this);
    }
}

