/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ConstraintManager;
import org.sonar.java.se.ObjectConstraint;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.SymbolicValueFactory;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2222", name="Locks should be released", priority=Priority.CRITICAL, tags={"bug", "cwe", "multi-threading"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SYNCHRONIZATION_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class LocksNotUnlockedCheck
extends SECheck
implements JavaFileScanner {
    @Override
    public void scanFile(JavaFileScannerContext context) {
        Multimap<Tree, String> issues = ((DefaultJavaFileScannerContext)context).getSEIssues(LocksNotUnlockedCheck.class);
        for (Map.Entry issue : issues.entries()) {
            context.reportIssue(this, (Tree)issue.getKey(), (String)issue.getValue());
        }
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        List<ObjectConstraint> constraints = context.getState().getFieldConstraints((Object)Status.LOCKED);
        for (ObjectConstraint constraint : constraints) {
            Tree syntaxNode = constraint.syntaxNode();
            context.reportIssue(syntaxNode, this, "Unlock \"" + syntaxNode.toString() + "\" along all executions paths of this method.");
        }
    }

    private static class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private static final String LOCK = "java.util.concurrent.locks.Lock";
        private static final String LOCK_METHOD_NAME = "lock";
        private static final String TRY_LOCK_METHOD_NAME = "tryLock";
        private static final String UNLOCK_METHOD_NAME = "unlock";
        private final ConstraintManager constraintManager;

        public PreStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.constraintManager = context.getConstraintManager();
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree syntaxNode) {
            MemberSelectExpressionTree memberSelect;
            ExpressionTree expression;
            if (syntaxNode.methodSelect().is(Tree.Kind.MEMBER_SELECT) && (expression = (memberSelect = (MemberSelectExpressionTree)syntaxNode.methodSelect()).expression()).is(Tree.Kind.IDENTIFIER) && expression.symbolType().isSubtypeOf(LOCK)) {
                String methodName = memberSelect.identifier().name();
                this.visitMethodInvocationWithIdentifierTarget(methodName, (IdentifierTree)expression);
            }
        }

        private void visitMethodInvocationWithIdentifierTarget(String methodName, IdentifierTree target) {
            if (!PreStatementVisitor.isMemberSelectActingOnField(target)) {
                SymbolicValue symbolicValue = this.programState.getValue(target.symbol());
                if (LOCK_METHOD_NAME.equals(methodName)) {
                    this.programState = this.programState.addConstraint(symbolicValue, new ObjectConstraint(false, false, target, (Object)Status.LOCKED));
                } else if (TRY_LOCK_METHOD_NAME.equals(methodName)) {
                    this.constraintManager.setValueFactory(new TryLockSymbolicValueFactory(symbolicValue));
                    this.programState = this.programState.addConstraint(symbolicValue, new ObjectConstraint(false, false, target, (Object)Status.LOCKED));
                } else if (UNLOCK_METHOD_NAME.equals(methodName)) {
                    this.programState = this.programState.addConstraint(symbolicValue, new ObjectConstraint(target, (Object)Status.UNLOCKED));
                }
            }
        }

        private static boolean isMemberSelectActingOnField(IdentifierTree expression) {
            Symbol symbol = expression.symbol();
            return ProgramState.isField(symbol);
        }
    }

    private static class TryLockSymbolicValueFactory
    implements SymbolicValueFactory {
        private final SymbolicValue operand;

        TryLockSymbolicValueFactory(SymbolicValue operand) {
            this.operand = operand;
        }

        @Override
        public SymbolicValue createSymbolicValue(int id, Tree syntaxNode) {
            return new TryLockSymbolicValue(id, this.operand, syntaxNode);
        }
    }

    private static class TryLockSymbolicValue
    extends SymbolicValue {
        private final SymbolicValue operand;
        private final Tree syntaxNode;

        public TryLockSymbolicValue(int id, SymbolicValue operand, Tree syntaxNode) {
            super(id);
            this.operand = operand;
            this.syntaxNode = syntaxNode;
        }

        @Override
        public boolean references(SymbolicValue other) {
            return this.operand.equals(other) || this.operand.references(other);
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, ConstraintManager.BooleanConstraint booleanConstraint) {
            if (ConstraintManager.BooleanConstraint.TRUE.equals((Object)booleanConstraint)) {
                return ImmutableList.of((Object)programState.addConstraint(this.operand, new ObjectConstraint(false, false, this.syntaxNode, (Object)Status.LOCKED)));
            }
            return ImmutableList.of((Object)programState.addConstraint(this.operand, new ObjectConstraint(this.syntaxNode, (Object)Status.UNLOCKED)));
        }

        @Override
        public String toString() {
            return super.toString() + ".tryLock()";
        }
    }

    private static enum Status {
        LOCKED,
        UNLOCKED;

    }
}

