/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.java.se.ConstraintManager;
import org.sonar.java.se.ObjectConstraint;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public abstract class BinarySymbolicValue
extends SymbolicValue {
    SymbolicValue leftOp;
    SymbolicValue rightOp;

    public BinarySymbolicValue(int id) {
        super(id);
    }

    public abstract ConstraintManager.BooleanConstraint shouldNotInverse();

    @Override
    public boolean references(SymbolicValue other) {
        return this.leftOp.equals(other) || this.rightOp.equals(other) || this.leftOp.references(other) || this.rightOp.references(other);
    }

    @Override
    public void computedFrom(List<SymbolicValue> symbolicValues) {
        Preconditions.checkArgument((symbolicValues.size() == 2 ? 1 : 0) != 0);
        this.rightOp = symbolicValues.get(0);
        this.leftOp = symbolicValues.get(1);
    }

    protected List<ProgramState> copyConstraint(SymbolicValue from, SymbolicValue to, ProgramState programState, ConstraintManager.BooleanConstraint booleanConstraint) {
        Object constraintLeft = programState.getConstraint(from);
        if (constraintLeft instanceof ConstraintManager.BooleanConstraint) {
            ConstraintManager.BooleanConstraint boolConstraint = (ConstraintManager.BooleanConstraint)((Object)constraintLeft);
            return to.setConstraint(programState, this.shouldNotInverse().equals((Object)booleanConstraint) ? boolConstraint : boolConstraint.inverse());
        }
        if (constraintLeft instanceof ObjectConstraint) {
            ObjectConstraint nullConstraint = (ObjectConstraint)constraintLeft;
            if (nullConstraint.equals(ObjectConstraint.NULL)) {
                return to.setConstraint(programState, this.shouldNotInverse().equals((Object)booleanConstraint) ? nullConstraint : nullConstraint.inverse());
            }
            if (this.shouldNotInverse().equals((Object)booleanConstraint)) {
                return to.setConstraint(programState, nullConstraint);
            }
        }
        return ImmutableList.of((Object)programState);
    }
}

