/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import javax.annotation.CheckForNull;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanRelation;
import org.sonar.java.se.symbolicvalues.LessThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.LessThanRelation;
import org.sonar.java.se.symbolicvalues.MethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.NotEqualRelation;
import org.sonar.java.se.symbolicvalues.NotMethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.RelationState;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public class EqualRelation
extends BinaryRelation {
    EqualRelation(SymbolicValue v1, SymbolicValue v2) {
        super(RelationalSymbolicValue.Kind.EQUAL, v1, v2);
    }

    @Override
    protected BinaryRelation symmetric() {
        return new EqualRelation(this.rightOp, this.leftOp);
    }

    @Override
    public BinaryRelation inverse() {
        return new NotEqualRelation(this.leftOp, this.rightOp);
    }

    @Override
    protected RelationState isImpliedBy(BinaryRelation relation) {
        return relation.impliesEqual();
    }

    @Override
    protected RelationState impliesEqual() {
        return RelationState.FULFILLED;
    }

    @Override
    protected RelationState impliesNotEqual() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesMethodEquals() {
        return RelationState.FULFILLED;
    }

    @Override
    protected RelationState impliesNotMethodEquals() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesGreaterThan() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesGreaterThanOrEqual() {
        return RelationState.FULFILLED;
    }

    @Override
    protected RelationState impliesLessThan() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesLessThanOrEqual() {
        return RelationState.FULFILLED;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedAfter(BinaryRelation relation) {
        return relation.combinedWithEqual(this);
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithEqual(EqualRelation relation) {
        return new EqualRelation(this.leftOp, relation.rightOp);
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithNotEqual(NotEqualRelation relation) {
        return new NotEqualRelation(this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithMethodEquals(MethodEqualsRelation relation) {
        return new MethodEqualsRelation(this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithNotMethodEquals(NotMethodEqualsRelation relation) {
        return new NotMethodEqualsRelation(this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithGreaterThan(GreaterThanRelation relation) {
        return new GreaterThanRelation(this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithGreaterThanOrEqual(GreaterThanOrEqualRelation relation) {
        return new GreaterThanOrEqualRelation(this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithLessThan(LessThanRelation relation) {
        return new LessThanRelation(this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithLessThanOrEqual(LessThanOrEqualRelation relation) {
        return new LessThanOrEqualRelation(this.leftOp, relation.rightOp);
    }
}

