/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.java.se.symbolicvalues.EqualRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanRelation;
import org.sonar.java.se.symbolicvalues.LessThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.LessThanRelation;
import org.sonar.java.se.symbolicvalues.MethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.NotEqualRelation;
import org.sonar.java.se.symbolicvalues.NotMethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.RelationState;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public class GreaterThanOrEqualRelation
extends BinaryRelation {
    GreaterThanOrEqualRelation(SymbolicValue v1, SymbolicValue v2) {
        super(RelationalSymbolicValue.Kind.GREATER_THAN_OR_EQUAL, v1, v2);
    }

    @Override
    protected BinaryRelation symmetric() {
        return new LessThanOrEqualRelation(this.rightOp, this.leftOp);
    }

    @Override
    public BinaryRelation inverse() {
        return new LessThanRelation(this.leftOp, this.rightOp);
    }

    @Override
    protected RelationState isImpliedBy(BinaryRelation relation) {
        return relation.impliesGreaterThanOrEqual();
    }

    @Override
    protected RelationState impliesEqual() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesNotEqual() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesMethodEquals() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesNotMethodEquals() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesGreaterThan() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesGreaterThanOrEqual() {
        return RelationState.FULFILLED;
    }

    @Override
    protected RelationState impliesLessThan() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesLessThanOrEqual() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected BinaryRelation combinedAfter(BinaryRelation relation) {
        return relation.combinedWithGreaterThanOrEqual(this);
    }

    @Override
    protected BinaryRelation combinedWithEqual(EqualRelation relation) {
        return new GreaterThanOrEqualRelation(this.leftOp, relation.rightOp);
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithNotEqual(NotEqualRelation relation) {
        return null;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithMethodEquals(MethodEqualsRelation relation) {
        return new GreaterThanOrEqualRelation(this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithNotMethodEquals(NotMethodEqualsRelation relation) {
        return null;
    }

    @Override
    protected BinaryRelation combinedWithGreaterThan(GreaterThanRelation relation) {
        return new GreaterThanRelation(this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithGreaterThanOrEqual(GreaterThanOrEqualRelation relation) {
        return new GreaterThanOrEqualRelation(this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithLessThan(LessThanRelation relation) {
        return null;
    }

    @Override
    protected BinaryRelation combinedWithLessThanOrEqual(LessThanOrEqualRelation relation) {
        return null;
    }

    @Override
    @CheckForNull
    protected BinaryRelation conjunction(BinaryRelation relation) {
        Preconditions.checkArgument((this.leftOp.equals(relation.leftOp) && this.rightOp.equals(relation.rightOp) ? 1 : 0) != 0, (Object)"Conjunction condition not matched!");
        switch (relation.kind) {
            case NOT_EQUAL: 
            case NOT_METHOD_EQUALS: {
                return new GreaterThanRelation(this.leftOp, this.rightOp);
            }
            case LESS_THAN_OR_EQUAL: {
                return new EqualRelation(this.leftOp, this.rightOp);
            }
        }
        return super.conjunction(relation);
    }
}

