/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import javax.annotation.CheckForNull;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.java.se.symbolicvalues.EqualRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.LessThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.LessThanRelation;
import org.sonar.java.se.symbolicvalues.MethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.NotEqualRelation;
import org.sonar.java.se.symbolicvalues.NotMethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.RelationState;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public class GreaterThanRelation
extends BinaryRelation {
    GreaterThanRelation(SymbolicValue v1, SymbolicValue v2) {
        super(RelationalSymbolicValue.Kind.GREATER_THAN, v1, v2);
    }

    @Override
    protected BinaryRelation symmetric() {
        return new LessThanRelation(this.rightOp, this.leftOp);
    }

    @Override
    public BinaryRelation inverse() {
        return new LessThanOrEqualRelation(this.leftOp, this.rightOp);
    }

    @Override
    protected RelationState isImpliedBy(BinaryRelation relation) {
        return relation.impliesGreaterThan();
    }

    @Override
    protected RelationState impliesEqual() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesNotEqual() {
        return RelationState.FULFILLED;
    }

    @Override
    protected RelationState impliesMethodEquals() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesNotMethodEquals() {
        return RelationState.FULFILLED;
    }

    @Override
    protected RelationState impliesGreaterThanOrEqual() {
        return RelationState.FULFILLED;
    }

    @Override
    protected RelationState impliesGreaterThan() {
        return RelationState.FULFILLED;
    }

    @Override
    protected RelationState impliesLessThan() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesLessThanOrEqual() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected BinaryRelation combinedAfter(BinaryRelation relation) {
        return relation.combinedWithGreaterThan(this);
    }

    @Override
    protected BinaryRelation combinedWithEqual(EqualRelation relation) {
        return new GreaterThanRelation(this.leftOp, relation.rightOp);
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithNotEqual(NotEqualRelation relation) {
        return null;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithMethodEquals(MethodEqualsRelation relation) {
        return new GreaterThanRelation(this.leftOp, relation.rightOp);
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithNotMethodEquals(NotMethodEqualsRelation relation) {
        return null;
    }

    @Override
    protected BinaryRelation combinedWithGreaterThan(GreaterThanRelation relation) {
        return new GreaterThanRelation(this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithGreaterThanOrEqual(GreaterThanOrEqualRelation relation) {
        return new GreaterThanRelation(this.leftOp, relation.rightOp);
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithLessThan(LessThanRelation relation) {
        return null;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithLessThanOrEqual(LessThanOrEqualRelation relation) {
        return null;
    }
}

