/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import javax.annotation.CheckForNull;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.java.se.symbolicvalues.EqualRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanRelation;
import org.sonar.java.se.symbolicvalues.LessThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.LessThanRelation;
import org.sonar.java.se.symbolicvalues.NotEqualRelation;
import org.sonar.java.se.symbolicvalues.NotMethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.RelationState;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public class MethodEqualsRelation
extends BinaryRelation {
    MethodEqualsRelation(SymbolicValue v1, SymbolicValue v2) {
        super(RelationalSymbolicValue.Kind.METHOD_EQUALS, v1, v2);
    }

    @Override
    protected BinaryRelation symmetric() {
        return new MethodEqualsRelation(this.rightOp, this.leftOp);
    }

    @Override
    public BinaryRelation inverse() {
        return new NotMethodEqualsRelation(this.leftOp, this.rightOp);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.leftOp);
        buffer.append(".equals(");
        buffer.append(this.rightOp);
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    protected RelationState isImpliedBy(BinaryRelation relation) {
        return relation.impliesMethodEquals();
    }

    @Override
    protected RelationState impliesEqual() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesNotEqual() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesMethodEquals() {
        return RelationState.FULFILLED;
    }

    @Override
    protected RelationState impliesNotMethodEquals() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesGreaterThan() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesGreaterThanOrEqual() {
        return RelationState.FULFILLED;
    }

    @Override
    protected RelationState impliesLessThan() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesLessThanOrEqual() {
        return RelationState.FULFILLED;
    }

    @Override
    protected BinaryRelation combinedAfter(BinaryRelation relation) {
        return relation.combinedWithMethodEquals(this);
    }

    @Override
    protected BinaryRelation combinedWithEqual(EqualRelation relation) {
        return new MethodEqualsRelation(this.leftOp, relation.rightOp);
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithNotEqual(NotEqualRelation relation) {
        return null;
    }

    @Override
    protected BinaryRelation combinedWithMethodEquals(MethodEqualsRelation relation) {
        return new MethodEqualsRelation(this.leftOp, relation.rightOp);
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithNotMethodEquals(NotMethodEqualsRelation relation) {
        return null;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithGreaterThan(GreaterThanRelation relation) {
        return null;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithGreaterThanOrEqual(GreaterThanOrEqualRelation relation) {
        return new GreaterThanOrEqualRelation(this.leftOp, relation.rightOp);
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithLessThan(LessThanRelation relation) {
        return null;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithLessThanOrEqual(LessThanOrEqualRelation relation) {
        return new LessThanOrEqualRelation(this.leftOp, relation.rightOp);
    }
}

