/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.java.se.ConstraintManager;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.java.se.symbolicvalues.BinarySymbolicValue;
import org.sonar.java.se.symbolicvalues.EqualRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanRelation;
import org.sonar.java.se.symbolicvalues.LessThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.LessThanRelation;
import org.sonar.java.se.symbolicvalues.MethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.NotEqualRelation;
import org.sonar.java.se.symbolicvalues.NotMethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.RelationState;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public class RelationalSymbolicValue
extends BinarySymbolicValue {
    private final Kind kind;

    public RelationalSymbolicValue(int id, Kind kind) {
        super(id);
        this.kind = kind;
    }

    @Override
    public ConstraintManager.BooleanConstraint shouldNotInverse() {
        switch (this.kind) {
            case EQUAL: 
            case METHOD_EQUALS: {
                return ConstraintManager.BooleanConstraint.TRUE;
            }
        }
        return ConstraintManager.BooleanConstraint.FALSE;
    }

    @Override
    public List<ProgramState> setConstraint(ProgramState initialProgramState, ConstraintManager.BooleanConstraint booleanConstraint) {
        ProgramState programState = initialProgramState;
        if (this.leftOp.equals(this.rightOp)) {
            if (this.shouldNotInverse().equals((Object)booleanConstraint)) {
                return ImmutableList.of((Object)programState);
            }
            return ImmutableList.of();
        }
        if ((programState = this.checkRelation(booleanConstraint, programState)) == null) {
            return ImmutableList.of();
        }
        ArrayList<ProgramState> results = new ArrayList<ProgramState>();
        List<ProgramState> copiedConstraints = this.copyConstraint(this.leftOp, this.rightOp, programState, booleanConstraint);
        for (ProgramState ps : copiedConstraints) {
            List<ProgramState> copiedConstraintsRightToLeft = this.copyConstraint(this.rightOp, this.leftOp, ps, booleanConstraint);
            if (copiedConstraintsRightToLeft.size() == 1 && copiedConstraintsRightToLeft.get(0).equals(programState)) {
                results.add(programState.addConstraint(this, (Object)booleanConstraint));
                continue;
            }
            results.addAll(copiedConstraintsRightToLeft);
        }
        return results;
    }

    @Override
    protected List<ProgramState> copyConstraint(SymbolicValue from, SymbolicValue to, ProgramState programState, ConstraintManager.BooleanConstraint booleanConstraint) {
        ProgramState newState = programState;
        if (programState.canReach(from) || programState.canReach(to)) {
            newState = programState.addConstraint(this, (Object)booleanConstraint);
        }
        return super.copyConstraint(from, to, newState, booleanConstraint);
    }

    @CheckForNull
    private ProgramState checkRelation(ConstraintManager.BooleanConstraint booleanConstraint, ProgramState programState) {
        RelationState relationState = this.binaryRelation().resolveState(programState.getKnownRelations());
        if (relationState.rejects(booleanConstraint)) {
            return null;
        }
        return programState;
    }

    @Override
    public BinaryRelation binaryRelation() {
        BinaryRelation relation;
        switch (this.kind) {
            case EQUAL: {
                relation = new EqualRelation(this.leftOp, this.rightOp);
                break;
            }
            case NOT_EQUAL: {
                relation = new NotEqualRelation(this.leftOp, this.rightOp);
                break;
            }
            case LESS_THAN: {
                relation = new LessThanRelation(this.leftOp, this.rightOp);
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                relation = new LessThanOrEqualRelation(this.leftOp, this.rightOp);
                break;
            }
            case GREATER_THAN: {
                relation = new GreaterThanRelation(this.leftOp, this.rightOp);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                relation = new GreaterThanOrEqualRelation(this.leftOp, this.rightOp);
                break;
            }
            case METHOD_EQUALS: {
                relation = new MethodEqualsRelation(this.leftOp, this.rightOp);
                break;
            }
            case NOT_METHOD_EQUALS: {
                relation = new NotMethodEqualsRelation(this.leftOp, this.rightOp);
                break;
            }
            default: {
                throw new IllegalStateException("Creation of relation of kind " + (Object)((Object)this.kind) + " is missing!");
            }
        }
        return relation;
    }

    @Override
    public String toString() {
        return this.binaryRelation().toString();
    }

    public static enum Kind {
        EQUAL("=="),
        NOT_EQUAL("!="),
        GREATER_THAN(">="),
        GREATER_THAN_OR_EQUAL(">="),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        METHOD_EQUALS(".EQ."),
        NOT_METHOD_EQUALS(".NE.");

        final String operand;

        private Kind(String operand) {
            this.operand = operand;
        }
    }
}

