/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.java.AbstractJavaClasspath;

public class JavaClasspath
extends AbstractJavaClasspath {
    private static final Logger LOG = LoggerFactory.getLogger(JavaClasspath.class);

    public JavaClasspath(Project project, Settings settings, FileSystem fs) {
        super(project, settings, fs, InputFile.Type.MAIN);
    }

    @Override
    protected void init() {
        if (!this.initialized) {
            boolean useDeprecatedProperties;
            this.initialized = true;
            this.validateLibraries = this.project.getModules().isEmpty();
            this.binaries = this.getFilesFromProperty("sonar.java.binaries");
            List<File> libraries = this.getFilesFromProperty("sonar.java.libraries");
            boolean bl = useDeprecatedProperties = this.binaries.isEmpty() && libraries.isEmpty();
            if (useDeprecatedProperties) {
                this.binaries = this.getFilesFromProperty("sonar.binaries");
                libraries = this.getFilesFromProperty("sonar.libraries");
            }
            this.elements = Lists.newArrayList((Iterable)this.binaries);
            this.elements.addAll(libraries);
            if (useDeprecatedProperties && !this.elements.isEmpty()) {
                LOG.warn("sonar.binaries and sonar.libraries are deprecated since version 2.5 of sonar-java-plugin, please use sonar.java.binaries and sonar.java.libraries instead");
            }
        }
    }
}

