/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.JavaConfiguration;
import org.sonar.java.ast.parser.JavaParser;
import org.sonar.java.ast.visitors.VisitorContext;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.java.parser.sslr.ActionParser;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.ProgressReport;
import org.sonar.squidbridge.api.AnalysisException;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceCodeIndexer;
import org.sonar.squidbridge.api.SourceCodeSearchEngine;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourceProject;
import org.sonar.squidbridge.indexer.QueryByType;
import org.sonar.squidbridge.indexer.SquidIndex;

public class JavaAstScanner {
    private static final Logger LOG = LoggerFactory.getLogger(JavaAstScanner.class);
    private final SquidIndex index;
    private final ActionParser parser;
    private VisitorsBridge visitor;

    public JavaAstScanner(ActionParser parser) {
        this.parser = parser;
        this.index = new SquidIndex();
    }

    public JavaAstScanner(JavaAstScanner astScanner) {
        this.parser = astScanner.parser;
        this.index = astScanner.index;
    }

    public void scan(Iterable<File> files) {
        SourceProject project = new SourceProject("Java Project");
        this.index.index((SourceCode)project);
        project.setSourceCodeIndexer((SourceCodeIndexer)this.index);
        this.simpleScan(files);
    }

    public void simpleScan(Iterable<File> files) {
        SourceProject project = (SourceProject)this.index.search("Java Project");
        VisitorContext context = new VisitorContext(project);
        this.visitor.setContext(context);
        ProgressReport progressReport = new ProgressReport("Report about progress of Java AST analyzer", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start((Collection)Lists.newArrayList(files));
        for (File file : files) {
            context.setFile(file);
            try {
                Tree ast = this.parser.parse(file);
                this.visitor.visitFile(ast);
                progressReport.nextFile();
            }
            catch (RecognitionException e) {
                LOG.error("Unable to parse source file : " + file.getAbsolutePath());
                LOG.error(e.getMessage());
                this.parseErrorWalkAndVisit(e, file);
            }
            catch (Exception e) {
                throw new AnalysisException(JavaAstScanner.getAnalyisExceptionMessage(file), (Throwable)e);
            }
        }
        progressReport.stop();
    }

    private void parseErrorWalkAndVisit(RecognitionException e, File file) {
        try {
            this.visitor.visitFile(null);
            this.visitor.processRecognitionException(e);
        }
        catch (Exception e2) {
            throw new AnalysisException(JavaAstScanner.getAnalyisExceptionMessage(file), (Throwable)e2);
        }
    }

    private static String getAnalyisExceptionMessage(File file) {
        return "SonarQube is unable to analyze file : '" + file.getAbsolutePath() + "'";
    }

    public void setVisitorBridge(VisitorsBridge visitor) {
        this.visitor = visitor;
    }

    public SourceCodeSearchEngine getIndex() {
        return this.index;
    }

    @VisibleForTesting
    public static SourceFile scanSingleFile(File file, VisitorsBridge visitorsBridge) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File '" + file + "' not found.");
        }
        JavaAstScanner scanner = JavaAstScanner.create(new JavaConfiguration(Charset.forName("UTF-8")), visitorsBridge);
        scanner.scan(Collections.singleton(file));
        Collection sources = scanner.getIndex().search(new Query[]{new QueryByType(SourceFile.class)});
        if (sources.size() != 1) {
            throw new IllegalStateException("Only one SourceFile was expected whereas " + sources.size() + " has been returned.");
        }
        return (SourceFile)sources.iterator().next();
    }

    private static JavaAstScanner create(JavaConfiguration conf, @Nullable VisitorsBridge visitorsBridge) {
        JavaAstScanner astScanner = new JavaAstScanner(JavaParser.createParser(conf.getCharset()));
        if (visitorsBridge != null) {
            visitorsBridge.setCharset(conf.getCharset());
            astScanner.setVisitorBridge(visitorsBridge);
        }
        return astScanner;
    }
}

