/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.parser;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.ast.parser.JavaParser;
import org.sonar.java.model.JavaTree;
import org.sonar.java.parser.sslr.ActionParser;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

public class PrinterVisitor
extends BaseTreeVisitor {
    private static final int INDENT_SPACES = 2;
    private static final Logger LOG = LoggerFactory.getLogger(PrinterVisitor.class);
    private final StringBuilder sb;
    private final SemanticModel semanticModel;
    private final Map<IdentifierTree, JavaSymbol> idents = new HashMap<IdentifierTree, JavaSymbol>();
    private int indentLevel = 0;

    public PrinterVisitor(@Nullable SemanticModel semanticModel) {
        this.sb = new StringBuilder();
        this.semanticModel = semanticModel;
    }

    public static String print(Tree tree) {
        return PrinterVisitor.print(tree, null);
    }

    public static String print(Tree tree, @Nullable SemanticModel semanticModel) {
        PrinterVisitor pv = new PrinterVisitor(semanticModel);
        pv.scan(tree);
        return pv.sb.toString();
    }

    public static String print(List<? extends Tree> trees) {
        StringBuilder result = new StringBuilder();
        for (Tree tree : trees) {
            result.append(PrinterVisitor.print(tree));
        }
        return result.toString();
    }

    private StringBuilder indent() {
        return this.sb.append(StringUtils.leftPad((String)"", (int)(2 * this.indentLevel)));
    }

    @Override
    protected void scan(List<? extends Tree> trees) {
        if (!trees.isEmpty()) {
            this.sb.deleteCharAt(this.sb.length() - 1);
            this.sb.append(" : [\n");
            super.scan(trees);
            this.indent().append("]\n");
        }
    }

    @Override
    protected void scan(@Nullable Tree tree) {
        if (tree != null) {
            JavaSymbol sym = null;
            try {
                Method getSymbol = null;
                for (Method method : tree.getClass().getMethods()) {
                    if (!"getSymbol".equals(method.getName())) continue;
                    getSymbol = tree.getClass().getMethod("getSymbol", new Class[0]);
                }
                if (getSymbol != null) {
                    sym = (JavaSymbol)getSymbol.invoke((Object)tree, new Object[0]);
                }
            }
            catch (Exception e) {
                LOG.error("An error occured while retrieving symbol ", (Throwable)e);
            }
            Tree.Kind kind = ((JavaTree)tree).getKind();
            String nodeName = ((JavaTree)tree).getClass().getSimpleName();
            if (kind != null) {
                nodeName = kind.getAssociatedInterface().getSimpleName();
            }
            this.indent().append(nodeName);
            int line = ((JavaTree)tree).getLine();
            if (line >= 0) {
                this.sb.append(" ").append(line);
            }
            if (this.idents.get(tree) != null) {
                Preconditions.checkState((sym == null ? 1 : 0) != 0);
                sym = this.idents.get(tree);
            }
            Type type = null;
            if (tree instanceof ExpressionTree) {
                type = ((ExpressionTree)tree).symbolType();
            } else if (tree instanceof TypeTree) {
                type = ((TypeTree)tree).symbolType();
            }
            if (type != null) {
                this.sb.append(" ").append(type.fullyQualifiedName());
            }
            if (sym != null && this.semanticModel != null) {
                for (IdentifierTree identifierTree : sym.usages()) {
                    this.idents.put(identifierTree, sym);
                    this.sb.append(" ").append(sym.getName());
                }
                int refLine = ((JavaTree)sym.declaration()).getLine();
                if (refLine != line) {
                    this.sb.append(" ref#").append(refLine);
                }
            }
            this.sb.append("\n");
        }
        ++this.indentLevel;
        super.scan(tree);
        --this.indentLevel;
    }

    public static String printFile(String file, String bytecodePath) {
        ActionParser p = JavaParser.createParser(Charsets.UTF_8);
        CompilationUnitTree cut = (CompilationUnitTree)p.parse(new File(file));
        ArrayList bytecodeFiles = Lists.newArrayList();
        if (!bytecodePath.isEmpty()) {
            bytecodeFiles.add(new File(bytecodePath));
        }
        SemanticModel semanticModel = SemanticModel.createFor(cut, bytecodeFiles);
        return PrinterVisitor.print(cut, semanticModel);
    }
}

