/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import java.util.Deque;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.java.ast.visitors.AccessorsUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.syntaxtoken.FirstSyntaxTokenFinder;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class PublicApiChecker
extends BaseTreeVisitor {
    private static final Tree.Kind[] CLASS_KINDS = new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE};
    private static final Tree.Kind[] METHOD_KINDS = new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR};
    private static final Tree.Kind[] API_KINDS = new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR, Tree.Kind.VARIABLE};
    private final Deque<ClassTree> classTrees = new LinkedList<ClassTree>();
    private final Deque<Tree> currentParents = new LinkedList<Tree>();
    private double publicApi;
    private double documentedPublicApi;
    private final boolean separateAccessorsFromMethods;

    public static PublicApiChecker newInstanceWithAccessorsHandledAsMethods() {
        return new PublicApiChecker(false);
    }

    public static PublicApiChecker newInstanceWithAccessorsSeparatedFromMethods() {
        return new PublicApiChecker(true);
    }

    private PublicApiChecker(boolean separateAccessorsFromMethods) {
        this.separateAccessorsFromMethods = separateAccessorsFromMethods;
    }

    public static Tree.Kind[] classKinds() {
        return (Tree.Kind[])CLASS_KINDS.clone();
    }

    public static Tree.Kind[] methodKinds() {
        return (Tree.Kind[])METHOD_KINDS.clone();
    }

    public static Tree.Kind[] apiKinds() {
        return (Tree.Kind[])API_KINDS.clone();
    }

    public void scan(CompilationUnitTree tree) {
        this.classTrees.clear();
        this.currentParents.clear();
        this.publicApi = 0.0;
        this.documentedPublicApi = 0.0;
        super.scan(tree);
    }

    @Override
    public void visitNewClass(NewClassTree tree) {
    }

    @Override
    public void visitClass(ClassTree tree) {
        this.visitNode(tree);
        super.visitClass(tree);
        this.classTrees.pop();
        this.currentParents.pop();
    }

    @Override
    public void visitVariable(VariableTree tree) {
        this.visitNode(tree);
        super.visitVariable(tree);
    }

    @Override
    public void visitMethod(MethodTree tree) {
        this.visitNode(tree);
        super.visitMethod(tree);
        this.currentParents.pop();
    }

    private void visitNode(Tree tree) {
        Tree currentParent = this.currentParents.peek();
        if (tree.is(CLASS_KINDS)) {
            this.classTrees.push((ClassTree)tree);
            this.currentParents.push(tree);
        } else if (tree.is(METHOD_KINDS)) {
            this.currentParents.push(tree);
        }
        if (this.isPublicApi(currentParent, tree)) {
            this.publicApi += 1.0;
            if (PublicApiChecker.getApiJavadoc(tree) != null) {
                this.documentedPublicApi += 1.0;
            }
        }
    }

    public boolean isPublicApi(Tree currentParent, Tree tree) {
        if (tree.is(CLASS_KINDS) && (currentParent == null || currentParent.is(CLASS_KINDS))) {
            return PublicApiChecker.isPublicApi((ClassTree)currentParent, (ClassTree)tree);
        }
        if (tree.is(METHOD_KINDS)) {
            return this.isPublicApi((ClassTree)currentParent, (MethodTree)tree);
        }
        if (tree.is(Tree.Kind.VARIABLE) && !currentParent.is(METHOD_KINDS)) {
            return PublicApiChecker.isPublicApi((ClassTree)currentParent, (VariableTree)tree);
        }
        return false;
    }

    private static boolean isPublicApi(ClassTree currentClass, ClassTree classTree) {
        return currentClass != null && PublicApiChecker.isPublicInterface(currentClass) || PublicApiChecker.hasPublic(classTree.modifiers());
    }

    private static boolean isPublicInterface(ClassTree currentClass) {
        return currentClass.is(Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE) && !ModifiersUtils.hasModifier(currentClass.modifiers(), Modifier.PRIVATE);
    }

    private static boolean hasPublic(ModifiersTree modifiers) {
        return ModifiersUtils.hasModifier(modifiers, Modifier.PUBLIC);
    }

    private boolean isPublicApi(ClassTree classTree, MethodTree methodTree) {
        Preconditions.checkNotNull((Object)classTree);
        if (this.separateAccessorsFromMethods && AccessorsUtils.isAccessor(classTree, methodTree)) {
            return false;
        }
        if (PublicApiChecker.isPublicInterface(classTree)) {
            return !PublicApiChecker.hasOverrideAnnotation(methodTree);
        }
        if (PublicApiChecker.isEmptyDefaultConstructor(methodTree) || PublicApiChecker.hasOverrideAnnotation(methodTree) || classTree.is(Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE)) {
            return false;
        }
        return PublicApiChecker.hasPublic(methodTree.modifiers());
    }

    private static boolean isEmptyDefaultConstructor(MethodTree constructor) {
        return constructor.is(Tree.Kind.CONSTRUCTOR) && constructor.parameters().isEmpty() && constructor.block().body().isEmpty();
    }

    private static boolean hasOverrideAnnotation(MethodTree method) {
        for (AnnotationTree annotationTree : method.modifiers().annotations()) {
            TypeTree annotationType = annotationTree.annotationType();
            if (!annotationType.is(Tree.Kind.IDENTIFIER) || !"Override".equals(((IdentifierTree)annotationType).name())) continue;
            return true;
        }
        return false;
    }

    private static boolean isPublicApi(ClassTree classTree, VariableTree variableTree) {
        return !PublicApiChecker.isPublicInterface(classTree) && !PublicApiChecker.isStaticFinal(variableTree) && PublicApiChecker.hasPublic(variableTree.modifiers());
    }

    private static boolean isStaticFinal(VariableTree variableTree) {
        ModifiersTree modifiersTree = variableTree.modifiers();
        return ModifiersUtils.hasModifier(modifiersTree, Modifier.STATIC) && ModifiersUtils.hasModifier(modifiersTree, Modifier.FINAL);
    }

    @Nullable
    public static String getApiJavadoc(Tree tree) {
        if (!tree.is(API_KINDS)) {
            return null;
        }
        ModifiersTree modifiersTree = PublicApiChecker.getModifierTrees(tree);
        if (!(modifiersTree == null || modifiersTree.modifiers().isEmpty() && modifiersTree.annotations().isEmpty())) {
            return PublicApiChecker.getCommentFromTree(modifiersTree);
        }
        if (tree.is(Tree.Kind.METHOD)) {
            MethodTree methodTree = (MethodTree)tree;
            return PublicApiChecker.getCommentFromMethod(methodTree);
        }
        return PublicApiChecker.getCommentFromTree(tree);
    }

    private static String getCommentFromMethod(MethodTree methodTree) {
        if (methodTree.typeParameters().isEmpty()) {
            Tree tokenTree = methodTree.returnType();
            while (tokenTree != null && tokenTree.is(Tree.Kind.ARRAY_TYPE, Tree.Kind.PARAMETERIZED_TYPE, Tree.Kind.MEMBER_SELECT)) {
                if (tokenTree.is(Tree.Kind.ARRAY_TYPE)) {
                    tokenTree = ((ArrayTypeTree)tokenTree).type();
                    continue;
                }
                if (tokenTree.is(Tree.Kind.MEMBER_SELECT)) {
                    tokenTree = ((MemberSelectExpressionTree)tokenTree).expression();
                    continue;
                }
                if (!tokenTree.is(Tree.Kind.PARAMETERIZED_TYPE)) continue;
                tokenTree = ((ParameterizedTypeTree)tokenTree).type();
            }
            return PublicApiChecker.getCommentFromTree(tokenTree);
        }
        return PublicApiChecker.getCommentFromSyntaxToken(methodTree.typeParameters().openBracketToken());
    }

    private static String getCommentFromTree(Tree tokenTree) {
        return PublicApiChecker.getCommentFromSyntaxToken(FirstSyntaxTokenFinder.firstSyntaxToken(tokenTree));
    }

    private static ModifiersTree getModifierTrees(Tree tree) {
        ModifiersTree modifiersTree = null;
        if (tree.is(CLASS_KINDS)) {
            modifiersTree = ((ClassTree)tree).modifiers();
        } else if (tree.is(METHOD_KINDS)) {
            modifiersTree = ((MethodTree)tree).modifiers();
        } else if (tree.is(Tree.Kind.VARIABLE)) {
            modifiersTree = ((VariableTree)tree).modifiers();
        }
        return modifiersTree;
    }

    private static String getCommentFromSyntaxToken(SyntaxToken syntaxToken) {
        for (SyntaxTrivia syntaxTrivia : syntaxToken.trivias()) {
            if (!syntaxTrivia.comment().startsWith("/**")) continue;
            return syntaxTrivia.comment();
        }
        return null;
    }

    public double getPublicApi() {
        return this.publicApi;
    }

    public double getUndocumentedPublicApi() {
        return this.publicApi - this.documentedPublicApi;
    }

    public double getDocumentedPublicApiDensity() {
        if (Double.doubleToRawLongBits(this.publicApi) == 0L) {
            return 100.0;
        }
        return ParsingUtils.scaleValue((double)(this.documentedPublicApi / this.publicApi * 100.0), (int)2);
    }
}

