/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import java.io.File;
import java.util.Deque;
import java.util.LinkedList;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourceProject;

public class VisitorContext {
    private final Deque<SourceCode> sourceCodeStack = new LinkedList<SourceCode>();
    private final SourceProject project;
    private File file;

    public VisitorContext(SourceProject project) {
        if (project == null) {
            throw new IllegalArgumentException("project cannot be null.");
        }
        this.project = project;
        this.sourceCodeStack.push((SourceCode)project);
    }

    private void addSourceCode(SourceCode child) {
        this.peekSourceCode().addChild(child);
        this.sourceCodeStack.push(child);
    }

    public SourceCode peekSourceCode() {
        return this.sourceCodeStack.peek();
    }

    public void setFile(File file) {
        this.popTillSourceProject();
        this.addSourceCode((SourceCode)new SourceFile(file.getAbsolutePath(), file.getPath()));
        this.file = file;
    }

    private void popTillSourceProject() {
        while (!this.peekSourceCode().equals((Object)this.project)) {
            this.sourceCodeStack.pop();
        }
    }

    public File getFile() {
        return this.file;
    }
}

