/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ArrayAccessExpressionTreeImpl
extends AbstractTypedTree
implements ArrayAccessExpressionTree {
    private ExpressionTree expression;
    private final ArrayDimensionTree dimension;

    public ArrayAccessExpressionTreeImpl(ArrayDimensionTree dimension) {
        super(Tree.Kind.ARRAY_ACCESS_EXPRESSION);
        this.dimension = dimension;
    }

    public ArrayAccessExpressionTreeImpl complete(ExpressionTree expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ARRAY_ACCESS_EXPRESSION;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitArrayAccessExpression(this);
    }

    @Override
    public ArrayDimensionTree dimension() {
        return this.dimension;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.expression, this.dimension});
    }
}

