/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.resolve.Symbols;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class IdentifierTreeImpl
extends AbstractTypedTree
implements IdentifierTree {
    private final InternalSyntaxToken nameToken;
    private Symbol symbol = Symbols.unknownSymbol;
    private List<AnnotationTree> annotations;

    public IdentifierTreeImpl(InternalSyntaxToken nameToken) {
        super(Tree.Kind.IDENTIFIER);
        this.nameToken = (InternalSyntaxToken)Preconditions.checkNotNull((Object)nameToken);
        this.annotations = ImmutableList.of();
    }

    public IdentifierTreeImpl complete(List<AnnotationTree> annotations) {
        this.annotations = (List)Preconditions.checkNotNull(annotations);
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IDENTIFIER;
    }

    @Override
    public SyntaxToken identifierToken() {
        return this.nameToken;
    }

    @Override
    public String name() {
        return this.identifierToken().text();
    }

    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
    }

    @Override
    public Symbol symbol() {
        return this.symbol;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitIdentifier(this);
    }

    public String toString() {
        return this.name();
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(this.annotations.iterator(), (Iterator)Iterators.singletonIterator((Object)this.nameToken));
    }

    @Override
    public List<AnnotationTree> annotations() {
        return this.annotations;
    }
}

