/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.java.ast.parser.ArgumentListTreeImpl;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Symbols;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeArguments;

public class MethodInvocationTreeImpl
extends AbstractTypedTree
implements MethodInvocationTree {
    private final ExpressionTree methodSelect;
    private final Arguments arguments;
    @Nullable
    private TypeArguments typeArguments;
    private Symbol symbol = Symbols.unknownSymbol;

    public MethodInvocationTreeImpl(ExpressionTree methodSelect, @Nullable TypeArguments typeArguments, ArgumentListTreeImpl arguments) {
        super(Tree.Kind.METHOD_INVOCATION);
        this.methodSelect = (ExpressionTree)Preconditions.checkNotNull((Object)methodSelect);
        this.typeArguments = typeArguments;
        this.arguments = (Arguments)Preconditions.checkNotNull((Object)arguments);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.METHOD_INVOCATION;
    }

    @Override
    @Nullable
    public TypeArguments typeArguments() {
        return this.typeArguments;
    }

    @Override
    public ExpressionTree methodSelect() {
        return this.methodSelect;
    }

    @Override
    public Arguments arguments() {
        return this.arguments;
    }

    @Override
    public Symbol symbol() {
        return this.symbol;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMethodInvocation(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)(this.typeArguments != null ? Iterators.singletonIterator((Object)this.typeArguments) : Iterators.emptyIterator()), (Iterator)Iterators.forArray((Object[])new Tree[]{this.methodSelect, this.arguments}));
    }

    public void setSymbol(Symbol symbol) {
        Preconditions.checkState((boolean)this.symbol.equals(Symbols.unknownSymbol));
        this.symbol = symbol;
    }
}

