/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.model.expression.TypeArgumentListTreeImpl;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeArguments;
import org.sonar.plugins.java.api.tree.TypeTree;

public class NewClassTreeImpl
extends AbstractTypedTree
implements NewClassTree {
    @Nullable
    private ExpressionTree enclosingExpression = null;
    @Nullable
    private SyntaxToken dotToken;
    @Nullable
    private SyntaxToken newKeyword;
    @Nullable
    private TypeArguments typeArguments;
    private TypeTree identifier;
    private final Arguments arguments;
    @Nullable
    private final ClassTree classBody;

    public NewClassTreeImpl(Arguments arguments, @Nullable ClassTreeImpl classBody) {
        super(Tree.Kind.NEW_CLASS);
        this.arguments = arguments;
        this.classBody = classBody;
    }

    public NewClassTreeImpl completeWithIdentifier(TypeTree identifier) {
        this.identifier = identifier;
        return this;
    }

    public NewClassTreeImpl completeWithEnclosingExpression(ExpressionTree enclosingExpression) {
        this.enclosingExpression = enclosingExpression;
        return this;
    }

    public NewClassTreeImpl completeWithNewKeyword(SyntaxToken newKeyword) {
        this.newKeyword = newKeyword;
        return this;
    }

    public NewClassTreeImpl completeWithTypeArguments(TypeArgumentListTreeImpl typeArguments) {
        this.typeArguments = typeArguments;
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.NEW_CLASS;
    }

    @Override
    @Nullable
    public ExpressionTree enclosingExpression() {
        return this.enclosingExpression;
    }

    @Override
    @Nullable
    public TypeArguments typeArguments() {
        return this.typeArguments;
    }

    @Override
    public TypeTree identifier() {
        return this.identifier;
    }

    @Override
    public Arguments arguments() {
        return this.arguments;
    }

    @Override
    @Nullable
    public ClassTree classBody() {
        return this.classBody;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitNewClass(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        Object result = Iterators.emptyIterator();
        result = NewClassTreeImpl.addIfNotNull((Iterator<Tree>)result, this.enclosingExpression, this.dotToken, this.newKeyword, this.typeArguments);
        result = NewClassTreeImpl.add((Iterator<Tree>)result, this.identifier, this.arguments);
        result = NewClassTreeImpl.addIfNotNull((Iterator<Tree>)result, this.classBody);
        return result;
    }

    private static Iterator<Tree> add(Iterator<Tree> iterator, Tree ... trees) {
        return Iterators.concat(iterator, (Iterator)Iterators.forArray((Object[])trees));
    }

    public IdentifierTree getConstructorIdentifier() {
        return this.getConstructorIdentifier(this.identifier());
    }

    private IdentifierTree getConstructorIdentifier(Tree constructorSelect) {
        IdentifierTree constructorIdentifier;
        if (constructorSelect.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree mset = (MemberSelectExpressionTree)constructorSelect;
            constructorIdentifier = mset.identifier();
        } else if (constructorSelect.is(Tree.Kind.IDENTIFIER)) {
            constructorIdentifier = (IdentifierTree)constructorSelect;
        } else if (constructorSelect.is(Tree.Kind.PARAMETERIZED_TYPE)) {
            constructorIdentifier = this.getConstructorIdentifier(((ParameterizedTypeTree)constructorSelect).type());
        } else {
            throw new IllegalStateException("Constructor select is not of the expected type " + constructorSelect);
        }
        return constructorIdentifier;
    }

    @Override
    @Nullable
    public SyntaxToken newKeyword() {
        return this.newKeyword;
    }

    public void completeWithDotToken(InternalSyntaxToken dotToken) {
        this.dotToken = dotToken;
    }

    @Override
    @Nullable
    public SyntaxToken dotToken() {
        return this.dotToken;
    }

    @Override
    public Symbol constructorSymbol() {
        return this.getConstructorIdentifier().symbol();
    }

    private static Iterator<Tree> addIfNotNull(Iterator<Tree> iterator, Tree ... trees) {
        Iterator result = iterator;
        for (Tree tree : trees) {
            if (tree == null) continue;
            result = Iterators.concat(result, (Iterator)Iterators.singletonIterator((Object)tree));
        }
        return result;
    }
}

