/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ParenthesizedTreeImpl
extends AbstractTypedTree
implements ParenthesizedTree {
    private final InternalSyntaxToken openParenToken;
    private final ExpressionTree expression;
    private final InternalSyntaxToken closeParenToken;

    public ParenthesizedTreeImpl(InternalSyntaxToken openParenToken, ExpressionTree expression, InternalSyntaxToken closeParenToken) {
        super(Tree.Kind.PARENTHESIZED_EXPRESSION);
        this.openParenToken = openParenToken;
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        this.closeParenToken = closeParenToken;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.PARENTHESIZED_EXPRESSION;
    }

    @Override
    public SyntaxToken openParenToken() {
        return this.openParenToken;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return this.closeParenToken;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitParenthesized(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.openParenToken, this.expression, this.closeParenToken});
    }
}

