/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.java.ast.parser.BoundListTreeImpl;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeTree;

public class TypeCastExpressionTreeImpl
extends AbstractTypedTree
implements TypeCastTree {
    private InternalSyntaxToken openParenToken;
    private final TypeTree type;
    @Nullable
    private final InternalSyntaxToken andToken;
    private final ListTree<Tree> bounds;
    private final InternalSyntaxToken closeParenToken;
    private final ExpressionTree expression;

    public TypeCastExpressionTreeImpl(TypeTree type, InternalSyntaxToken closeParenToken, ExpressionTree expression) {
        super(Tree.Kind.TYPE_CAST);
        this.type = (TypeTree)Preconditions.checkNotNull((Object)type);
        this.bounds = BoundListTreeImpl.emptyList();
        this.closeParenToken = closeParenToken;
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        this.andToken = null;
    }

    public TypeCastExpressionTreeImpl(TypeTree type, InternalSyntaxToken andToken, ListTree<Tree> bounds, InternalSyntaxToken closeParenToken, ExpressionTree expression) {
        super(Tree.Kind.TYPE_CAST);
        this.type = (TypeTree)Preconditions.checkNotNull((Object)type);
        this.bounds = bounds;
        this.closeParenToken = closeParenToken;
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        this.andToken = andToken;
    }

    public TypeCastExpressionTreeImpl complete(InternalSyntaxToken openParenToken) {
        Preconditions.checkState((this.openParenToken == null && this.closeParenToken != null ? 1 : 0) != 0);
        this.openParenToken = openParenToken;
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TYPE_CAST;
    }

    @Override
    public SyntaxToken openParenToken() {
        return this.openParenToken;
    }

    @Override
    public TypeTree type() {
        return this.type;
    }

    @Override
    @Nullable
    public SyntaxToken andToken() {
        return this.andToken;
    }

    @Override
    public ListTree<Tree> bounds() {
        return this.bounds;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return this.closeParenToken;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTypeCast(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        UnmodifiableIterator andTokenIterator = this.andToken == null ? Iterators.emptyIterator() : Iterators.singletonIterator((Object)this.andToken());
        return Iterators.concat((Iterator)Iterators.forArray((Object[])new Tree[]{this.openParenToken, this.type}), (Iterator)andTokenIterator, (Iterator)Iterators.singletonIterator(this.bounds), (Iterator)Iterators.forArray((Object[])new Tree[]{this.closeParenToken, this.expression}));
    }
}

