/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.statement.BlockTreeImpl;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class SynchronizedStatementTreeImpl
extends JavaTree
implements SynchronizedStatementTree {
    private final ExpressionTree expression;
    private final BlockTree block;
    private final InternalSyntaxToken synchronizedKeyword;
    private final InternalSyntaxToken openParenToken;
    private final InternalSyntaxToken closeParenToken;

    public SynchronizedStatementTreeImpl(InternalSyntaxToken synchronizedKeyword, InternalSyntaxToken openParenToken, ExpressionTree expression, InternalSyntaxToken closeParenToken, BlockTreeImpl block) {
        super(Tree.Kind.SYNCHRONIZED_STATEMENT);
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        this.block = (BlockTree)Preconditions.checkNotNull((Object)block);
        this.synchronizedKeyword = synchronizedKeyword;
        this.openParenToken = openParenToken;
        this.closeParenToken = closeParenToken;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.SYNCHRONIZED_STATEMENT;
    }

    @Override
    public SyntaxToken synchronizedKeyword() {
        return this.synchronizedKeyword;
    }

    @Override
    public SyntaxToken openParenToken() {
        return this.openParenToken;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return this.closeParenToken;
    }

    @Override
    public BlockTree block() {
        return this.block;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitSynchronizedStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.synchronizedKeyword, this.openParenToken, this.expression, this.closeParenToken, this.block});
    }
}

