/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.parser.sslr;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.parser.sslr.DelayedRuleInvocationExpression;
import org.sonar.java.parser.sslr.GrammarBuilder;
import org.sonar.java.parser.sslr.Input;
import org.sonar.java.parser.sslr.NonterminalBuilder;
import org.sonar.java.parser.sslr.Optional;
import org.sonar.java.parser.sslr.SyntaxTreeCreator;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;
import org.sonar.sslr.internal.matchers.InputBuffer;
import org.sonar.sslr.internal.vm.FirstOfExpression;
import org.sonar.sslr.internal.vm.ParsingExpression;
import org.sonar.sslr.internal.vm.SequenceExpression;
import org.sonar.sslr.parser.ParseError;
import org.sonar.sslr.parser.ParseErrorFormatter;
import org.sonar.sslr.parser.ParseRunner;
import org.sonar.sslr.parser.ParsingResult;

public class ActionParser {
    private final Charset charset;
    private final SyntaxTreeCreator<Tree> syntaxTreeCreator;
    private final GrammarRuleKey rootRule;
    private final ParseRunner parseRunner;

    public ActionParser(Charset charset, LexerlessGrammarBuilder b, Class grammarClass, Object treeFactory, GrammarRuleKey rootRule) {
        this.charset = charset;
        GrammarBuilderInterceptor grammarBuilderInterceptor = new GrammarBuilderInterceptor(b);
        Enhancer grammarEnhancer = new Enhancer();
        grammarEnhancer.setSuperclass(grammarClass);
        grammarEnhancer.setCallback((Callback)grammarBuilderInterceptor);
        ActionMethodInterceptor actionMethodInterceptor = new ActionMethodInterceptor(grammarBuilderInterceptor);
        Enhancer actionEnhancer = new Enhancer();
        actionEnhancer.setSuperclass(treeFactory.getClass());
        actionEnhancer.setCallback((Callback)actionMethodInterceptor);
        Object grammar = grammarEnhancer.create(new Class[]{GrammarBuilder.class, treeFactory.getClass()}, new Object[]{grammarBuilderInterceptor, actionEnhancer.create()});
        for (Method method : grammarClass.getMethods()) {
            if (method.getDeclaringClass().equals(Object.class)) continue;
            try {
                method.invoke(grammar, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        this.syntaxTreeCreator = new SyntaxTreeCreator(treeFactory, grammarBuilderInterceptor);
        b.setRootRule(rootRule);
        this.rootRule = rootRule;
        this.parseRunner = new ParseRunner(b.build().getRootRule());
    }

    public Tree parse(File file) {
        try {
            return this.parse(new Input(Files.toString((File)file, (Charset)this.charset).toCharArray(), file.toURI()));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Tree parse(String source) {
        return this.parse(new Input(source.toCharArray()));
    }

    private Tree parse(Input input) {
        ParsingResult result = this.parseRunner.parse(input.input());
        if (!result.isMatched()) {
            ParseError parseError = result.getParseError();
            InputBuffer inputBuffer = parseError.getInputBuffer();
            int line = inputBuffer.getPosition(parseError.getErrorIndex()).getLine();
            String message = new ParseErrorFormatter().format(parseError);
            throw new RecognitionException(line, message);
        }
        return this.syntaxTreeCreator.create(result.getParseTreeRoot(), input);
    }

    public GrammarRuleKey rootRule() {
        return this.rootRule;
    }

    private static class DummyGrammarRuleKey
    implements GrammarRuleKey {
        private final Method method;
        private final String operator;
        private final ParsingExpression expression;

        public DummyGrammarRuleKey(Method method) {
            this.method = method;
            this.operator = null;
            this.expression = null;
        }

        public DummyGrammarRuleKey(String operator, ParsingExpression expression) {
            this.method = null;
            this.operator = operator;
            this.expression = expression;
        }

        public String toString() {
            if (this.operator != null) {
                return this.operator + "(" + this.expression + ")";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("f.");
            sb.append(this.method.getName());
            sb.append('(');
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length - 1; ++i) {
                sb.append(parameterTypes[i].getSimpleName());
                sb.append(", ");
            }
            if (parameterTypes.length > 0) {
                sb.append(parameterTypes[parameterTypes.length - 1].getSimpleName());
            }
            sb.append(')');
            return sb.toString();
        }
    }

    public static class ActionMethodInterceptor
    implements MethodInterceptor {
        private final GrammarBuilderInterceptor grammarBuilderInterceptor;

        public ActionMethodInterceptor(GrammarBuilderInterceptor grammarBuilderInterceptor) {
            this.grammarBuilderInterceptor = grammarBuilderInterceptor;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (method.getDeclaringClass().equals(Object.class)) {
                return proxy.invokeSuper(obj, args);
            }
            GrammarRuleKey ruleKey = this.grammarBuilderInterceptor.ruleKeyForAction(method);
            this.grammarBuilderInterceptor.replaceByRule(ruleKey, args.length);
            return null;
        }
    }

    public static class GrammarBuilderInterceptor
    implements MethodInterceptor,
    GrammarBuilder,
    NonterminalBuilder {
        private final LexerlessGrammarBuilder b;
        private final BiMap<Method, GrammarRuleKey> mapping = HashBiMap.create();
        private final BiMap<Method, GrammarRuleKey> actions = HashBiMap.create();
        private final Set<GrammarRuleKey> optionals = Sets.newHashSet();
        private final Set<GrammarRuleKey> oneOrMores = Sets.newHashSet();
        private final Set<GrammarRuleKey> zeroOrMores = Sets.newHashSet();
        private Method buildingMethod = null;
        private GrammarRuleKey ruleKey = null;
        private final Deque<ParsingExpression> expressionStack = new ArrayDeque<ParsingExpression>();

        public GrammarBuilderInterceptor(LexerlessGrammarBuilder b) {
            this.b = b;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (method.getDeclaringClass().equals(Object.class)) {
                return proxy.invokeSuper(obj, args);
            }
            if (this.buildingMethod != null) {
                this.push(new DelayedRuleInvocationExpression(this.b, this, method));
                return null;
            }
            this.buildingMethod = method;
            return proxy.invokeSuper(obj, args);
        }

        @Override
        public <T> NonterminalBuilder<T> nonterminal() {
            return this.nonterminal(new DummyGrammarRuleKey(this.buildingMethod));
        }

        @Override
        public <T> NonterminalBuilder<T> nonterminal(GrammarRuleKey ruleKey) {
            this.ruleKey = ruleKey;
            this.mapping.put((Object)this.buildingMethod, (Object)this.ruleKey);
            return this;
        }

        public Object is(Object method) {
            Preconditions.checkState((this.expressionStack.size() == 1 ? 1 : 0) != 0, (Object)("Unexpected stack size: " + this.expressionStack.size()));
            ParsingExpression expression = this.pop();
            this.b.rule(this.ruleKey).is((Object)expression);
            this.buildingMethod = null;
            this.ruleKey = null;
            return null;
        }

        @Override
        public <T> T firstOf(T ... methods) {
            FirstOfExpression expression = new FirstOfExpression(this.pop(methods.length));
            this.expressionStack.push((ParsingExpression)expression);
            return null;
        }

        @Override
        public <T> Optional<T> optional(T method) {
            ParsingExpression expression = this.pop();
            DummyGrammarRuleKey grammarRuleKey = new DummyGrammarRuleKey("optional", expression);
            this.optionals.add(grammarRuleKey);
            this.b.rule((GrammarRuleKey)grammarRuleKey).is(this.b.optional((Object)expression));
            this.token(grammarRuleKey);
            return null;
        }

        @Override
        public <T> List<T> oneOrMore(T method) {
            ParsingExpression expression = this.pop();
            DummyGrammarRuleKey grammarRuleKey = new DummyGrammarRuleKey("oneOrMore", expression);
            this.oneOrMores.add(grammarRuleKey);
            this.b.rule((GrammarRuleKey)grammarRuleKey).is(this.b.oneOrMore((Object)expression));
            this.token(grammarRuleKey);
            return null;
        }

        @Override
        public <T> Optional<List<T>> zeroOrMore(T method) {
            ParsingExpression expression = this.pop();
            DummyGrammarRuleKey grammarRuleKey = new DummyGrammarRuleKey("zeroOrMore", expression);
            this.zeroOrMores.add(grammarRuleKey);
            this.b.rule((GrammarRuleKey)grammarRuleKey).is(this.b.zeroOrMore((Object)expression));
            this.token(grammarRuleKey);
            return null;
        }

        @Override
        public InternalSyntaxToken token(GrammarRuleKey grammarRuleKey) {
            this.push(new DelayedRuleInvocationExpression(this.b, grammarRuleKey));
            return null;
        }

        public void replaceByRule(GrammarRuleKey grammarRuleKey, int stackElements) {
            ParsingExpression expression = stackElements == 1 ? this.pop() : new SequenceExpression(this.pop(stackElements));
            this.b.rule(grammarRuleKey).is((Object)expression);
            this.token(grammarRuleKey);
        }

        private ParsingExpression[] pop(int n) {
            ParsingExpression[] result = new ParsingExpression[n];
            for (int i = n - 1; i >= 0; --i) {
                result[i] = this.pop();
            }
            return result;
        }

        private ParsingExpression pop() {
            return this.expressionStack.pop();
        }

        private void push(ParsingExpression expression) {
            this.expressionStack.push(expression);
        }

        public GrammarRuleKey ruleKeyForAction(Method method) {
            GrammarRuleKey grammarRuleKey = (GrammarRuleKey)this.actions.get((Object)method);
            if (grammarRuleKey == null) {
                method.setAccessible(true);
                grammarRuleKey = new DummyGrammarRuleKey(method);
                this.actions.put((Object)method, (Object)grammarRuleKey);
            }
            return grammarRuleKey;
        }

        @Nullable
        public Method actionForRuleKey(Object ruleKey) {
            return (Method)this.actions.inverse().get(ruleKey);
        }

        @Nullable
        public GrammarRuleKey ruleKeyForMethod(Method method) {
            return (GrammarRuleKey)this.mapping.get((Object)method);
        }

        public boolean hasMethodForRuleKey(Object ruleKey) {
            return this.mapping.containsValue(ruleKey);
        }

        public boolean isOptionalRule(Object ruleKey) {
            return this.optionals.contains(ruleKey);
        }

        public boolean isOneOrMoreRule(Object ruleKey) {
            return this.oneOrMores.contains(ruleKey);
        }

        public boolean isZeroOrMoreRule(Object ruleKey) {
            return this.zeroOrMores.contains(ruleKey);
        }
    }
}

