/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.parser.sslr;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.java.model.InternalSyntaxSpacing;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.InternalSyntaxTrivia;
import org.sonar.java.parser.sslr.ActionParser;
import org.sonar.java.parser.sslr.Input;
import org.sonar.java.parser.sslr.Optional;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.grammar.MutableParsingRule;
import org.sonar.sslr.internal.matchers.ParseNode;
import org.sonar.sslr.internal.vm.TokenExpression;
import org.sonar.sslr.internal.vm.TriviaExpression;

public class SyntaxTreeCreator<T> {
    private final Object treeFactory;
    private final ActionParser.GrammarBuilderInterceptor mapping;
    private final Token.Builder tokenBuilder = Token.builder();
    private final List<Trivia> trivias = Lists.newArrayList();
    private Input input;

    public SyntaxTreeCreator(Object treeFactory, ActionParser.GrammarBuilderInterceptor mapping) {
        this.treeFactory = treeFactory;
        this.mapping = mapping;
    }

    public T create(ParseNode node, Input input) {
        this.input = input;
        this.trivias.clear();
        return (T)this.visit(node);
    }

    private Object visit(ParseNode node) {
        if (node.getMatcher() instanceof MutableParsingRule) {
            return this.visitNonTerminal(node);
        }
        return this.visitTerminal(node);
    }

    private Object visitNonTerminal(ParseNode node) {
        MutableParsingRule rule = (MutableParsingRule)node.getMatcher();
        GrammarRuleKey ruleKey = rule.getRuleKey();
        if (this.mapping.hasMethodForRuleKey(ruleKey)) {
            Preconditions.checkState((node.getChildren().size() == 1 ? 1 : 0) != 0);
            return this.visit((ParseNode)node.getChildren().get(0));
        }
        if (this.mapping.isOptionalRule(ruleKey)) {
            Preconditions.checkState((node.getChildren().size() <= 1 ? 1 : 0) != 0);
            if (node.getChildren().isEmpty()) {
                return Optional.absent();
            }
            return Optional.of(this.visit((ParseNode)node.getChildren().get(0)));
        }
        List children = node.getChildren();
        ArrayList convertedChildren = Lists.newArrayList();
        for (ParseNode child : children) {
            Object result = this.visit(child);
            if (result == null) continue;
            convertedChildren.add(result);
        }
        if (this.mapping.isOneOrMoreRule(ruleKey)) {
            return Lists.newArrayList((Iterable)convertedChildren);
        }
        if (this.mapping.isZeroOrMoreRule(ruleKey)) {
            return convertedChildren.isEmpty() ? Optional.absent() : Optional.of(Lists.newArrayList((Iterable)convertedChildren));
        }
        Method method = this.mapping.actionForRuleKey(ruleKey);
        if (method == null) {
            for (Object child : convertedChildren) {
                if (!(child instanceof InternalSyntaxToken)) continue;
                InternalSyntaxToken syntaxToken = (InternalSyntaxToken)child;
                syntaxToken.setGrammarRuleKey(rule.getRuleKey());
                return child;
            }
            return new InternalSyntaxSpacing(node.getStartIndex(), node.getEndIndex());
        }
        try {
            return method.invoke(this.treeFactory, convertedChildren.toArray(new Object[convertedChildren.size()]));
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private InternalSyntaxToken visitTerminal(ParseNode node) {
        boolean isEof = false;
        if (node.getMatcher() instanceof TriviaExpression) {
            TriviaExpression ruleMatcher = (TriviaExpression)node.getMatcher();
            if (ruleMatcher.getTriviaKind() == Trivia.TriviaKind.SKIPPED_TEXT) {
                return null;
            }
            if (ruleMatcher.getTriviaKind() == Trivia.TriviaKind.COMMENT) {
                this.updateTokenPositionAndValue(node);
                this.tokenBuilder.setTrivia(Collections.emptyList());
                this.tokenBuilder.setType((TokenType)GenericTokenType.COMMENT);
                this.trivias.add(Trivia.createComment((Token)this.tokenBuilder.build()));
                return null;
            }
            throw new IllegalStateException("Unexpected trivia kind: " + ruleMatcher.getTriviaKind());
        }
        if (node.getMatcher() instanceof TokenExpression) {
            this.updateTokenPositionAndValue(node);
            TokenExpression ruleMatcher = (TokenExpression)node.getMatcher();
            this.tokenBuilder.setType(ruleMatcher.getTokenType());
            boolean bl = isEof = GenericTokenType.EOF == ruleMatcher.getTokenType();
            if (GenericTokenType.COMMENT == ruleMatcher.getTokenType()) {
                this.tokenBuilder.setTrivia(Collections.emptyList());
                this.trivias.add(Trivia.createComment((Token)this.tokenBuilder.build()));
                return null;
            }
        }
        LineColumnValue lineColumnValue = this.tokenPosition(node);
        InternalSyntaxToken internalSyntaxToken = new InternalSyntaxToken(lineColumnValue.line, lineColumnValue.column, lineColumnValue.value, SyntaxTreeCreator.createTrivias(this.trivias), node.getStartIndex(), node.getEndIndex(), isEof);
        this.trivias.clear();
        return internalSyntaxToken;
    }

    private static List<SyntaxTrivia> createTrivias(List<Trivia> trivias) {
        ArrayList result = Lists.newArrayList();
        for (Trivia trivia : trivias) {
            Token trivialToken = trivia.getToken();
            result.add(InternalSyntaxTrivia.create(trivialToken.getValue(), trivialToken.getLine(), trivialToken.getColumn()));
        }
        return result;
    }

    private void updateTokenPositionAndValue(ParseNode node) {
        this.tokenBuilder.setGeneratedCode(false);
        int[] lineAndColumn = this.input.lineAndColumnAt(node.getStartIndex());
        this.tokenBuilder.setLine(lineAndColumn[0]);
        this.tokenBuilder.setColumn(lineAndColumn[1] - 1);
        this.tokenBuilder.setURI(this.input.uri());
        String value = this.input.substring(node.getStartIndex(), node.getEndIndex());
        this.tokenBuilder.setValueAndOriginalValue(value);
    }

    private LineColumnValue tokenPosition(ParseNode node) {
        int[] lineAndColumn = this.input.lineAndColumnAt(node.getStartIndex());
        String value = this.input.substring(node.getStartIndex(), node.getEndIndex());
        return new LineColumnValue(lineAndColumn[0], lineAndColumn[1] - 1, value);
    }

    private static class LineColumnValue {
        final int line;
        final int column;
        final String value;

        private LineColumnValue(int line, int column, String value) {
            this.line = line;
            this.column = column;
            this.value = value;
        }
    }
}

