/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.syntaxtoken;

import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.expression.TypeArgumentListTreeImpl;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.AssertStatementTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.EmptyStatementTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifierTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeParameters;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

public class LastSyntaxTokenFinder
extends BaseTreeVisitor {
    private SyntaxToken lastSyntaxToken;

    private LastSyntaxTokenFinder() {
    }

    @Nullable
    public static SyntaxToken lastSyntaxToken(Tree tree) {
        if (tree.is(Tree.Kind.TOKEN)) {
            return (SyntaxToken)tree;
        }
        LastSyntaxTokenFinder visitor = new LastSyntaxTokenFinder();
        tree.accept(visitor);
        return visitor.lastSyntaxToken;
    }

    @Override
    public void visitBlock(BlockTree tree) {
        this.lastSyntaxToken = tree.closeBraceToken();
    }

    @Override
    public void visitEmptyStatement(EmptyStatementTree tree) {
        this.lastSyntaxToken = tree.semicolonToken();
    }

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        this.lastSyntaxToken = tree.semicolonToken();
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        StatementTree elseStatement = tree.elseStatement();
        if (elseStatement != null) {
            this.scan(elseStatement);
        } else {
            this.scan(tree.thenStatement());
        }
    }

    @Override
    public void visitAssertStatement(AssertStatementTree tree) {
        this.lastSyntaxToken = tree.semicolonToken();
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.lastSyntaxToken = tree.closeBraceToken();
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.scan(tree.statement());
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.lastSyntaxToken = tree.semicolonToken();
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.scan(tree.statement());
    }

    @Override
    public void visitForEachStatement(ForEachStatement tree) {
        this.scan(tree.statement());
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
        this.lastSyntaxToken = tree.semicolonToken();
    }

    @Override
    public void visitContinueStatement(ContinueStatementTree tree) {
        this.lastSyntaxToken = tree.semicolonToken();
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        this.lastSyntaxToken = tree.semicolonToken();
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        this.lastSyntaxToken = tree.semicolonToken();
    }

    @Override
    public void visitSynchronizedStatement(SynchronizedStatementTree tree) {
        this.scan(tree.block());
    }

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        BlockTree finallyBlock = tree.finallyBlock();
        if (finallyBlock != null) {
            this.scan(finallyBlock);
        } else {
            List<CatchTree> catches = tree.catches();
            if (catches.isEmpty()) {
                this.scan(tree.block());
            } else {
                this.scan(catches.get(catches.size() - 1));
            }
        }
    }

    @Override
    public void visitCatch(CatchTree tree) {
        this.scan(tree.block());
    }

    @Override
    public void visitMethod(MethodTree tree) {
        SyntaxToken semicolonToken = tree.semicolonToken();
        if (semicolonToken != null) {
            this.lastSyntaxToken = semicolonToken;
        } else {
            this.scan(tree.block());
        }
    }

    @Override
    public void visitClass(ClassTree tree) {
        this.lastSyntaxToken = tree.closeBraceToken();
    }

    @Override
    public void visitVariable(VariableTree tree) {
        SyntaxToken endToken = tree.endToken();
        if (endToken == null) {
            ExpressionTree initializer = tree.initializer();
            if (initializer == null) {
                this.scan(tree.simpleName());
            } else {
                this.scan(initializer);
            }
        } else {
            this.lastSyntaxToken = endToken;
        }
    }

    @Override
    public void visitEnumConstant(EnumConstantTree tree) {
        if (tree.separatorToken() != null) {
            this.lastSyntaxToken = tree.separatorToken();
        } else {
            this.scan(tree.initializer());
        }
    }

    @Override
    public void visitCaseLabel(CaseLabelTree tree) {
        this.lastSyntaxToken = tree.colonToken();
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        this.scan(tree.rightOperand());
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        this.lastSyntaxToken = tree.token();
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        this.lastSyntaxToken = tree.identifierToken();
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.lastSyntaxToken = tree.eofToken();
    }

    @Override
    public void visitImport(ImportTree tree) {
        this.lastSyntaxToken = tree.semicolonToken();
    }

    @Override
    public void visitLabeledStatement(LabeledStatementTree tree) {
        this.scan(tree.statement());
    }

    @Override
    public void visitCaseGroup(CaseGroupTree tree) {
        if (!tree.body().isEmpty()) {
            this.scan((Tree)Iterables.getLast(tree.body()));
        } else {
            this.scan((Tree)Iterables.getLast(tree.labels()));
        }
    }

    @Override
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (tree.is(Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT)) {
            this.lastSyntaxToken = tree.operatorToken();
        } else {
            this.scan(tree.expression());
        }
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.scan(tree.falseExpression());
    }

    @Override
    public void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
        this.scan(tree.dimension());
    }

    @Override
    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        this.scan(tree.identifier());
    }

    @Override
    public void visitNewClass(NewClassTree tree) {
        if (tree.classBody() != null) {
            this.scan(tree.classBody());
        } else if (tree.arguments().closeParenToken() != null) {
            this.lastSyntaxToken = tree.arguments().closeParenToken();
        } else {
            this.scan(tree.identifier());
        }
    }

    @Override
    public void visitNewArray(NewArrayTree tree) {
        SyntaxToken closeBraceToken = tree.closeBraceToken();
        if (closeBraceToken != null) {
            this.lastSyntaxToken = closeBraceToken;
        } else {
            this.scan((Tree)Iterables.getLast(tree.dimensions()));
        }
    }

    @Override
    public void visitMethodInvocation(MethodInvocationTree tree) {
        this.lastSyntaxToken = tree.arguments().closeParenToken();
    }

    @Override
    public void visitTypeCast(TypeCastTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitInstanceOf(InstanceOfTree tree) {
        this.scan(tree.type());
    }

    @Override
    public void visitParenthesized(ParenthesizedTree tree) {
        this.lastSyntaxToken = tree.closeParenToken();
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitPrimitiveType(PrimitiveTypeTree tree) {
        this.lastSyntaxToken = tree.keyword();
    }

    @Override
    public void visitArrayType(ArrayTypeTree tree) {
        this.lastSyntaxToken = tree.ellipsisToken() != null ? tree.ellipsisToken() : tree.closeBracketToken();
    }

    @Override
    public void visitParameterizedType(ParameterizedTypeTree tree) {
        this.lastSyntaxToken = tree.typeArguments().closeBracketToken();
    }

    @Override
    public void visitWildcard(WildcardTree tree) {
        if (tree.bound() != null) {
            this.scan(tree.bound());
        } else {
            this.lastSyntaxToken = tree.queryToken();
        }
    }

    @Override
    public void visitUnionType(UnionTypeTree tree) {
        this.scan((Tree)Iterables.getLast(tree.typeAlternatives()));
    }

    @Override
    public void visitModifier(ModifiersTree modifiersTree) {
        if (!modifiersTree.isEmpty()) {
            ModifierTree lastModifier = (ModifierTree)Iterables.getLast((Iterable)modifiersTree);
            if (lastModifier.is(Tree.Kind.ANNOTATION)) {
                this.scan(lastModifier);
            } else {
                this.lastSyntaxToken = ((ModifierKeywordTree)lastModifier).keyword();
            }
        }
    }

    @Override
    public void visitAnnotation(AnnotationTree annotationTree) {
        if (annotationTree.arguments().closeParenToken() != null) {
            this.lastSyntaxToken = annotationTree.arguments().closeParenToken();
        } else {
            this.scan(annotationTree.annotationType());
        }
    }

    @Override
    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        this.scan(lambdaExpressionTree.body());
    }

    @Override
    public void visitTypeParameter(TypeParameterTree typeParameter) {
        if (!typeParameter.bounds().isEmpty()) {
            this.scan((Tree)Iterables.getLast(typeParameter.bounds()));
        } else {
            this.scan(typeParameter.identifier());
        }
    }

    @Override
    public void visitTypeArguments(TypeArgumentListTreeImpl trees) {
        this.lastSyntaxToken = trees.closeBracketToken();
    }

    @Override
    public void visitTypeParameters(TypeParameters trees) {
        this.lastSyntaxToken = trees.closeBracketToken();
    }

    @Override
    public void visitMethodReference(MethodReferenceTree methodReferenceTree) {
        this.scan(methodReferenceTree.method());
    }

    @Override
    public void visitOther(Tree tree) {
    }

    @Override
    public void visitPackage(PackageDeclarationTree tree) {
        this.lastSyntaxToken = tree.semicolonToken();
    }

    @Override
    public void visitArrayDimension(ArrayDimensionTree tree) {
        this.lastSyntaxToken = tree.closeBracketToken();
    }
}

