/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.java.api.JavaCheck;

public class AnalyzerMessage {
    private final JavaCheck check;
    private final File file;
    private final String message;
    private final int cost;
    @Nullable
    private TextSpan textSpan;
    public final List<AnalyzerMessage> secondaryLocations = new ArrayList<AnalyzerMessage>();

    public AnalyzerMessage(JavaCheck check, File file, int line, String message, int cost) {
        this(check, file, line > 0 ? new TextSpan(line, -1, line, -1) : null, message, cost);
    }

    public AnalyzerMessage(JavaCheck check, File file, @Nullable TextSpan textSpan, String message, int cost) {
        this.check = check;
        this.file = file;
        this.message = message;
        this.cost = cost;
        this.textSpan = textSpan;
    }

    public JavaCheck getCheck() {
        return this.check;
    }

    public File getFile() {
        return this.file;
    }

    @Nullable
    public TextSpan primaryLocation() {
        return this.textSpan;
    }

    @Nullable
    public Integer getLine() {
        return this.textSpan == null ? null : Integer.valueOf(this.textSpan.startLine);
    }

    public String getMessage() {
        return this.message;
    }

    @Nullable
    public Double getCost() {
        return this.cost > 0 ? Double.valueOf(this.cost) : null;
    }

    public static final class TextSpan {
        public final int startLine;
        public final int startCharacter;
        public final int endLine;
        public final int endCharacter;

        public TextSpan(int startLine, int startCharacter, int endLine, int endCharacter) {
            this.startLine = startLine;
            this.startCharacter = startCharacter;
            this.endLine = endLine;
            this.endCharacter = endCharacter;
        }

        public String toString() {
            return "(" + this.startLine + ":" + this.startCharacter + ")-(" + this.endLine + ":" + this.endCharacter + ")";
        }
    }
}

