/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.CharsetAwareVisitor;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.SonarSymbolTableVisitor;
import org.sonar.java.ast.visitors.VisitorContext;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.PackageUtils;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.AstScannerExceptionHandler;
import org.sonar.squidbridge.api.SourceFile;

public class InternalVisitorsBridge {
    private static final Logger LOG = LoggerFactory.getLogger(InternalVisitorsBridge.class);
    private final List<JavaFileScanner> scanners;
    private final SonarComponents sonarComponents;
    private SemanticModel semanticModel;
    private List<File> projectClasspath;
    private boolean analyseAccessors;
    private VisitorContext context;
    @Nullable
    private Integer javaVersion;

    public InternalVisitorsBridge(Iterable visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents) {
        ImmutableList.Builder scannersBuilder = ImmutableList.builder();
        for (Object visitor : visitors) {
            if (!(visitor instanceof JavaFileScanner)) continue;
            scannersBuilder.add((Object)((JavaFileScanner)visitor));
        }
        this.scanners = scannersBuilder.build();
        this.sonarComponents = sonarComponents;
        this.projectClasspath = projectClasspath;
    }

    public void setAnalyseAccessors(boolean analyseAccessors) {
        this.analyseAccessors = analyseAccessors;
    }

    public void setCharset(Charset charset) {
        for (JavaFileScanner scanner : this.scanners) {
            if (!(scanner instanceof CharsetAwareVisitor)) continue;
            ((CharsetAwareVisitor)((Object)scanner)).setCharset(charset);
        }
    }

    public void setJavaVersion(@Nullable Integer javaVersion) {
        this.javaVersion = javaVersion;
    }

    public Integer getJavaVersion() {
        return this.javaVersion;
    }

    public void visitFile(@Nullable Tree parsedTree) {
        this.semanticModel = null;
        CompilationUnitTree tree = new JavaTree.CompilationUnitTreeImpl(null, Lists.newArrayList(), Lists.newArrayList(), null);
        if (parsedTree != null && parsedTree.is(Tree.Kind.COMPILATION_UNIT)) {
            tree = (CompilationUnitTree)parsedTree;
            if (this.isNotJavaLangOrSerializable(PackageUtils.packageName(tree.packageDeclaration(), "/"))) {
                try {
                    this.semanticModel = SemanticModel.createFor(tree, this.getProjectClasspath());
                }
                catch (Exception e) {
                    LOG.error("Unable to create symbol table for : " + this.getContext().getFile().getAbsolutePath(), (Throwable)e);
                    return;
                }
                this.createSonarSymbolTable(tree);
            } else {
                SemanticModel.handleMissingTypes(tree);
            }
        }
        JavaFileScannerContext javaFileScannerContext = this.createScannerContext(tree, this.semanticModel, this.analyseAccessors, this.sonarComponents);
        for (JavaFileScanner scanner : this.executableScanners(this.scanners)) {
            scanner.scanFile(javaFileScannerContext);
        }
        if (this.semanticModel != null) {
            this.semanticModel.done();
        }
    }

    private List<JavaFileScanner> executableScanners(List<JavaFileScanner> scanners) {
        ImmutableList.Builder results = ImmutableList.builder();
        for (JavaFileScanner scanner : scanners) {
            if (!this.shouldBeExecuted(scanner)) continue;
            results.add((Object)scanner);
        }
        return results.build();
    }

    private boolean shouldBeExecuted(JavaFileScanner scanner) {
        if (scanner instanceof JavaVersionAwareVisitor) {
            return ((JavaVersionAwareVisitor)((Object)scanner)).isCompatibleWithJavaVersion(this.javaVersion);
        }
        return true;
    }

    protected JavaFileScannerContext createScannerContext(CompilationUnitTree tree, SemanticModel semanticModel, boolean analyseAccessors, SonarComponents sonarComponents) {
        return new DefaultJavaFileScannerContext(tree, (SourceFile)this.getContext().peekSourceCode(), this.getContext().getFile(), semanticModel, analyseAccessors, sonarComponents, this.javaVersion);
    }

    private boolean isNotJavaLangOrSerializable(String packageName) {
        String name = this.getContext().getFile().getName();
        return !InternalVisitorsBridge.inJavaLang(packageName) && !InternalVisitorsBridge.isAnnotation(packageName, name) && !InternalVisitorsBridge.isSerializable(packageName, name);
    }

    private static boolean isSerializable(String packageName, String name) {
        return "java/io".equals(packageName) && "Serializable.java".equals(name);
    }

    private static boolean isAnnotation(String packageName, String name) {
        return "java/lang/annotation".equals(packageName) && "Annotation.java".equals(name);
    }

    private static boolean inJavaLang(String packageName) {
        return "java/lang".equals(packageName);
    }

    private List<File> getProjectClasspath() {
        return this.projectClasspath;
    }

    private void createSonarSymbolTable(CompilationUnitTree tree) {
        if (this.sonarComponents != null) {
            SonarSymbolTableVisitor symVisitor = new SonarSymbolTableVisitor(this.sonarComponents.symbolizableFor(this.getContext().getFile()), this.semanticModel);
            symVisitor.visitCompilationUnit(tree);
        }
    }

    public void processRecognitionException(RecognitionException e) {
        for (JavaFileScanner scanner : this.scanners) {
            if (!(scanner instanceof AstScannerExceptionHandler)) continue;
            ((AstScannerExceptionHandler)scanner).processRecognitionException(e);
        }
    }

    public VisitorContext getContext() {
        return this.context;
    }

    public void setContext(VisitorContext context) {
        this.context = context;
    }
}

