/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.SymbolMetadataResolve;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class JavaSymbol
implements Symbol {
    public static final int PCK = 1;
    public static final int TYP = 2;
    public static final int VAR = 4;
    public static final int MTH = 16;
    public static final int ERRONEOUS = 64;
    public static final int AMBIGUOUS = 65;
    public static final int ABSENT = 66;
    final int kind;
    final SymbolMetadataResolve symbolMetadata;
    int flags;
    String name;
    JavaSymbol owner;
    Completer completer;
    JavaType type;
    private List<IdentifierTree> usages;

    public JavaSymbol(int kind, int flags, @Nullable String name, @Nullable JavaSymbol owner) {
        this.kind = kind;
        this.flags = flags;
        this.name = name;
        this.owner = owner;
        this.symbolMetadata = new SymbolMetadataResolve();
        this.usages = Lists.newArrayList();
    }

    public int flags() {
        return this.flags;
    }

    @Override
    public JavaSymbol owner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public SymbolMetadataResolve metadata() {
        this.complete();
        return this.symbolMetadata;
    }

    public void complete() {
        if (this.completer != null) {
            Completer c = this.completer;
            this.completer = null;
            c.complete(this);
        }
    }

    public TypeJavaSymbol outermostClass() {
        JavaSymbol symbol = this;
        JavaSymbol result = null;
        while (symbol.kind != 1) {
            result = symbol;
            symbol = symbol.owner();
        }
        return (TypeJavaSymbol)result;
    }

    public PackageJavaSymbol packge() {
        JavaSymbol result = this;
        while (result.kind != 1) {
            result = result.owner();
        }
        return (PackageJavaSymbol)result;
    }

    @Override
    public TypeJavaSymbol enclosingClass() {
        JavaSymbol result = this;
        while (result != null && result.kind != 2) {
            result = result.owner;
        }
        return (TypeJavaSymbol)result;
    }

    boolean isKind(int kind) {
        return (this.kind & kind) != 0;
    }

    public JavaType getType() {
        return this.type;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public boolean isVariableSymbol() {
        return this.isKind(4);
    }

    @Override
    public boolean isTypeSymbol() {
        return this.isKind(2);
    }

    @Override
    public boolean isMethodSymbol() {
        return this.isKind(16);
    }

    @Override
    public boolean isPackageSymbol() {
        return this.isKind(1);
    }

    @Override
    public boolean isStatic() {
        return this.isFlag(8);
    }

    @Override
    public boolean isFinal() {
        return this.isFlag(16);
    }

    @Override
    public boolean isEnum() {
        return this.isFlag(16384);
    }

    @Override
    public boolean isInterface() {
        return this.isFlag(512);
    }

    @Override
    public boolean isAbstract() {
        return this.isFlag(1024);
    }

    @Override
    public boolean isPublic() {
        return this.isFlag(1);
    }

    @Override
    public boolean isPrivate() {
        return this.isFlag(2);
    }

    @Override
    public boolean isProtected() {
        return this.isFlag(4);
    }

    @Override
    public boolean isDeprecated() {
        return this.isFlag(131072);
    }

    @Override
    public boolean isVolatile() {
        return this.isFlag(64);
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public String name() {
        return this.name;
    }

    protected boolean isFlag(int flag) {
        this.complete();
        return (this.flags & flag) != 0;
    }

    @Override
    public boolean isPackageVisibility() {
        this.complete();
        return (this.flags & 7) == 0;
    }

    public void addUsage(IdentifierTree tree) {
        this.usages.add(tree);
    }

    @Override
    public List<IdentifierTree> usages() {
        return this.usages;
    }

    @Override
    @Nullable
    public Tree declaration() {
        return null;
    }

    public static class JavaLabelSymbol
    extends JavaSymbol
    implements Symbol.LabelSymbol {
        private LabeledStatementTree declaration;

        public JavaLabelSymbol(LabeledStatementTree tree) {
            super(0, 0, tree.label().name(), null);
            this.declaration = tree;
        }

        @Override
        public LabeledStatementTree declaration() {
            return this.declaration;
        }
    }

    public static class TypeVariableJavaSymbol
    extends TypeJavaSymbol {
        public TypeVariableJavaSymbol(String name, JavaSymbol owner) {
            super(0, name, owner);
            this.type = new JavaType.TypeVariableJavaType(this);
            this.members = new Scope(this);
        }

        @Override
        @Nullable
        public JavaType getSuperclass() {
            return null;
        }

        @Override
        public List<JavaType> getInterfaces() {
            return ImmutableList.of();
        }

        @Override
        public ClassTree declaration() {
            return null;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.name;
        }

        @Override
        String getInternalName() {
            throw new UnsupportedOperationException();
        }
    }

    public static class MethodJavaSymbol
    extends JavaSymbol
    implements Symbol.MethodSymbol {
        TypeJavaSymbol returnType;
        Scope parameters;
        Scope typeParameters;
        List<JavaType.TypeVariableJavaType> typeVariableTypes;
        MethodTree declaration;

        public MethodJavaSymbol(int flags, String name, JavaType type, JavaSymbol owner) {
            super(16, flags, name, owner);
            this.type = type;
            this.returnType = ((JavaType.MethodJavaType)type).resultType.symbol;
            this.typeVariableTypes = Lists.newArrayList();
        }

        public MethodJavaSymbol(int flags, String name, JavaSymbol owner) {
            super(16, flags, name, owner);
            this.typeVariableTypes = Lists.newArrayList();
        }

        public TypeJavaSymbol getReturnType() {
            return this.returnType;
        }

        public Scope getParameters() {
            return this.parameters;
        }

        private List<JavaType> getParametersTypes() {
            Preconditions.checkState((this.type != null ? 1 : 0) != 0);
            return ((JavaType.MethodJavaType)this.type).argTypes;
        }

        public Scope typeParameters() {
            return this.typeParameters;
        }

        public void setMethodType(JavaType.MethodJavaType methodType) {
            this.type = methodType;
            if (methodType.resultType != null) {
                this.returnType = methodType.resultType.symbol;
            }
        }

        public Boolean isOverriden() {
            Boolean result = false;
            Symbol.TypeSymbol enclosingClass = this.enclosingClass();
            for (JavaType.ClassJavaType superType : ((TypeJavaSymbol)enclosingClass).superTypes()) {
                Boolean overrideFromType = this.overridesFromSymbol(superType);
                if (overrideFromType == null) {
                    result = null;
                    continue;
                }
                if (!BooleanUtils.isTrue((Boolean)overrideFromType)) continue;
                return true;
            }
            return result;
        }

        @Nullable
        private Boolean overridesFromSymbol(JavaType.ClassJavaType classType) {
            Boolean result = false;
            if (classType.isTagged(14)) {
                return null;
            }
            List<JavaSymbol> symbols = classType.getSymbol().members().lookup(this.name);
            for (JavaSymbol overrideSymbol : symbols) {
                if (!overrideSymbol.isKind(16) || !this.canOverride((MethodJavaSymbol)overrideSymbol)) continue;
                Boolean isOverriding = this.isOverriding((MethodJavaSymbol)overrideSymbol, classType);
                if (isOverriding == null) {
                    result = null;
                    continue;
                }
                if (!BooleanUtils.isTrue((Boolean)isOverriding)) continue;
                return true;
            }
            return result;
        }

        private boolean canOverride(MethodJavaSymbol overridee) {
            if (overridee.isPackageVisibility()) {
                return overridee.outermostClass().owner().equals(this.outermostClass().owner());
            }
            return !overridee.isPrivate();
        }

        @Nullable
        private Boolean isOverriding(MethodJavaSymbol overridee, JavaType.ClassJavaType classType) {
            if (this.getParametersTypes().size() != overridee.getParametersTypes().size()) {
                return false;
            }
            for (int i = 0; i < this.getParametersTypes().size(); ++i) {
                JavaType paramOverrider = this.getParametersTypes().get(i);
                if (paramOverrider.isTagged(14)) {
                    return null;
                }
                JavaType overrideeType = overridee.getParametersTypes().get(i);
                if (classType instanceof JavaType.ParametrizedTypeJavaType && (overrideeType = ((JavaType.ParametrizedTypeJavaType)classType).typeSubstitution.substitutedType(overrideeType)) == null) {
                    overrideeType = overridee.getParametersTypes().get(i);
                }
                if (paramOverrider.erasure().equals(overrideeType.erasure())) continue;
                return false;
            }
            return true;
        }

        public boolean isVarArgs() {
            return this.isFlag(128);
        }

        public void addTypeParameter(JavaType.TypeVariableJavaType typeVariableType) {
            this.typeVariableTypes.add(typeVariableType);
        }

        @Override
        public List<Type> parameterTypes() {
            return Lists.newArrayList(this.getParametersTypes());
        }

        @Override
        public Symbol.TypeSymbol returnType() {
            return this.returnType;
        }

        @Override
        public List<Type> thrownTypes() {
            return Lists.newArrayList(((JavaType.MethodJavaType)this.type).thrown);
        }

        @Override
        public MethodTree declaration() {
            return this.declaration;
        }
    }

    public static class VariableJavaSymbol
    extends JavaSymbol
    implements Symbol.VariableSymbol {
        VariableTree declaration;

        public VariableJavaSymbol(int flags, String name, JavaSymbol owner) {
            super(4, flags, name, owner);
        }

        public VariableJavaSymbol(int flags, String name, JavaType type, JavaSymbol owner) {
            super(4, flags, name, owner);
            this.type = type;
        }

        @Override
        public VariableTree declaration() {
            return this.declaration;
        }
    }

    public static class TypeJavaSymbol
    extends JavaSymbol
    implements Symbol.TypeSymbol {
        Scope members;
        Scope typeParameters;
        List<JavaType.TypeVariableJavaType> typeVariableTypes;
        ClassTree declaration;
        private final String internalName;
        private final Multiset<String> internalNames = HashMultiset.create();

        public TypeJavaSymbol(int flags, String name, JavaSymbol owner) {
            super(2, flags, name, owner);
            this.type = new JavaType.ClassJavaType(this);
            this.typeVariableTypes = Lists.newArrayList();
            this.internalName = owner.isMethodSymbol() ? ((TypeJavaSymbol)owner.owner).registerClassInternalName(name) : (owner.isTypeSymbol() && name.isEmpty() ? ((TypeJavaSymbol)owner).registerClassInternalName("") : name);
        }

        private String registerClassInternalName(String name) {
            this.internalNames.add((Object)name);
            return this.internalNames.count((Object)name) + name;
        }

        String getInternalName() {
            return this.internalName;
        }

        public void addTypeParameter(JavaType.TypeVariableJavaType typeVariableType) {
            this.typeVariableTypes.add(typeVariableType);
        }

        @Nullable
        public JavaType getSuperclass() {
            this.complete();
            return ((JavaType.ClassJavaType)this.type).supertype;
        }

        public List<JavaType> getInterfaces() {
            this.complete();
            return ((JavaType.ClassJavaType)this.type).interfaces;
        }

        public Scope members() {
            this.complete();
            return this.members;
        }

        public Scope typeParameters() {
            this.complete();
            return this.typeParameters;
        }

        public String getFullyQualifiedName() {
            String newQualification = "";
            if (this.owner.isPackageSymbol()) {
                if (!this.owner.name.isEmpty()) {
                    newQualification = this.owner.name + ".";
                }
            } else if (this.owner.isTypeSymbol()) {
                newQualification = this.owner.type.fullyQualifiedName() + "$";
            } else if (this.owner.isMethodSymbol()) {
                newQualification = this.owner.owner.type().fullyQualifiedName() + "$";
            } else {
                throw new IllegalStateException("" + this.owner);
            }
            return newQualification + this.getInternalName();
        }

        public Set<JavaType.ClassJavaType> superTypes() {
            ImmutableSet.Builder types = ImmutableSet.builder();
            JavaType.ClassJavaType superClassType = (JavaType.ClassJavaType)this.superClass();
            types.addAll(this.interfacesOfType());
            while (superClassType != null) {
                types.add((Object)superClassType);
                TypeJavaSymbol superClassSymbol = superClassType.getSymbol();
                types.addAll(superClassSymbol.interfacesOfType());
                superClassType = (JavaType.ClassJavaType)superClassSymbol.superClass();
            }
            return types.build();
        }

        private Set<JavaType.ClassJavaType> interfacesOfType() {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (JavaType interfaceType : this.getInterfaces()) {
                JavaType.ClassJavaType classType = (JavaType.ClassJavaType)interfaceType;
                builder.add((Object)classType);
                builder.addAll(classType.getSymbol().interfacesOfType());
            }
            return builder.build();
        }

        public String toString() {
            return this.name;
        }

        @Override
        public Type superClass() {
            return this.getSuperclass();
        }

        @Override
        public List<Type> interfaces() {
            return Lists.newArrayList(this.getInterfaces());
        }

        @Override
        public Collection<Symbol> memberSymbols() {
            return Lists.newArrayList(this.members().scopeSymbols());
        }

        @Override
        public Collection<Symbol> lookupSymbols(String name) {
            return Lists.newArrayList(this.members().lookup(name));
        }

        @Override
        public ClassTree declaration() {
            return this.declaration;
        }
    }

    public static class PackageJavaSymbol
    extends JavaSymbol {
        Scope members;

        public PackageJavaSymbol(@Nullable String name, @Nullable JavaSymbol owner) {
            super(1, 0, name, owner);
        }

        Scope completedMembers() {
            this.complete();
            return this.members;
        }
    }

    static interface Completer {
        public void complete(JavaSymbol var1);
    }
}

