/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.parser;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;

public enum JavaLexer implements GrammarRuleKey
{
    COMPILATION_UNIT,
    PACKAGE_DECLARATION,
    IMPORT_DECLARATION,
    TYPE_DECLARATION,
    ANNOTATION,
    QUALIFIED_IDENTIFIER,
    QUALIFIED_IDENTIFIER_LIST,
    CLASS_DECLARATION,
    ENUM_DECLARATION,
    INTERFACE_DECLARATION,
    ANNOTATION_TYPE_DECLARATION,
    TYPE_PARAMETERS,
    CLASS_BODY,
    CLASS_BODY_DECLARATION,
    CLASS_INIT_DECLARATION,
    BLOCK,
    MEMBER_DECL,
    FIELD_DECLARATION,
    GENERIC_METHOD_OR_CONSTRUCTOR_REST,
    TYPE,
    METHOD_DECLARATOR_REST,
    VARIABLE_DECLARATORS,
    VOID_METHOD_DECLARATOR_REST,
    CONSTRUCTOR_DECLARATOR_REST,
    FORMAL_PARAMETERS,
    ANNOTATED_DIM,
    DIM,
    METHOD_BODY,
    INTERFACE_BODY,
    INTERFACE_BODY_DECLARATION,
    INTERFACE_MEMBER_DECL,
    INTERFACE_METHOD_OR_FIELD_DECL,
    INTERFACE_GENERIC_METHOD_DECL,
    VOID_INTERFACE_METHOD_DECLARATORS_REST,
    INTERFACE_METHOD_OR_FIELD_REST,
    INTERFACE_METHOD_DECLARATOR_REST,
    VARIABLE_INITIALIZER,
    ENUM_BODY,
    ENUM_CONSTANTS,
    ENUM_BODY_DECLARATIONS,
    ENUM_CONSTANT,
    ARGUMENTS,
    LOCAL_VARIABLE_DECLARATION_STATEMENT,
    VARIABLE_DECLARATOR,
    FORMAL_PARAMETER,
    FORMAL_PARAMETER_DECLS,
    FORMAL_PARAMETERS_DECLS_REST,
    VARIABLE_DECLARATOR_ID,
    BLOCK_STATEMENTS,
    BLOCK_STATEMENT,
    STATEMENT,
    LABELED_STATEMENT,
    EXPRESSION_STATEMENT,
    IF_STATEMENT,
    WHILE_STATEMENT,
    FOR_STATEMENT,
    ASSERT_STATEMENT,
    SWITCH_STATEMENT,
    DO_STATEMENT,
    BREAK_STATEMENT,
    CONTINUE_STATEMENT,
    RETURN_STATEMENT,
    SYNCHRONIZED_STATEMENT,
    THROW_STATEMENT,
    EMPTY_STATEMENT,
    EXPRESSION,
    RESOURCE,
    PAR_EXPRESSION,
    FOR_INIT,
    FOR_UPDATE,
    CATCH_CLAUSE,
    CATCH_FORMAL_PARAMETER,
    CATCH_TYPE,
    FINALLY_,
    STATEMENT_EXPRESSION,
    TRY_STATEMENT,
    TRY_WITH_RESOURCES_STATEMENT,
    RESOURCE_SPECIFICATION,
    SWITCH_BLOCK_STATEMENT_GROUP,
    SWITCH_LABEL,
    BASIC_TYPE,
    TYPE_ARGUMENTS,
    TYPE_ARGUMENT,
    TYPE_PARAMETER,
    BOUND,
    CONDITIONAL_EXPRESSION,
    DEFAULT_VALUE,
    ANNOTATION_TYPE_BODY,
    ANNOTATION_TYPE_ELEMENT_DECLARATION,
    ANNOTATION_TYPE_ELEMENT_REST,
    ANNOTATION_METHOD_OR_CONSTANT_REST,
    ANNOTATION_METHOD_REST,
    ANNOTATION_REST,
    NORMAL_ANNOTATION_REST,
    ELEMENT_VALUE_PAIRS,
    ELEMENT_VALUE_PAIR,
    ELEMENT_VALUE,
    ELEMENT_VALUE_ARRAY_INITIALIZER,
    ELEMENT_VALUES,
    SINGLE_ELEMENT_ANNOTATION_REST,
    ASSIGNMENT_EXPRESSION,
    ASSIGNMENT_OPERATOR,
    CONDITIONAL_OR_EXPRESSION,
    CONDITIONAL_AND_EXPRESSION,
    INCLUSIVE_OR_EXPRESSION,
    EXCLUSIVE_OR_EXPRESSION,
    AND_EXPRESSION,
    EQUALITY_EXPRESSION,
    RELATIONAL_EXPRESSION,
    SHIFT_EXPRESSION,
    ADDITIVE_EXPRESSION,
    MULTIPLICATIVE_EXPRESSION,
    UNARY_EXPRESSION,
    PREFIX_OP,
    PRIMARY,
    NEW_EXPRESSION,
    BASIC_CLASS_EXPRESSION,
    VOID_CLASS_EXPRESSION,
    SELECTOR,
    POST_FIX_OP,
    LITERAL,
    CREATOR,
    DIM_EXPR,
    CLASS_CREATOR_REST,
    ARRAY_CREATOR_REST,
    ARRAY_INITIALIZER,
    EOF,
    LETTER_OR_DIGIT,
    KEYWORD,
    SPACING,
    METHOD_REFERENCE,
    LAMBDA_EXPRESSION,
    LAMBDA_PARAMETERS,
    LAMBDA_BODY,
    ARROW,
    UNARY_EXPRESSION_NOT_PLUS_MINUS,
    CAST_EXPRESSION,
    MODIFIERS,
    ANNOTATION_ARGUMENTS,
    INFERED_PARAMS,
    IDENTIFIER_OR_METHOD_INVOCATION,
    ANNOTATED_PARAMETERIZED_IDENTIFIER;

    private static final String EXP_REGEXP = "(?:[Ee][+-]?+[0-9_]++)";
    private static final String BINARY_EXP_REGEXP = "(?:[Pp][+-]?+[0-9_]++)";
    private static final String FLOATING_LITERAL_WITHOUT_SUFFIX_REGEXP = "(?:[0-9][0-9_]*+\\.([0-9_]++)?+(?:[Ee][+-]?+[0-9_]++)?+|\\.[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)?+|[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++\\.[0-9_a-fA-F]*+(?:[Pp][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++(?:[Pp][+-]?+[0-9_]++))";
    private static final String INTEGER_LITERAL_REGEXP = "(?:0[xX][0-9_a-fA-F]++|0[bB][01_]++|[0-9][0-9_]*+)";

    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        JavaLexer.punctuators(b);
        JavaLexer.keywords(b);
        JavaLexer.literals(b);
        b.setRootRule((GrammarRuleKey)COMPILATION_UNIT);
        return b;
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        JavaLexer.punctuator(b, JavaPunctuator.AT, "@");
        JavaLexer.punctuator(b, JavaPunctuator.AND, "&", b.nextNot(b.firstOf((Object)"=", (Object)"&")));
        JavaLexer.punctuator(b, JavaPunctuator.ANDAND, "&&");
        JavaLexer.punctuator(b, JavaPunctuator.ANDEQU, "&=");
        JavaLexer.punctuator(b, JavaPunctuator.BANG, "!", b.nextNot((Object)"="));
        JavaLexer.punctuator(b, JavaPunctuator.BSR, ">>>", b.nextNot((Object)"="));
        JavaLexer.punctuator(b, JavaPunctuator.BSREQU, ">>>=");
        JavaLexer.punctuator(b, JavaPunctuator.COLON, ":");
        JavaLexer.punctuator(b, JavaPunctuator.DBLECOLON, "::");
        JavaLexer.punctuator(b, JavaPunctuator.COMMA, ",");
        JavaLexer.punctuator(b, JavaPunctuator.DEC, "--");
        JavaLexer.punctuator(b, JavaPunctuator.DIV, "/", b.nextNot((Object)"="));
        JavaLexer.punctuator(b, JavaPunctuator.DIVEQU, "/=");
        JavaLexer.punctuator(b, JavaPunctuator.DOT, ".");
        JavaLexer.punctuator(b, JavaPunctuator.ELLIPSIS, "...");
        JavaLexer.punctuator(b, JavaPunctuator.EQU, "=", b.nextNot((Object)"="));
        JavaLexer.punctuator(b, JavaPunctuator.EQUAL, "==");
        JavaLexer.punctuator(b, JavaPunctuator.GE, ">=");
        JavaLexer.punctuator(b, JavaPunctuator.GT, ">", b.nextNot(b.firstOf((Object)"=", (Object)">")));
        JavaLexer.punctuator(b, JavaPunctuator.HAT, "^", b.nextNot((Object)"="));
        JavaLexer.punctuator(b, JavaPunctuator.HATEQU, "^=");
        JavaLexer.punctuator(b, JavaPunctuator.INC, "++");
        JavaLexer.punctuator(b, JavaPunctuator.LBRK, "[");
        JavaLexer.punctuator(b, JavaPunctuator.LT, "<", b.nextNot(b.firstOf((Object)"=", (Object)"<")));
        JavaLexer.punctuator(b, JavaPunctuator.LE, "<=");
        JavaLexer.punctuator(b, JavaPunctuator.LPAR, "(");
        JavaLexer.punctuator(b, JavaPunctuator.LWING, "{");
        JavaLexer.punctuator(b, JavaPunctuator.MINUS, "-", b.nextNot(b.firstOf((Object)"-", (Object)"=")));
        JavaLexer.punctuator(b, JavaPunctuator.MINUSEQU, "-=");
        JavaLexer.punctuator(b, JavaPunctuator.MOD, "%", b.nextNot((Object)"="));
        JavaLexer.punctuator(b, JavaPunctuator.MODEQU, "%=");
        JavaLexer.punctuator(b, JavaPunctuator.NOTEQUAL, "!=");
        JavaLexer.punctuator(b, JavaPunctuator.OR, "|", b.nextNot(b.firstOf((Object)"=", (Object)"|")));
        JavaLexer.punctuator(b, JavaPunctuator.OREQU, "|=");
        JavaLexer.punctuator(b, JavaPunctuator.OROR, "||");
        JavaLexer.punctuator(b, JavaPunctuator.PLUS, "+", b.nextNot(b.firstOf((Object)"=", (Object)"+")));
        JavaLexer.punctuator(b, JavaPunctuator.PLUSEQU, "+=");
        JavaLexer.punctuator(b, JavaPunctuator.QUERY, "?");
        JavaLexer.punctuator(b, JavaPunctuator.RBRK, "]");
        JavaLexer.punctuator(b, JavaPunctuator.RPAR, ")");
        JavaLexer.punctuator(b, JavaPunctuator.RWING, "}");
        JavaLexer.punctuator(b, JavaPunctuator.SEMI, ";");
        JavaLexer.punctuator(b, JavaPunctuator.SL, "<<", b.nextNot((Object)"="));
        JavaLexer.punctuator(b, JavaPunctuator.SLEQU, "<<=");
        JavaLexer.punctuator(b, JavaPunctuator.SR, ">>", b.nextNot(b.firstOf((Object)"=", (Object)">")));
        JavaLexer.punctuator(b, JavaPunctuator.SREQU, ">>=");
        JavaLexer.punctuator(b, JavaPunctuator.STAR, "*", b.nextNot((Object)"="));
        JavaLexer.punctuator(b, JavaPunctuator.STAREQU, "*=");
        JavaLexer.punctuator(b, JavaPunctuator.TILDA, "~");
        JavaLexer.punctuator(b, JavaPunctuator.LPOINT, "<");
        JavaLexer.punctuator(b, JavaPunctuator.RPOINT, ">");
        JavaLexer.punctuator(b, ARROW, "->");
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)LETTER_OR_DIGIT).is(JavaLexer.javaIdentifierPart(b));
        for (JavaKeyword tokenType : JavaKeyword.values()) {
            b.rule((GrammarRuleKey)tokenType).is((Object)tokenType.getValue(), new Object[]{b.nextNot((Object)LETTER_OR_DIGIT), SPACING});
        }
        Object[] keywords = JavaKeyword.keywordValues();
        Arrays.sort(keywords);
        ArrayUtils.reverse((Object[])keywords);
        b.rule((GrammarRuleKey)KEYWORD).is(b.firstOf(keywords[0], keywords[1], ArrayUtils.subarray((Object[])keywords, (int)2, (int)keywords.length)), new Object[]{b.nextNot((Object)LETTER_OR_DIGIT)});
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value) {
        b.rule(ruleKey).is((Object)value, new Object[]{SPACING});
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value, Object element) {
        b.rule(ruleKey).is((Object)value, new Object[]{element, SPACING});
    }

    private static void literals(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)SPACING).is(b.skippedTrivia(JavaLexer.whitespace(b)), new Object[]{b.zeroOrMore(b.commentTrivia(b.firstOf(JavaLexer.inlineComment(b), JavaLexer.multilineComment(b))), new Object[]{b.skippedTrivia(JavaLexer.whitespace(b))})});
        b.rule((GrammarRuleKey)EOF).is(b.token((TokenType)GenericTokenType.EOF, b.endOfInput()));
        b.rule((GrammarRuleKey)JavaTokenType.CHARACTER_LITERAL).is(JavaLexer.characterLiteral(b), new Object[]{SPACING});
        b.rule((GrammarRuleKey)JavaTokenType.LITERAL).is(JavaLexer.stringLiteral(b), new Object[]{SPACING});
        b.rule((GrammarRuleKey)JavaTokenType.FLOAT_LITERAL).is(b.regexp("(?:[0-9][0-9_]*+\\.([0-9_]++)?+(?:[Ee][+-]?+[0-9_]++)?+|\\.[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)?+|[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++\\.[0-9_a-fA-F]*+(?:[Pp][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++(?:[Pp][+-]?+[0-9_]++))[fF]|[0-9][0-9_]*+[fF]"), new Object[]{SPACING});
        b.rule((GrammarRuleKey)JavaTokenType.DOUBLE_LITERAL).is(b.regexp("(?:[0-9][0-9_]*+\\.([0-9_]++)?+(?:[Ee][+-]?+[0-9_]++)?+|\\.[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)?+|[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++\\.[0-9_a-fA-F]*+(?:[Pp][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++(?:[Pp][+-]?+[0-9_]++))[dD]?+|[0-9][0-9_]*+[dD]"), new Object[]{SPACING});
        b.rule((GrammarRuleKey)JavaTokenType.LONG_LITERAL).is(b.regexp("(?:0[xX][0-9_a-fA-F]++|0[bB][01_]++|[0-9][0-9_]*+)[lL]"), new Object[]{SPACING});
        b.rule((GrammarRuleKey)JavaTokenType.INTEGER_LITERAL).is(b.regexp(INTEGER_LITERAL_REGEXP), new Object[]{SPACING});
        b.rule((GrammarRuleKey)JavaTokenType.IDENTIFIER).is(b.firstOf(b.next((Object)JavaKeyword.ENUM), b.nextNot((Object)KEYWORD)), new Object[]{JavaLexer.javaIdentifier(b), SPACING});
    }

    private static Object characterLiteral(LexerlessGrammarBuilder b) {
        return b.sequence(b.next((Object)"'"), b.regexp("'([^'\\\\]*+(\\\\[\\s\\S])?+)*+'"));
    }

    private static Object stringLiteral(LexerlessGrammarBuilder b) {
        return b.sequence(b.next((Object)"\""), b.regexp("\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\""));
    }

    private static Object whitespace(LexerlessGrammarBuilder b) {
        return b.regexp("\\s*+");
    }

    private static Object inlineComment(LexerlessGrammarBuilder b) {
        return b.regexp("//[^\\n\\r]*+");
    }

    private static Object multilineComment(LexerlessGrammarBuilder b) {
        return b.regexp("/\\*[\\s\\S]*?\\*\\/");
    }

    private static Object javaIdentifier(LexerlessGrammarBuilder b) {
        return b.regexp("\\p{javaJavaIdentifierStart}++\\p{javaJavaIdentifierPart}*+");
    }

    private static Object javaIdentifierPart(LexerlessGrammarBuilder b) {
        return b.regexp("\\p{javaJavaIdentifierPart}");
    }
}

