/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.source.Symbol;
import org.sonar.api.source.Symbolizable;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbols;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class SonarSymbolTableVisitor
extends BaseTreeVisitor {
    private final SemanticModel semanticModel;
    private final Symbolizable symbolizable;
    private final Symbolizable.SymbolTableBuilder symbolTableBuilder;
    private CompilationUnitTree outerClass;

    public SonarSymbolTableVisitor(Symbolizable symbolizable, SemanticModel semanticModel) {
        this.symbolizable = symbolizable;
        this.semanticModel = semanticModel;
        this.symbolTableBuilder = symbolizable.newSymbolTableBuilder();
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        if (this.outerClass == null) {
            this.outerClass = tree;
        }
        super.visitCompilationUnit(tree);
        if (tree.equals(this.outerClass)) {
            this.symbolizable.setSymbolTable(this.symbolTableBuilder.build());
        }
    }

    @Override
    public void visitClass(ClassTree tree) {
        IdentifierTree simpleName = tree.simpleName();
        if (simpleName != null) {
            this.createSymbol(simpleName, tree.symbol().usages());
        }
        for (TypeParameterTree typeParameterTree : tree.typeParameters()) {
            this.createSymbol(typeParameterTree.identifier(), typeParameterTree);
        }
        super.visitClass(tree);
    }

    @Override
    public void visitVariable(VariableTree tree) {
        this.createSymbol(tree.simpleName(), tree.symbol().usages());
        super.visitVariable(tree);
    }

    @Override
    public void visitEnumConstant(EnumConstantTree tree) {
        this.createSymbol(tree.simpleName(), tree);
        super.visitEnumConstant(tree);
    }

    @Override
    public void visitMethod(MethodTree tree) {
        List<IdentifierTree> usages = tree.symbol().usages();
        if (tree.symbol().returnType() == null) {
            if (tree.symbol().owner().isEnum()) {
                this.createSymbol(tree.simpleName(), Lists.newArrayList());
            } else {
                String constructorName = tree.simpleName().name();
                ArrayList filteredUsages = Lists.newArrayList((Iterable)Iterables.filter(usages, (Predicate)new SameNameFilter(constructorName)));
                this.createSymbol(tree.simpleName(), filteredUsages);
            }
        } else {
            this.createSymbol(tree.simpleName(), usages);
        }
        super.visitMethod(tree);
    }

    @Override
    public void visitLabeledStatement(LabeledStatementTree tree) {
        this.createSymbol(tree.label(), tree.symbol().usages());
        super.visitLabeledStatement(tree);
    }

    @Override
    public void visitImport(ImportTree tree) {
        IdentifierTree identifierTree = tree.qualifiedIdentifier().is(Tree.Kind.IDENTIFIER) ? (IdentifierTree)tree.qualifiedIdentifier() : ((MemberSelectExpressionTree)tree.qualifiedIdentifier()).identifier();
        if (!"*".equals(identifierTree.name())) {
            this.createSymbol(identifierTree, tree);
        }
        super.visitImport(tree);
    }

    private void createSymbol(IdentifierTree declaration, Tree tree) {
        org.sonar.plugins.java.api.semantic.Symbol semanticSymbol = this.semanticModel.getSymbol(tree);
        if (semanticSymbol == null) {
            semanticSymbol = Symbols.unknownSymbol;
        }
        this.createSymbol(declaration, semanticSymbol.usages());
    }

    private void createSymbol(IdentifierTree declaration, List<IdentifierTree> usages) {
        Symbol symbol = this.symbolTableBuilder.newSymbol(SonarSymbolTableVisitor.startOffsetFor(declaration), SonarSymbolTableVisitor.endOffsetFor(declaration));
        for (IdentifierTree usage : usages) {
            this.symbolTableBuilder.newReference(symbol, SonarSymbolTableVisitor.startOffsetFor(usage));
        }
    }

    private static int startOffsetFor(IdentifierTree tree) {
        return ((InternalSyntaxToken)tree.identifierToken()).fromIndex();
    }

    private static int endOffsetFor(IdentifierTree tree) {
        return ((InternalSyntaxToken)tree.identifierToken()).fromIndex() + tree.identifierToken().text().length();
    }

    private static class SameNameFilter
    implements Predicate<IdentifierTree> {
        private final String constructorName;

        public SameNameFilter(String constructorName) {
            this.constructorName = constructorName;
        }

        public boolean apply(IdentifierTree input) {
            return this.constructorName.equals(input.name());
        }
    }
}

