/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class SubscriptionVisitor
implements JavaFileScanner {
    protected JavaFileScannerContext context;
    private Collection<Tree.Kind> nodesToVisit;
    private boolean visitToken;
    private boolean visitTrivia;
    private SemanticModel semanticModel;

    public abstract List<Tree.Kind> nodesToVisit();

    public void visitNode(Tree tree) {
    }

    public void leaveNode(Tree tree) {
    }

    public void visitToken(SyntaxToken syntaxToken) {
    }

    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.semanticModel = (SemanticModel)context.getSemanticModel();
        this.scanTree(context.getTree());
    }

    protected void scanTree(Tree tree) {
        this.nodesToVisit = this.nodesToVisit();
        this.visitToken = this.isVisitingTokens();
        this.visitTrivia = this.isVisitingTrivia();
        this.visit(tree);
    }

    private void visit(Tree tree) {
        boolean shouldVisitSyntaxToken;
        boolean isSubscribed = this.isSubscribed(tree);
        boolean bl = shouldVisitSyntaxToken = (this.visitToken || this.visitTrivia) && tree.is(Tree.Kind.TOKEN);
        if (shouldVisitSyntaxToken) {
            SyntaxToken syntaxToken = (SyntaxToken)tree;
            if (this.visitToken) {
                this.visitToken(syntaxToken);
            }
            if (this.visitTrivia) {
                for (SyntaxTrivia syntaxTrivia : syntaxToken.trivias()) {
                    this.visitTrivia(syntaxTrivia);
                }
            }
        } else if (isSubscribed) {
            this.visitNode(tree);
        }
        this.visitChildren(tree);
        if (!shouldVisitSyntaxToken && isSubscribed) {
            this.leaveNode(tree);
        }
    }

    private boolean isSubscribed(Tree tree) {
        return this.nodesToVisit.contains((Object)tree.kind());
    }

    private boolean isVisitingTrivia() {
        return this.nodesToVisit.contains((Object)Tree.Kind.TRIVIA);
    }

    private boolean isVisitingTokens() {
        return this.nodesToVisit.contains((Object)Tree.Kind.TOKEN);
    }

    private void visitChildren(Tree tree) {
        JavaTree javaTree = (JavaTree)tree;
        if (!javaTree.isLeaf()) {
            Iterator<Tree> iter = javaTree.childrenIterator();
            while (iter.hasNext()) {
                Tree next = iter.next();
                if (next == null) continue;
                this.visit(next);
            }
        }
    }

    public boolean hasSemantic() {
        return this.semanticModel != null;
    }
}

