/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.cfg;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

public class CFG {
    private final Symbol.MethodSymbol methodSymbol;
    private Block currentBlock;
    private final List<Block> blocks = new ArrayList<Block>();
    private final Deque<Block> breakTargets = new LinkedList<Block>();
    private final Deque<Block> continueTargets = new LinkedList<Block>();
    private final Deque<Block> exitBlocks = new LinkedList<Block>();
    private final Deque<Block> switches = new LinkedList<Block>();
    private String pendingLabel = null;
    private Map<String, Block> labelsBreakTarget = Maps.newHashMap();
    private Map<String, Block> labelsContinueTarget = Maps.newHashMap();

    private CFG(BlockTree tree, Symbol.MethodSymbol symbol) {
        this.methodSymbol = symbol;
        this.exitBlocks.add(this.createBlock());
        this.currentBlock = this.createBlock(this.exitBlock());
        for (StatementTree statementTree : Lists.reverse(tree.body())) {
            this.build(statementTree);
        }
        this.prune();
        CFG.computePredecessors(this.blocks);
    }

    private Block exitBlock() {
        return this.exitBlocks.peek();
    }

    public Symbol.MethodSymbol methodSymbol() {
        return this.methodSymbol;
    }

    public Block entry() {
        return this.currentBlock;
    }

    public List<Block> blocks() {
        return Lists.reverse(this.blocks);
    }

    public List<Block> reversedBlocks() {
        return this.blocks;
    }

    private static void computePredecessors(List<Block> blocks) {
        for (Block b : blocks) {
            for (Block successor : b.successors) {
                successor.predecessors.add(b);
            }
        }
    }

    private void prune() {
        ArrayList<Block> inactiveBlocks = new ArrayList<Block>();
        boolean first = true;
        for (Block block : this.blocks) {
            if (!first && this.isInactive(block)) {
                inactiveBlocks.add(block);
            }
            first = false;
        }
        if (!inactiveBlocks.isEmpty()) {
            this.removeInactiveBlocks(inactiveBlocks);
            if (inactiveBlocks.contains(this.currentBlock)) {
                this.currentBlock = (Block)this.currentBlock.successors.iterator().next();
            }
            int id = 0;
            for (Block block : this.blocks) {
                block.id = id;
                ++id;
            }
        }
    }

    private boolean isInactive(Block block) {
        if (block.equals(this.currentBlock) && block.successors.size() > 1) {
            return false;
        }
        return block.isInactive();
    }

    private void removeInactiveBlocks(List<Block> inactiveBlocks) {
        for (Block inactiveBlock : inactiveBlocks) {
            for (Block block : this.blocks) {
                block.prune(inactiveBlock);
            }
        }
        this.blocks.removeAll(inactiveBlocks);
    }

    private Block createBlock(Block successor) {
        Block result = this.createBlock();
        result.addSuccessor(successor);
        return result;
    }

    private Block createBlock() {
        Block result = new Block(this.blocks.size());
        this.blocks.add(result);
        return result;
    }

    public static CFG build(MethodTree tree) {
        BlockTree block = tree.block();
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Cannot build CFG for method with no body.");
        return new CFG(block, tree.symbol());
    }

    private void build(List<? extends Tree> trees) {
        for (Tree tree : Lists.reverse(trees)) {
            this.build(tree);
        }
    }

    private void build(Tree tree) {
        switch (tree.kind()) {
            case BLOCK: {
                this.build(((BlockTree)tree).body());
                break;
            }
            case RETURN_STATEMENT: {
                this.buildReturnStatement((ReturnStatementTree)tree);
                break;
            }
            case EXPRESSION_STATEMENT: {
                this.build(((ExpressionStatementTree)tree).expression());
                break;
            }
            case METHOD_INVOCATION: {
                this.buildMethodInvocation((MethodInvocationTree)tree);
                break;
            }
            case IF_STATEMENT: {
                this.buildIfStatement((IfStatementTree)tree);
                break;
            }
            case CONDITIONAL_EXPRESSION: {
                this.buildConditionalExpression((ConditionalExpressionTree)tree);
                break;
            }
            case VARIABLE: {
                this.buildVariable((VariableTree)tree);
                break;
            }
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: 
            case PLUS: 
            case MINUS: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case AND: 
            case XOR: 
            case OR: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL_TO: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL_TO: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                this.buildBinaryExpression(tree);
                break;
            }
            case ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: {
                this.buildAssignment((AssignmentExpressionTree)tree);
                break;
            }
            case MEMBER_SELECT: {
                this.buildMemberSelect((MemberSelectExpressionTree)tree);
                break;
            }
            case CONDITIONAL_AND: {
                this.buildConditionalAnd((BinaryExpressionTree)tree);
                break;
            }
            case CONDITIONAL_OR: {
                this.buildConditionalOr((BinaryExpressionTree)tree);
                break;
            }
            case LABELED_STATEMENT: {
                this.buildLabeledStatement((LabeledStatementTree)tree);
                break;
            }
            case SWITCH_STATEMENT: {
                this.buildSwitchStatement((SwitchStatementTree)tree);
                break;
            }
            case BREAK_STATEMENT: {
                this.buildBreakStatement((BreakStatementTree)tree);
                break;
            }
            case CONTINUE_STATEMENT: {
                this.buildContinueStatement((ContinueStatementTree)tree);
                break;
            }
            case WHILE_STATEMENT: {
                this.buildWhileStatement((WhileStatementTree)tree);
                break;
            }
            case DO_STATEMENT: {
                this.buildDoWhileStatement((DoWhileStatementTree)tree);
                break;
            }
            case FOR_EACH_STATEMENT: {
                this.buildForEachStatement((ForEachStatement)tree);
                break;
            }
            case FOR_STATEMENT: {
                this.buildForStatement((ForStatementTree)tree);
                break;
            }
            case TRY_STATEMENT: {
                this.buildTryStatement((TryStatementTree)tree);
                break;
            }
            case THROW_STATEMENT: {
                this.buildThrowStatement((ThrowStatementTree)tree);
                break;
            }
            case SYNCHRONIZED_STATEMENT: {
                this.buildSynchronizedStatement((SynchronizedStatementTree)tree);
                break;
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case UNARY_MINUS: 
            case UNARY_PLUS: 
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: {
                this.buildUnaryExpression((UnaryExpressionTree)tree);
                break;
            }
            case PARENTHESIZED_EXPRESSION: {
                this.build(((ParenthesizedTree)tree).expression());
                break;
            }
            case ARRAY_ACCESS_EXPRESSION: {
                this.buildArrayAccessExpression((ArrayAccessExpressionTree)tree);
                break;
            }
            case ARRAY_DIMENSION: {
                this.buildArrayDimension((ArrayDimensionTree)tree);
                break;
            }
            case NEW_CLASS: {
                this.buildNewClass((NewClassTree)tree);
                break;
            }
            case TYPE_CAST: {
                this.buildTypeCast(tree);
                break;
            }
            case INSTANCE_OF: {
                this.buildInstanceOf((InstanceOfTree)tree);
                break;
            }
            case NEW_ARRAY: {
                this.buildNewArray((NewArrayTree)tree);
                break;
            }
            case ASSERT_STATEMENT: {
                break;
            }
            case EMPTY_STATEMENT: 
            case CLASS: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: 
            case METHOD_REFERENCE: 
            case LAMBDA_EXPRESSION: 
            case IDENTIFIER: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case DOUBLE_LITERAL: 
            case CHAR_LITERAL: 
            case FLOAT_LITERAL: 
            case STRING_LITERAL: 
            case BOOLEAN_LITERAL: 
            case NULL_LITERAL: {
                this.currentBlock.elements.add(tree);
                break;
            }
            default: {
                throw new UnsupportedOperationException(tree.kind().name() + " " + ((JavaTree)tree).getLine());
            }
        }
    }

    private void buildReturnStatement(ReturnStatementTree returnStatement) {
        this.currentBlock = this.createUnconditionalJump(returnStatement, this.exitBlock());
        ExpressionTree expression = returnStatement.expression();
        if (expression != null) {
            this.build(expression);
        }
    }

    private void buildMethodInvocation(MethodInvocationTree mit) {
        this.currentBlock.elements.add(mit);
        if (mit.methodSelect().is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)mit.methodSelect();
            this.build(memberSelect.expression());
        } else {
            this.build(mit.methodSelect());
        }
        for (ExpressionTree arg : Lists.reverse((List)mit.arguments())) {
            this.build(arg);
        }
    }

    private void buildIfStatement(IfStatementTree ifStatementTree) {
        Block next;
        Block elseBlock = next = this.currentBlock;
        StatementTree elseStatement = ifStatementTree.elseStatement();
        if (elseStatement != null) {
            if (!elseStatement.is(Tree.Kind.IF_STATEMENT)) {
                this.currentBlock = this.createBlock(next);
            }
            this.build(elseStatement);
            elseBlock = this.currentBlock;
        }
        this.currentBlock = this.createBlock(next);
        this.build(ifStatementTree.thenStatement());
        Block thenBlock = this.currentBlock;
        this.currentBlock = this.createBranch(ifStatementTree, thenBlock, elseBlock);
        this.buildCondition(ifStatementTree.condition(), thenBlock, elseBlock);
    }

    private void buildConditionalExpression(ConditionalExpressionTree cond) {
        Block next = this.currentBlock;
        ExpressionTree elseStatement = cond.falseExpression();
        this.currentBlock = this.createBlock(next);
        this.build(elseStatement);
        Block elseBlock = this.currentBlock;
        this.currentBlock = this.createBlock(next);
        this.build(cond.trueExpression());
        Block thenBlock = this.currentBlock;
        this.currentBlock = this.createBranch(cond, thenBlock, elseBlock);
        this.buildCondition(cond.condition(), thenBlock, elseBlock);
    }

    private void buildVariable(VariableTree tree) {
        this.currentBlock.elements.add(tree);
        ExpressionTree initializer = tree.initializer();
        if (initializer != null) {
            this.build(initializer);
        }
    }

    private void buildBinaryExpression(Tree tree) {
        BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
        this.currentBlock.elements.add(tree);
        this.build(binaryExpressionTree.rightOperand());
        this.build(binaryExpressionTree.leftOperand());
    }

    private void buildAssignment(AssignmentExpressionTree tree) {
        this.currentBlock.elements.add(tree);
        this.build(tree.variable());
        this.build(tree.expression());
    }

    private void buildMemberSelect(MemberSelectExpressionTree mse) {
        this.currentBlock.elements.add(mse);
        if (!"class".equals(mse.identifier().name())) {
            this.build(mse.expression());
        }
    }

    private void buildConditionalAnd(BinaryExpressionTree tree) {
        Block falseBlock = this.currentBlock;
        this.currentBlock = this.createBlock(falseBlock);
        this.build(tree.rightOperand());
        this.buildConditionalBinaryLHS(tree, this.currentBlock, falseBlock);
    }

    private void buildConditionalOr(BinaryExpressionTree tree) {
        Block trueBlock = this.currentBlock;
        this.currentBlock = this.createBlock(trueBlock);
        this.build(tree.rightOperand());
        this.buildConditionalBinaryLHS(tree, trueBlock, this.currentBlock);
    }

    private void buildConditionalBinaryLHS(BinaryExpressionTree tree, Block trueBlock, Block falseBlock) {
        Block toComplete = this.currentBlock = this.createBlock();
        this.build(tree.leftOperand());
        toComplete.terminator = tree;
        toComplete.addFalseSuccessor(falseBlock);
        toComplete.addTrueSuccessor(trueBlock);
    }

    private void buildLabeledStatement(LabeledStatementTree labeledStatement) {
        String name = labeledStatement.label().name();
        this.labelsBreakTarget.put(name, this.currentBlock);
        this.pendingLabel = name;
        this.build(labeledStatement.statement());
        this.currentBlock = this.createBlock(this.currentBlock);
    }

    private void buildSwitchStatement(SwitchStatementTree switchStatementTree) {
        Block switchSuccessor = this.currentBlock;
        this.currentBlock = this.createBlock();
        this.currentBlock.terminator = switchStatementTree;
        this.switches.addLast(this.currentBlock);
        this.build(switchStatementTree.expression());
        this.currentBlock = this.createBlock(switchSuccessor);
        this.breakTargets.addLast(switchSuccessor);
        boolean hasDefaultCase = false;
        if (!switchStatementTree.cases().isEmpty()) {
            CaseGroupTree firstCase = switchStatementTree.cases().get(0);
            for (CaseGroupTree caseGroupTree : Lists.reverse(switchStatementTree.cases())) {
                this.build(caseGroupTree.body());
                if (!hasDefaultCase) {
                    hasDefaultCase = CFG.containsDefaultCase(caseGroupTree.labels());
                }
                this.switches.getLast().addSuccessor(this.currentBlock);
                if (caseGroupTree.equals(firstCase)) continue;
                this.currentBlock = this.createBlock(this.currentBlock);
            }
        }
        this.breakTargets.removeLast();
        this.currentBlock = this.switches.removeLast();
        if (!hasDefaultCase) {
            this.currentBlock.addSuccessor(switchSuccessor);
        }
    }

    private static boolean containsDefaultCase(List<CaseLabelTree> labels) {
        for (CaseLabelTree caseLabel : labels) {
            if (!"default".equals(caseLabel.caseOrDefaultKeyword().text())) continue;
            return true;
        }
        return false;
    }

    private void buildBreakStatement(BreakStatementTree tree) {
        Block targetBlock;
        IdentifierTree label = tree.label();
        if (label == null) {
            if (this.breakTargets.isEmpty()) {
                throw new IllegalStateException("'break' statement not in loop or switch statement");
            }
            targetBlock = this.breakTargets.getLast();
        } else {
            targetBlock = this.labelsBreakTarget.get(label.name());
        }
        this.currentBlock = this.createUnconditionalJump(tree, targetBlock);
    }

    private void buildContinueStatement(ContinueStatementTree tree) {
        Block targetBlock;
        IdentifierTree label = tree.label();
        if (label == null) {
            if (this.continueTargets.isEmpty()) {
                throw new IllegalStateException("'continue' statement not in loop or switch statement");
            }
            targetBlock = this.continueTargets.getLast();
        } else {
            targetBlock = this.labelsContinueTarget.get(label.name());
        }
        this.currentBlock = this.createUnconditionalJump(tree, targetBlock);
    }

    private void buildWhileStatement(WhileStatementTree whileStatement) {
        Block falseBranch = this.currentBlock;
        Block loopback = this.createBlock();
        this.currentBlock = this.createBlock(loopback);
        this.addContinueTarget(loopback);
        this.breakTargets.addLast(falseBranch);
        this.build(whileStatement.statement());
        this.breakTargets.removeLast();
        this.continueTargets.removeLast();
        Block bodyBlock = this.currentBlock;
        this.currentBlock = this.createBranch(whileStatement, bodyBlock, falseBranch);
        this.buildCondition(whileStatement.condition(), bodyBlock, falseBranch);
        loopback.addSuccessor(this.currentBlock);
        this.currentBlock = this.createBlock(this.currentBlock);
    }

    private void buildDoWhileStatement(DoWhileStatementTree doWhileStatementTree) {
        Block falseBranch = this.currentBlock;
        Block loopback = this.createBlock();
        this.currentBlock = this.createBranch(doWhileStatementTree, loopback, falseBranch);
        this.buildCondition(doWhileStatementTree.condition(), loopback, falseBranch);
        this.currentBlock = this.createBlock(this.currentBlock);
        this.addContinueTarget(loopback);
        this.breakTargets.addLast(falseBranch);
        this.build(doWhileStatementTree.statement());
        this.breakTargets.removeLast();
        this.continueTargets.removeLast();
        loopback.addSuccessor(this.currentBlock);
        this.currentBlock = this.createBlock(this.currentBlock);
    }

    private void buildForEachStatement(ForEachStatement tree) {
        Block afterLoop = this.currentBlock;
        Block statementBlock = this.createBlock();
        Block loopback = this.createBranch(tree, statementBlock, afterLoop);
        this.currentBlock = this.createBlock(loopback);
        this.addContinueTarget(loopback);
        this.breakTargets.addLast(afterLoop);
        this.build(tree.statement());
        this.breakTargets.removeLast();
        this.continueTargets.removeLast();
        statementBlock.addSuccessor(this.currentBlock);
        this.currentBlock = loopback;
        this.build(tree.variable());
        this.currentBlock = this.createBlock(this.currentBlock);
        this.build(tree.expression());
        this.currentBlock = this.createBlock(this.currentBlock);
    }

    private void addContinueTarget(Block target) {
        this.continueTargets.addLast(target);
        if (this.pendingLabel != null) {
            this.labelsContinueTarget.put(this.pendingLabel, target);
            this.pendingLabel = null;
        }
    }

    private void buildForStatement(ForStatementTree tree) {
        Block falseBranch = this.currentBlock;
        Block updateBlock = this.currentBlock = this.createBlock();
        for (StatementTree updateTree : Lists.reverse(tree.update())) {
            this.build(updateTree);
        }
        this.addContinueTarget(this.currentBlock);
        this.currentBlock = this.createBlock(this.currentBlock);
        this.breakTargets.addLast(falseBranch);
        this.build(tree.statement());
        this.breakTargets.removeLast();
        this.continueTargets.removeLast();
        Block body = this.currentBlock;
        ExpressionTree condition = tree.condition();
        if (condition != null) {
            this.currentBlock = this.createBranch(tree, body, falseBranch);
            this.buildCondition(condition, body, falseBranch);
        } else {
            this.currentBlock = this.createUnconditionalJump(tree, body);
        }
        updateBlock.addSuccessor(this.currentBlock);
        this.currentBlock = this.createBlock(this.currentBlock);
        for (StatementTree init : Lists.reverse(tree.initializer())) {
            this.build(init);
        }
    }

    private void buildTryStatement(TryStatementTree tryStatementTree) {
        this.currentBlock = this.createBlock(this.currentBlock);
        BlockTree finallyBlockTree = tryStatementTree.finallyBlock();
        if (finallyBlockTree != null) {
            this.currentBlock.isFinallyBlock = true;
            this.build(finallyBlockTree);
            this.currentBlock.addExitSuccessor(this.exitBlock());
            this.exitBlocks.push(this.currentBlock);
        }
        Block finallyOrEndBlock = this.currentBlock;
        Block beforeFinally = this.createBlock(this.currentBlock);
        ArrayList<Block> catches = new ArrayList<Block>();
        for (CatchTree catchTree : tryStatementTree.catches()) {
            this.currentBlock = this.createBlock(finallyOrEndBlock);
            this.build(catchTree.block());
            catches.add(this.currentBlock);
        }
        this.currentBlock = beforeFinally;
        this.build(tryStatementTree.block());
        for (Block catchBlock : catches) {
            this.currentBlock.addSuccessor(catchBlock);
        }
        this.build((List<? extends Tree>)tryStatementTree.resources());
        this.currentBlock = this.createBlock(this.currentBlock);
        this.currentBlock.elements.add(tryStatementTree);
        if (finallyBlockTree != null) {
            this.exitBlocks.pop();
            if (catches.isEmpty()) {
                this.currentBlock.addExitSuccessor(finallyOrEndBlock);
            }
        }
        for (Block catchBlock : catches) {
            this.currentBlock.addSuccessor(catchBlock);
        }
    }

    private void buildThrowStatement(ThrowStatementTree throwStatementTree) {
        this.currentBlock = this.createUnconditionalJump(throwStatementTree, this.exitBlock());
        this.build(throwStatementTree.expression());
    }

    private void buildSynchronizedStatement(SynchronizedStatementTree sst) {
        this.build(sst.block());
        this.currentBlock = this.createUnconditionalJump(sst, this.currentBlock);
        this.build(sst.expression());
    }

    private void buildUnaryExpression(UnaryExpressionTree tree) {
        this.currentBlock.elements.add(tree);
        this.build(tree.expression());
    }

    private void buildArrayAccessExpression(ArrayAccessExpressionTree tree) {
        this.currentBlock.elements.add(tree);
        this.build(tree.expression());
        this.build(tree.dimension());
    }

    private void buildArrayDimension(ArrayDimensionTree tree) {
        ExpressionTree expression = tree.expression();
        if (expression != null) {
            this.build(expression);
        }
    }

    private void buildNewClass(NewClassTree tree) {
        this.currentBlock.elements.add(tree);
        ExpressionTree enclosingExpression = tree.enclosingExpression();
        if (enclosingExpression != null) {
            this.build(enclosingExpression);
        }
        this.build(Lists.reverse((List)tree.arguments()));
    }

    private void buildTypeCast(Tree tree) {
        this.currentBlock.elements.add(tree);
        TypeCastTree typeCastTree = (TypeCastTree)tree;
        this.build(typeCastTree.expression());
    }

    private void buildInstanceOf(InstanceOfTree instanceOfTree) {
        this.currentBlock.elements.add(instanceOfTree);
        this.build(instanceOfTree.expression());
    }

    private void buildNewArray(NewArrayTree tree) {
        this.currentBlock.elements.add(tree);
        this.build(Lists.reverse(tree.dimensions()));
        this.build(Lists.reverse(tree.initializers()));
    }

    private Block createUnconditionalJump(Tree terminator, @Nullable Block target) {
        Block result = this.createBlock();
        result.terminator = terminator;
        if (target != null) {
            if (target == this.exitBlock()) {
                result.addExitSuccessor(target);
            } else {
                result.addSuccessor(target);
            }
        }
        return result;
    }

    private void buildCondition(Tree syntaxNode, Block trueBlock, Block falseBlock) {
        switch (syntaxNode.kind()) {
            case CONDITIONAL_OR: {
                this.buildConditionalOr((BinaryExpressionTree)syntaxNode, trueBlock, falseBlock);
                break;
            }
            case CONDITIONAL_AND: {
                this.buildConditionalAnd((BinaryExpressionTree)syntaxNode, trueBlock, falseBlock);
                break;
            }
            case PARENTHESIZED_EXPRESSION: {
                this.buildCondition(((ParenthesizedTree)syntaxNode).expression(), trueBlock, falseBlock);
                break;
            }
            default: {
                this.build(syntaxNode);
            }
        }
    }

    private void buildConditionalOr(BinaryExpressionTree conditionalOr, Block trueBlock, Block falseBlock) {
        this.buildCondition(conditionalOr.rightOperand(), trueBlock, falseBlock);
        Block newFalseBlock = this.currentBlock;
        this.currentBlock = this.createBranch(conditionalOr, trueBlock, newFalseBlock);
        this.buildCondition(conditionalOr.leftOperand(), trueBlock, newFalseBlock);
    }

    private void buildConditionalAnd(BinaryExpressionTree conditionalAnd, Block trueBlock, Block falseBlock) {
        this.buildCondition(conditionalAnd.rightOperand(), trueBlock, falseBlock);
        Block newTrueBlock = this.currentBlock;
        this.currentBlock = this.createBranch(conditionalAnd, newTrueBlock, falseBlock);
        this.buildCondition(conditionalAnd.leftOperand(), newTrueBlock, falseBlock);
    }

    private Block createBranch(Tree terminator, Block trueBranch, Block falseBranch) {
        Block result = this.createBlock();
        result.terminator = terminator;
        result.addFalseSuccessor(falseBranch);
        result.addTrueSuccessor(trueBranch);
        return result;
    }

    public static class Block {
        private int id;
        private final List<Tree> elements = new ArrayList<Tree>();
        private final Set<Block> successors = new HashSet<Block>();
        private final Set<Block> predecessors = new HashSet<Block>();
        private Block trueBlock;
        private Block falseBlock;
        private Block exitBlock;
        private Tree terminator;
        private boolean isFinallyBlock;

        public Block(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public List<Tree> elements() {
            return Lists.reverse(this.elements);
        }

        public Block trueBlock() {
            return this.trueBlock;
        }

        public Block falseBlock() {
            return this.falseBlock;
        }

        public Block exitBlock() {
            return this.exitBlock;
        }

        public boolean isFinallyBlock() {
            return this.isFinallyBlock;
        }

        void addSuccessor(Block successor) {
            this.successors.add(successor);
        }

        public void addTrueSuccessor(Block successor) {
            if (this.trueBlock != null) {
                throw new IllegalStateException("Attempt to re-assign a true successor");
            }
            this.successors.add(successor);
            this.trueBlock = successor;
        }

        public void addFalseSuccessor(Block successor) {
            if (this.falseBlock != null) {
                throw new IllegalStateException("Attempt to re-assign a false successor");
            }
            this.successors.add(successor);
            this.falseBlock = successor;
        }

        public void addExitSuccessor(Block block) {
            this.successors.add(block);
            this.exitBlock = block;
        }

        public Set<Block> predecessors() {
            return this.predecessors;
        }

        public Set<Block> successors() {
            return this.successors;
        }

        @CheckForNull
        public Tree terminator() {
            return this.terminator;
        }

        public boolean isInactive() {
            return this.terminator == null && this.elements.isEmpty() && this.successors.size() == 1;
        }

        private void prune(Block inactiveBlock) {
            if (inactiveBlock.equals(this.trueBlock)) {
                if (inactiveBlock.successors.size() != 1) {
                    throw new IllegalStateException("True successor must be replaced by a unique successor!");
                }
                this.trueBlock = inactiveBlock.successors.iterator().next();
            }
            if (inactiveBlock.equals(this.falseBlock)) {
                if (inactiveBlock.successors.size() != 1) {
                    throw new IllegalStateException("False successor must be replaced by a unique successor!");
                }
                this.falseBlock = inactiveBlock.successors.iterator().next();
            }
            if (this.successors.remove(inactiveBlock)) {
                this.successors.addAll(inactiveBlock.successors);
            }
        }
    }
}

