/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class LabeledStatementTreeImpl
extends JavaTree
implements LabeledStatementTree {
    private final IdentifierTree label;
    private final InternalSyntaxToken colonToken;
    private final StatementTree statement;
    private Symbol.LabelSymbol symbol;

    public LabeledStatementTreeImpl(IdentifierTree label, InternalSyntaxToken colonToken, StatementTree statement) {
        super(Tree.Kind.LABELED_STATEMENT);
        this.label = (IdentifierTree)Preconditions.checkNotNull((Object)label);
        this.colonToken = colonToken;
        this.statement = (StatementTree)Preconditions.checkNotNull((Object)statement);
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.LABELED_STATEMENT;
    }

    @Override
    public IdentifierTree label() {
        return this.label;
    }

    @Override
    public SyntaxToken colonToken() {
        return this.colonToken;
    }

    @Override
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    public Symbol.LabelSymbol symbol() {
        return this.symbol;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitLabeledStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.label, this.colonToken, this.statement});
    }

    public void setSymbol(JavaSymbol.JavaLabelSymbol symbol) {
        this.symbol = symbol;
    }
}

