/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.java.resolve.BytecodeCompleter;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.java.resolve.Types;
import org.sonar.plugins.java.api.semantic.Type;

public class Resolve {
    private final JavaSymbolNotFound symbolNotFound = new JavaSymbolNotFound();
    private final BytecodeCompleter bytecodeCompleter;
    private final ParametrizedTypeCache parametrizedTypeCache;
    private final Types types = new Types();
    private final Symbols symbols;

    public Resolve(Symbols symbols, BytecodeCompleter bytecodeCompleter, ParametrizedTypeCache parametrizedTypeCache) {
        this.symbols = symbols;
        this.bytecodeCompleter = bytecodeCompleter;
        this.parametrizedTypeCache = parametrizedTypeCache;
    }

    @Nullable
    private static JavaSymbol.TypeJavaSymbol superclassSymbol(JavaSymbol.TypeJavaSymbol c) {
        JavaType supertype = c.getSuperclass();
        return supertype == null ? null : supertype.symbol;
    }

    public JavaSymbol.TypeJavaSymbol registerClass(JavaSymbol.TypeJavaSymbol classSymbol) {
        return this.bytecodeCompleter.registerClass(classSymbol);
    }

    public Scope createStarImportScope(JavaSymbol owner) {
        return new Scope.StarImportScope(owner, this.bytecodeCompleter);
    }

    public Scope createStaticStarImportScope(JavaSymbol owner) {
        return new Scope.StaticStarImportScope(owner, this.bytecodeCompleter);
    }

    public JavaType resolveTypeSubstitution(JavaType type, JavaType definition) {
        if (definition instanceof JavaType.ParametrizedTypeJavaType) {
            return this.substituteTypeParameter(type, ((JavaType.ParametrizedTypeJavaType)definition).typeSubstitution);
        }
        return type;
    }

    private JavaType substituteTypeParameter(JavaType type, TypeSubstitution substitution) {
        JavaType substitutedType = substitution.substitutedType(type);
        if (substitutedType != null) {
            return substitutedType;
        }
        if (type instanceof JavaType.ParametrizedTypeJavaType) {
            JavaType.ParametrizedTypeJavaType ptt = (JavaType.ParametrizedTypeJavaType)type;
            TypeSubstitution newSubstitution = new TypeSubstitution();
            for (Map.Entry<JavaType.TypeVariableJavaType, JavaType> entry : ptt.typeSubstitution.substitutionEntries()) {
                newSubstitution.add(entry.getKey(), this.substituteTypeParameter(entry.getValue(), substitution));
            }
            return this.parametrizedTypeCache.getParametrizedTypeType(ptt.rawType.getSymbol(), newSubstitution);
        }
        return type;
    }

    private Resolution findField(Env env, JavaSymbol.TypeJavaSymbol site, String name, JavaSymbol.TypeJavaSymbol c) {
        Resolution bestSoFar = this.unresolved();
        Resolution resolution = new Resolution();
        for (JavaSymbol symbol : c.members().lookup(name)) {
            if (symbol.kind != 4) continue;
            if (Resolve.isAccessible(env, site, symbol)) {
                resolution.symbol = symbol;
                resolution.type = this.resolveTypeSubstitution(symbol.type, c.type);
                return resolution;
            }
            return Resolution.resolution(new AccessErrorJavaSymbol(symbol, Symbols.unknownType));
        }
        if (c.getSuperclass() != null) {
            resolution = this.findField(env, site, name, c.getSuperclass().symbol);
            if (((Resolution)resolution).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                resolution.type = this.resolveTypeSubstitution(((Resolution)resolution).symbol.type, c.getSuperclass());
                bestSoFar = resolution;
            }
        }
        for (JavaType interfaceType : c.getInterfaces()) {
            resolution = this.findField(env, site, name, interfaceType.symbol);
            if (((Resolution)resolution).symbol.kind >= ((Resolution)bestSoFar).symbol.kind) continue;
            bestSoFar = resolution;
        }
        return bestSoFar;
    }

    private Resolution findVar(Env env, String name) {
        Resolution bestSoFar = this.unresolved();
        Env env1 = env;
        while (env1.outer != null) {
            Resolution sym = new Resolution();
            for (JavaSymbol symbol : env1.scope.lookup(name)) {
                if (symbol.kind != 4) continue;
                sym.symbol = symbol;
            }
            if (sym.symbol == null) {
                sym = this.findField(env1, env1.enclosingClass, name, env1.enclosingClass);
            }
            if (((Resolution)sym).symbol.kind < 64) {
                return sym;
            }
            if (((Resolution)sym).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = sym;
            }
            env1 = env1.outer;
        }
        JavaSymbol symbol = this.findInStaticImport(env, name, 4);
        if (symbol.kind < 64) {
            return Resolution.resolution(symbol);
        }
        if (symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
            bestSoFar = Resolution.resolution(symbol);
        }
        return bestSoFar;
    }

    private JavaSymbol findInStaticImport(Env env, String name, int kind) {
        JavaSymbolNotFound bestSoFar = this.symbolNotFound;
        for (JavaSymbol symbol : env.namedImports.lookup(name)) {
            if ((kind & symbol.kind) == 0) continue;
            return symbol;
        }
        for (JavaSymbol symbol : env.staticStarImports.lookup(name)) {
            if ((kind & symbol.kind) == 0) continue;
            return symbol;
        }
        return bestSoFar;
    }

    private JavaSymbol findMemberType(Env env, JavaSymbol.TypeJavaSymbol site, String name, JavaSymbol.TypeJavaSymbol c) {
        JavaSymbol bestSoFar = this.symbolNotFound;
        for (JavaSymbol symbol : c.members().lookup(name)) {
            if (symbol.kind != 2) continue;
            return Resolve.isAccessible(env, site, symbol) ? symbol : new AccessErrorJavaSymbol(symbol, Symbols.unknownType);
        }
        if (c.getSuperclass() != null) {
            JavaSymbol symbol = this.findMemberType(env, site, name, c.getSuperclass().symbol);
            if (symbol.kind < bestSoFar.kind) {
                bestSoFar = symbol;
            }
        }
        if (c.getInterfaces() == null) {
            Preconditions.checkState((boolean)c.completing, (Object)"interfaces of a symbol not currently completing are not set.");
            Preconditions.checkState((c == site ? 1 : 0) != 0);
        } else {
            for (JavaType interfaceType : c.getInterfaces()) {
                JavaSymbol symbol = this.findMemberType(env, site, name, interfaceType.symbol);
                if (symbol.kind >= bestSoFar.kind) continue;
                bestSoFar = symbol;
            }
        }
        return bestSoFar;
    }

    private JavaSymbol findType(Env env, String name) {
        JavaSymbol bestSoFar = this.symbolNotFound;
        Env env1 = env;
        while (env1 != null) {
            for (JavaSymbol symbol : env1.scope.lookup(name)) {
                if (symbol.kind != 2) continue;
                return symbol;
            }
            if (env1.outer != null) {
                JavaSymbol symbol = this.findMemberType(env1, env1.enclosingClass, name, env1.enclosingClass);
                if (symbol.kind < 64) {
                    return symbol;
                }
                if (symbol.kind < bestSoFar.kind) {
                    bestSoFar = symbol;
                }
            }
            env1 = env1.outer;
        }
        JavaSymbol predefinedSymbol = this.findMemberType(env, this.symbols.predefClass, name, this.symbols.predefClass);
        if (predefinedSymbol.kind < bestSoFar.kind) {
            return predefinedSymbol;
        }
        for (JavaSymbol symbol : env.namedImports.lookup(name)) {
            if (symbol.kind != 2) continue;
            return symbol;
        }
        JavaSymbol sym = this.findIdentInPackage(env.packge, name, 2);
        if (sym.kind < bestSoFar.kind) {
            return sym;
        }
        for (JavaSymbol symbol : env.starImports.lookup(name)) {
            if (symbol.kind != 2) continue;
            return symbol;
        }
        JavaSymbol.PackageJavaSymbol javaLang = this.bytecodeCompleter.enterPackage("java.lang");
        for (JavaSymbol symbol : javaLang.completedMembers().lookup(name)) {
            if (symbol.kind != 2) continue;
            return symbol;
        }
        return bestSoFar;
    }

    public Resolution findIdent(Env env, String name, int kind) {
        Resolution res;
        Resolution bestSoFar = this.unresolved();
        if ((kind & 4) != 0) {
            res = this.findVar(env, name);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
        }
        if ((kind & 2) != 0) {
            res = new Resolution();
            res.symbol = this.findType(env, name);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
        }
        if ((kind & 1) != 0) {
            res = new Resolution();
            res.symbol = this.findIdentInPackage(this.symbols.defaultPackage, name, 1);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
        }
        return bestSoFar;
    }

    public JavaSymbol findIdentInPackage(JavaSymbol site, String name, int kind) {
        String fullname = this.bytecodeCompleter.formFullName(name, site);
        JavaSymbol bestSoFar = this.symbolNotFound;
        if ((kind & 2) != 0) {
            JavaSymbol sym = this.bytecodeCompleter.loadClass(fullname);
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 1) != 0 && bestSoFar.kind >= this.symbolNotFound.kind) {
            bestSoFar = this.bytecodeCompleter.enterPackage(fullname);
        }
        return bestSoFar;
    }

    public Resolution findIdentInType(Env env, JavaSymbol.TypeJavaSymbol site, String name, int kind) {
        Resolution bestSoFar = this.unresolved();
        if ((kind & 4) != 0) {
            Resolution resolution = this.findField(env, site, name, site);
            if (((Resolution)resolution).symbol.kind < 64) {
                return resolution;
            }
            if (((Resolution)resolution).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = resolution;
            }
        }
        if ((kind & 2) != 0) {
            JavaSymbol symbol = this.findMemberType(env, site, name, site);
            if (symbol.kind < 64) {
                return Resolution.resolution(symbol);
            }
            if (symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = Resolution.resolution(symbol);
            }
        }
        return bestSoFar;
    }

    public Resolution findMethod(Env env, String name, List<JavaType> argTypes, List<JavaType> typeParamTypes) {
        Resolution bestSoFar = this.unresolved();
        Env env1 = env;
        while (env1.outer != null) {
            Resolution res = this.findMethod(env1, env1.enclosingClass.getType(), name, argTypes, typeParamTypes);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
            env1 = env1.outer;
        }
        JavaSymbol sym = this.findInStaticImport(env, name, 16);
        if (sym.kind < 64) {
            return Resolution.resolution(sym);
        }
        if (sym.kind < ((Resolution)bestSoFar).symbol.kind) {
            bestSoFar = Resolution.resolution(sym);
        }
        return bestSoFar;
    }

    public Resolution findMethod(Env env, JavaType site, String name, List<JavaType> argTypes) {
        return this.findMethod(env, site, site, name, argTypes, (List<JavaType>)ImmutableList.of(), false);
    }

    public Resolution findMethod(Env env, JavaType site, String name, List<JavaType> argTypes, List<JavaType> typeParams) {
        return this.findMethod(env, site, site, name, argTypes, typeParams, false);
    }

    private Resolution findMethod(Env env, JavaType callSite, JavaType site, String name, List<JavaType> argTypes, List<JavaType> typeParams) {
        return this.findMethod(env, callSite, site, name, argTypes, typeParams, false);
    }

    private Resolution findConstructor(Env env, JavaType site, List<JavaType> argTypes, List<JavaType> typeParams, boolean autoboxing) {
        return this.findMethod(env, site, site, "<init>", argTypes, typeParams, autoboxing);
    }

    private Resolution findMethod(Env env, JavaType callSite, JavaType site, String name, List<JavaType> argTypes, List<JavaType> typeParams, boolean autoboxing) {
        JavaType superclass = site.getSymbol().getSuperclass();
        Resolution bestSoFar = this.unresolved();
        if ("this".equals(name)) {
            return this.findConstructor(env, site, argTypes, typeParams, autoboxing);
        }
        if ("super".equals(name)) {
            if (superclass == null) {
                return bestSoFar;
            }
            return this.findConstructor(env, superclass, argTypes, typeParams, autoboxing);
        }
        for (JavaSymbol symbol : site.getSymbol().members().lookup(name)) {
            JavaSymbol best;
            if (symbol.kind != 16 || (best = this.selectBest(env, callSite.symbol, argTypes, symbol, bestSoFar.symbol, autoboxing)) != symbol) continue;
            bestSoFar = Resolution.resolution(best);
            bestSoFar.type = this.resolveTypeSubstitution(((JavaType.MethodJavaType)best.type).resultType, site);
            JavaSymbol.MethodJavaSymbol methodSymbol = (JavaSymbol.MethodJavaSymbol)best;
            bestSoFar.type = this.handleTypeArguments(typeParams, bestSoFar.type, methodSymbol);
        }
        if (superclass != null) {
            Resolution method = this.findMethod(env, callSite, superclass, name, argTypes, typeParams);
            method.type = this.resolveTypeSubstitution(this.resolveTypeSubstitution(method.type, superclass), site);
            JavaSymbol best = this.selectBest(env, callSite.symbol, argTypes, method.symbol, bestSoFar.symbol, autoboxing);
            if (best == method.symbol) {
                bestSoFar = method;
            }
        }
        for (JavaType interfaceType : site.getSymbol().getInterfaces()) {
            Resolution method = this.findMethod(env, callSite, interfaceType, name, argTypes, typeParams);
            method.type = this.resolveTypeSubstitution(this.resolveTypeSubstitution(method.type, interfaceType), site);
            JavaSymbol best = this.selectBest(env, callSite.symbol, argTypes, method.symbol, bestSoFar.symbol, autoboxing);
            if (best != method.symbol) continue;
            bestSoFar = method;
        }
        if (((Resolution)bestSoFar).symbol.kind >= 64 && !autoboxing) {
            bestSoFar = this.findMethod(env, callSite, site, name, argTypes, typeParams, true);
        }
        return bestSoFar;
    }

    private JavaType handleTypeArguments(List<JavaType> typeParams, JavaType type, JavaSymbol.MethodJavaSymbol methodSymbol) {
        if (!typeParams.isEmpty() && methodSymbol.typeVariableTypes.size() == typeParams.size()) {
            TypeSubstitution typeSubstitution = new TypeSubstitution();
            int i = 0;
            for (JavaType.TypeVariableJavaType typeVariableType : methodSymbol.typeVariableTypes) {
                typeSubstitution.add(typeVariableType, typeParams.get(i));
                ++i;
            }
            return this.substituteTypeParameter(type, typeSubstitution);
        }
        return type;
    }

    private JavaSymbol selectBest(Env env, JavaSymbol.TypeJavaSymbol site, List<JavaType> argTypes, JavaSymbol candidate, JavaSymbol bestSoFar, boolean autoboxing) {
        if (candidate.kind >= 64 || !Resolve.isInheritedIn(candidate, site) || candidate.type == null) {
            return bestSoFar;
        }
        boolean isVarArgs = ((JavaSymbol.MethodJavaSymbol)candidate).isVarArgs();
        if (!this.isArgumentsAcceptable(argTypes, ((JavaType.MethodJavaType)candidate.type).argTypes, isVarArgs, autoboxing)) {
            return bestSoFar;
        }
        if (!Resolve.isAccessible(env, site, candidate)) {
            return new AccessErrorJavaSymbol(candidate, Symbols.unknownType);
        }
        JavaSymbol mostSpecific = this.selectMostSpecific(candidate, bestSoFar);
        if (mostSpecific.isKind(65)) {
            mostSpecific = bestSoFar;
        }
        return mostSpecific;
    }

    private boolean isArgumentsAcceptable(List<JavaType> argTypes, List<JavaType> formals, boolean isVarArgs, boolean autoboxing) {
        int i;
        int argsSize = argTypes.size();
        int formalsSize = formals.size();
        int nbArgToCheck = argsSize - formalsSize;
        if (isVarArgs ? ++nbArgToCheck < 0 : nbArgToCheck != 0) {
            return false;
        }
        for (i = 1; i <= nbArgToCheck; ++i) {
            JavaType.ArrayJavaType lastFormal = (JavaType.ArrayJavaType)formals.get(formalsSize - 1);
            JavaType argType = argTypes.get(argsSize - i);
            if (this.isAcceptableType(argType, lastFormal.elementType, autoboxing) || nbArgToCheck == 1 && this.types.isSubtype(argType, lastFormal)) continue;
            return false;
        }
        for (i = 0; i < argsSize - nbArgToCheck; ++i) {
            if (this.isAcceptableType(argTypes.get(i), formals.get(i), autoboxing)) continue;
            return false;
        }
        return true;
    }

    private boolean isAcceptableType(JavaType arg, JavaType formal, boolean autoboxing) {
        return this.types.isSubtype(arg.erasure(), formal.erasure()) || autoboxing && this.isAcceptableByAutoboxing(arg, formal.erasure());
    }

    private boolean isAcceptableByAutoboxing(JavaType expressionType, JavaType formalType) {
        if (expressionType.isPrimitive()) {
            return this.types.isSubtype((JavaType)this.symbols.boxedTypes.get((Object)expressionType), formalType);
        }
        JavaType unboxedType = (JavaType)this.symbols.boxedTypes.inverse().get((Object)expressionType);
        if (unboxedType != null) {
            return this.types.isSubtype(unboxedType, formalType);
        }
        return false;
    }

    private JavaSymbol selectMostSpecific(JavaSymbol m1, JavaSymbol m2) {
        if (m2.type == null || !m2.isKind(16)) {
            return m1;
        }
        boolean m1SignatureMoreSpecific = this.isSignatureMoreSpecific(m1, m2);
        boolean m2SignatureMoreSpecific = this.isSignatureMoreSpecific(m2, m1);
        if (m1SignatureMoreSpecific && m2SignatureMoreSpecific) {
            return new AmbiguityErrorJavaSymbol();
        }
        if (m1SignatureMoreSpecific) {
            return m1;
        }
        if (m2SignatureMoreSpecific) {
            return m2;
        }
        return new AmbiguityErrorJavaSymbol();
    }

    private boolean isSignatureMoreSpecific(JavaSymbol m1, JavaSymbol m2) {
        List<JavaType> m1ArgTypes = ((JavaType.MethodJavaType)m1.type).argTypes;
        List<JavaType> m2ArgTypes = ((JavaType.MethodJavaType)m2.type).argTypes;
        if (((JavaSymbol.MethodJavaSymbol)m1).isVarArgs()) {
            m1ArgTypes = Resolve.expandVarArgsToFitSize(m1ArgTypes, m2ArgTypes.size());
        }
        return this.isArgumentsAcceptable(m1ArgTypes, m2ArgTypes, ((JavaSymbol.MethodJavaSymbol)m2).isVarArgs(), false);
    }

    private static List<JavaType> expandVarArgsToFitSize(List<JavaType> m1ArgTypes, int size) {
        ArrayList<JavaType> newArgTypes = new ArrayList<JavaType>(m1ArgTypes);
        int m1ArgTypesSize = newArgTypes.size();
        int m1ArgTypesLast = m1ArgTypesSize - 1;
        Type lastElementType = ((Type.ArrayType)newArgTypes.get(m1ArgTypesLast)).elementType();
        newArgTypes.set(m1ArgTypesLast, (JavaType)lastElementType);
        for (int i = m1ArgTypesSize; i < size - 1; ++i) {
            if (i < newArgTypes.size()) {
                newArgTypes.set(i, (JavaType)lastElementType);
                continue;
            }
            newArgTypes.add((JavaType)lastElementType);
        }
        return newArgTypes;
    }

    @VisibleForTesting
    static boolean isAccessible(Env env, JavaSymbol.TypeJavaSymbol c) {
        boolean result;
        switch (c.flags() & 7) {
            case 2: {
                result = Resolve.sameOutermostClass(env.enclosingClass, (JavaSymbol)c.owner());
                break;
            }
            case 0: {
                result = env.packge == c.packge();
                break;
            }
            case 1: {
                result = true;
                break;
            }
            case 4: {
                result = env.packge == c.packge() || Resolve.isInnerSubClass(env.enclosingClass, (JavaSymbol)c.owner());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    private static boolean isInnerSubClass(JavaSymbol.TypeJavaSymbol c, JavaSymbol base) {
        while (c != null && Resolve.isSubClass(c, base)) {
            c = ((JavaSymbol)c.owner()).enclosingClass();
        }
        return c != null;
    }

    @VisibleForTesting
    static boolean isSubClass(JavaSymbol.TypeJavaSymbol c, JavaSymbol base) {
        if (c == null) {
            return false;
        }
        if (c == base) {
            return true;
        }
        if ((base.flags() & 0x200) != 0) {
            for (JavaType interfaceType : c.getInterfaces()) {
                if (!Resolve.isSubClass(interfaceType.symbol, base)) continue;
                return true;
            }
            return Resolve.isSubClass(Resolve.superclassSymbol(c), base);
        }
        return Resolve.isSubClass(Resolve.superclassSymbol(c), base);
    }

    private static boolean isAccessible(Env env, JavaSymbol.TypeJavaSymbol site, JavaSymbol symbol) {
        switch (symbol.flags() & 7) {
            case 2: {
                return env.enclosingClass != null && Resolve.sameOutermostClass(env.enclosingClass, symbol.owner()) && Resolve.isInheritedIn(symbol, site);
            }
            case 0: {
                return env.packge == symbol.packge() && Resolve.isAccessible(env, site) && Resolve.isInheritedIn(symbol, site) && Resolve.notOverriddenIn(site, symbol);
            }
            case 1: {
                return Resolve.isAccessible(env, site) && Resolve.notOverriddenIn(site, symbol);
            }
            case 4: {
                return (env.packge == symbol.packge() || Resolve.isProtectedAccessible(symbol, env.enclosingClass, site)) && Resolve.isAccessible(env, site) && Resolve.notOverriddenIn(site, symbol);
            }
        }
        throw new IllegalStateException();
    }

    static boolean sameOutermostClass(JavaSymbol s1, JavaSymbol s2) {
        return s1.outermostClass() == s2.outermostClass();
    }

    private static boolean notOverriddenIn(JavaSymbol.TypeJavaSymbol site, JavaSymbol symbol) {
        return true;
    }

    @VisibleForTesting
    static boolean isInheritedIn(JavaSymbol symbol, JavaSymbol.TypeJavaSymbol clazz) {
        switch (symbol.flags() & 7) {
            case 1: {
                return true;
            }
            case 2: {
                return symbol.owner() == clazz;
            }
            case 4: {
                return true;
            }
            case 0: {
                JavaSymbol.PackageJavaSymbol thisPackage = symbol.packge();
                JavaSymbol.TypeJavaSymbol sup = clazz;
                while (sup != null && sup != symbol.owner()) {
                    if (sup.packge() != thisPackage) {
                        return false;
                    }
                    sup = Resolve.superclassSymbol(sup);
                }
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private static boolean isProtectedAccessible(JavaSymbol symbol, JavaSymbol.TypeJavaSymbol c, JavaSymbol.TypeJavaSymbol site) {
        return true;
    }

    Type leastUpperBound(List<Type> typeAlternatives) {
        return this.types.leastUpperBound(typeAlternatives);
    }

    Resolution unresolved() {
        Resolution resolution = new Resolution(this.symbolNotFound);
        resolution.type = Symbols.unknownType;
        return resolution;
    }

    public static class AccessErrorJavaSymbol
    extends JavaSymbol {
        JavaSymbol symbol;

        public AccessErrorJavaSymbol(JavaSymbol symbol, JavaType type) {
            super(64, 0, null, null);
            this.symbol = symbol;
            this.type = type;
        }
    }

    public static class AmbiguityErrorJavaSymbol
    extends JavaSymbol {
        public AmbiguityErrorJavaSymbol() {
            super(65, 0, null, null);
        }
    }

    public static class JavaSymbolNotFound
    extends JavaSymbol {
        public JavaSymbolNotFound() {
            super(66, 0, null, Symbols.unknownSymbol);
        }

        @Override
        public boolean isUnknown() {
            return true;
        }
    }

    static class Env {
        Env next;
        @Nullable
        Env outer;
        JavaSymbol.PackageJavaSymbol packge;
        @Nullable
        JavaSymbol.TypeJavaSymbol enclosingClass;
        Scope scope;
        Scope namedImports;
        Scope starImports;
        Scope staticStarImports;

        Env() {
        }

        public Env dup() {
            Env env = new Env();
            env.next = this;
            env.outer = this.outer;
            env.packge = this.packge;
            env.enclosingClass = this.enclosingClass;
            env.scope = this.scope;
            env.namedImports = this.namedImports;
            env.starImports = this.starImports;
            env.staticStarImports = this.staticStarImports;
            return env;
        }
    }

    static class Resolution {
        private JavaSymbol symbol;
        private JavaType type;

        private Resolution(JavaSymbol symbol) {
            this.symbol = symbol;
        }

        Resolution() {
        }

        static Resolution resolution(JavaSymbol symbol) {
            return new Resolution(symbol);
        }

        JavaSymbol symbol() {
            return this.symbol;
        }

        public JavaType type() {
            if (this.type == null) {
                if (this.symbol.isKind(16)) {
                    return ((JavaType.MethodJavaType)this.symbol.type).resultType;
                }
                if (this.symbol.isUnknown() || this.symbol.isKind(1)) {
                    return Symbols.unknownType;
                }
                return this.symbol.type;
            }
            return this.type;
        }
    }
}

