/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import java.util.List;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ConstraintManager;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.ExplodedGraphWalker;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.SymbolicValue;
import org.sonar.java.se.checks.SECheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public class CheckerDispatcher
implements CheckerContext {
    private final ExplodedGraphWalker explodedGraphWalker;
    private final JavaFileScannerContext context;
    private final List<SECheck> checks;
    private Tree syntaxNode;
    private int currentCheckerIndex = 0;
    private boolean transition = false;

    public CheckerDispatcher(ExplodedGraphWalker explodedGraphWalker, JavaFileScannerContext context, List<SECheck> checks) {
        this.explodedGraphWalker = explodedGraphWalker;
        this.context = context;
        this.checks = checks;
    }

    public boolean executeCheckPreStatement(Tree syntaxNode) {
        this.syntaxNode = syntaxNode;
        for (SECheck checker : this.checks) {
            ProgramState ps = checker.checkPreStatement(this, syntaxNode);
            if (ps == null) {
                return false;
            }
            this.explodedGraphWalker.programState = ps;
        }
        return true;
    }

    public void executeCheckPostStatement(Tree syntaxNode) {
        this.syntaxNode = syntaxNode;
        for (SECheck checker : this.checks) {
            ProgramState ps = checker.checkPostStatement(this, syntaxNode);
            if (ps == null) {
                throw new IllegalStateException("Post statement processing is not allowed to generate a sink yet!");
            }
            this.explodedGraphWalker.programState = ps;
        }
    }

    private void executePost() {
        this.transition = false;
        if (this.currentCheckerIndex >= this.checks.size()) {
            if (this.explodedGraphWalker.programPosition.i < this.explodedGraphWalker.programPosition.block.elements().size()) {
                this.explodedGraphWalker.clearStack(this.explodedGraphWalker.programPosition.block.elements().get(this.explodedGraphWalker.programPosition.i));
            }
            this.explodedGraphWalker.enqueue(new ExplodedGraph.ProgramPoint(this.explodedGraphWalker.programPosition.block, this.explodedGraphWalker.programPosition.i + 1), this.explodedGraphWalker.programState, this.explodedGraphWalker.node.exitPath);
            return;
        }
        this.explodedGraphWalker.programState = this.checks.get(this.currentCheckerIndex).checkPostStatement(this, this.syntaxNode);
        if (!this.transition) {
            this.addTransition(this.explodedGraphWalker.programState);
        }
    }

    @Override
    public ProgramState getState() {
        return this.explodedGraphWalker.programState;
    }

    @Override
    public boolean isNull(SymbolicValue val) {
        if (val == null) {
            return false;
        }
        return this.explodedGraphWalker.constraintManager.isNull(this.getState(), val);
    }

    @Override
    public void reportIssue(Tree tree, SECheck check, String message) {
        ((DefaultJavaFileScannerContext)this.context).reportSEIssue(check.getClass(), tree, message);
    }

    @Override
    public void addTransition(ProgramState state) {
        ProgramState oldState = this.explodedGraphWalker.programState;
        this.explodedGraphWalker.programState = state;
        ++this.currentCheckerIndex;
        this.executePost();
        --this.currentCheckerIndex;
        this.explodedGraphWalker.programState = oldState;
        this.transition = true;
    }

    @Override
    public Object createSink() {
        this.transition = true;
        return new Object();
    }

    public void executeCheckEndOfExecution(MethodTree tree) {
        for (SECheck checker : this.checks) {
            checker.checkEndOfExecution(this);
        }
    }

    public void executeCheckEndOfExecutionPath(MethodTree tree, ConstraintManager constraintManager) {
        for (SECheck checker : this.checks) {
            checker.checkEndOfExecutionPath(this, constraintManager);
        }
    }

    public void init() {
        for (SECheck checker : this.checks) {
            checker.init();
        }
    }

    @Override
    public ConstraintManager getConstraintManager() {
        return this.explodedGraphWalker.constraintManager;
    }
}

