/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sonar.java.se.ObjectConstraint;
import org.sonar.java.se.Pair;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.SymbolicValue;
import org.sonar.java.se.SymbolicValueFactory;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

public class ConstraintManager {
    private int counter = ProgramState.EMPTY_STATE.constraintsSize();
    private SymbolicValueFactory symbolicValueFactory;

    public void setValueFactory(SymbolicValueFactory valueFactory) {
        Preconditions.checkState((this.symbolicValueFactory == null ? 1 : 0) != 0, (Object)"The symbolic value factory has already been defined by another checker!");
        this.symbolicValueFactory = valueFactory;
    }

    public SymbolicValue createSymbolicValue(Tree syntaxNode) {
        SymbolicValue result;
        switch (syntaxNode.kind()) {
            case EQUAL_TO: {
                result = new SymbolicValue.EqualToSymbolicValue(this.counter);
                break;
            }
            case NOT_EQUAL_TO: {
                result = new SymbolicValue.NotEqualToSymbolicValue(this.counter);
                break;
            }
            case LOGICAL_COMPLEMENT: {
                result = new SymbolicValue.NotSymbolicValue(this.counter);
                break;
            }
            case AND: 
            case AND_ASSIGNMENT: {
                result = new SymbolicValue.AndSymbolicValue(this.counter);
                break;
            }
            case OR: 
            case OR_ASSIGNMENT: {
                result = new SymbolicValue.OrSymbolicValue(this.counter);
                break;
            }
            case XOR: 
            case XOR_ASSIGNMENT: {
                result = new SymbolicValue.XorSymbolicValue(this.counter);
                break;
            }
            case INSTANCE_OF: {
                result = new SymbolicValue.InstanceOfSymbolicValue(this.counter);
                break;
            }
            case MEMBER_SELECT: {
                result = this.createIdentifierSymbolicValue(((MemberSelectExpressionTree)syntaxNode).identifier());
                break;
            }
            case IDENTIFIER: {
                result = this.createIdentifierSymbolicValue((IdentifierTree)syntaxNode);
                break;
            }
            default: {
                result = this.createDefaultSymbolicValue(syntaxNode);
            }
        }
        ++this.counter;
        return result;
    }

    private SymbolicValue createIdentifierSymbolicValue(IdentifierTree identifier) {
        Type type = identifier.symbol().type();
        if (type != null && type.is("java.lang.Boolean")) {
            if ("TRUE".equals(identifier.name())) {
                return SymbolicValue.TRUE_LITERAL;
            }
            if ("FALSE".equals(identifier.name())) {
                return SymbolicValue.FALSE_LITERAL;
            }
        }
        return this.createDefaultSymbolicValue(identifier);
    }

    private SymbolicValue createDefaultSymbolicValue(Tree syntaxNode) {
        SymbolicValue result = this.symbolicValueFactory == null ? new SymbolicValue(this.counter) : this.symbolicValueFactory.createSymbolicValue(this.counter, syntaxNode);
        this.symbolicValueFactory = null;
        return result;
    }

    public SymbolicValue evalLiteral(LiteralTree syntaxNode) {
        if (syntaxNode.is(Tree.Kind.NULL_LITERAL)) {
            return SymbolicValue.NULL_LITERAL;
        }
        if (syntaxNode.is(Tree.Kind.BOOLEAN_LITERAL)) {
            boolean value = Boolean.parseBoolean(syntaxNode.value());
            if (value) {
                return SymbolicValue.TRUE_LITERAL;
            }
            return SymbolicValue.FALSE_LITERAL;
        }
        return this.createSymbolicValue(syntaxNode);
    }

    public boolean isNull(ProgramState ps, SymbolicValue val) {
        return ObjectConstraint.NULL.equals(ps.getConstraint(val));
    }

    public Pair<List<ProgramState>, List<ProgramState>> assumeDual(ProgramState programState) {
        ProgramState.Pop unstack = programState.unstackValue(1);
        SymbolicValue sv = unstack.values.get(0);
        List<ProgramState> falseConstraint = sv.setConstraint(unstack.state, BooleanConstraint.FALSE);
        List<ProgramState> trueConstraint = sv.setConstraint(unstack.state, BooleanConstraint.TRUE);
        return new Pair<List<ProgramState>, List<ProgramState>>(falseConstraint, trueConstraint);
    }

    public static class TypedConstraint {
    }

    public static enum BooleanConstraint {
        TRUE,
        FALSE;


        BooleanConstraint inverse() {
            if (TRUE == this) {
                return FALSE;
            }
            return TRUE;
        }
    }
}

