/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import javax.annotation.Nullable;
import org.sonar.plugins.java.api.tree.Tree;

public class ObjectConstraint {
    public static final ObjectConstraint NULL = new ObjectConstraint(true, false, null, null);
    public static final ObjectConstraint NOT_NULL = new ObjectConstraint(false, true, null, null);
    private final boolean isNull;
    private final boolean disposable;
    private final Tree syntaxNode;
    @Nullable
    private final Object status;

    public ObjectConstraint(Tree syntaxNode, Object status) {
        this(false, true, syntaxNode, status);
    }

    public ObjectConstraint(boolean isNull, boolean disposable, @Nullable Tree syntaxNode, @Nullable Object status) {
        this.isNull = isNull;
        this.disposable = disposable;
        this.syntaxNode = syntaxNode;
        this.status = status;
    }

    public ObjectConstraint inverse() {
        if (this.isNull) {
            return new ObjectConstraint(!this.isNull, this.disposable, this.syntaxNode, this.status);
        }
        return NULL;
    }

    public ObjectConstraint withStatus(Object newStatus) {
        return new ObjectConstraint(this.isNull, this.disposable, this.syntaxNode, newStatus);
    }

    public boolean isNull() {
        return this.isNull;
    }

    public boolean isDisposable() {
        return this.disposable;
    }

    public boolean hasStatus(@Nullable Object aState) {
        if (aState == null) {
            return this.status == null;
        }
        return aState.equals(this.status);
    }

    public Tree syntaxNode() {
        return this.syntaxNode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.isNull ? "NULL" : "NOT_NULL");
        if (this.status != null) {
            buffer.append('(');
            buffer.append(this.status);
            buffer.append(')');
        }
        return buffer.toString();
    }
}

