/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sonar.java.se.ConstraintManager;
import org.sonar.java.se.ObjectConstraint;
import org.sonar.java.se.ProgramState;

public class SymbolicValue {
    public static final SymbolicValue NULL_LITERAL = new SymbolicValue(0){

        @Override
        public String toString() {
            return super.toString() + "_NULL";
        }
    };
    public static final SymbolicValue TRUE_LITERAL = new SymbolicValue(1){

        @Override
        public String toString() {
            return super.toString() + "_TRUE";
        }
    };
    public static final SymbolicValue FALSE_LITERAL = new SymbolicValue(2){

        @Override
        public String toString() {
            return super.toString() + "_FALSE";
        }
    };
    public static final List<SymbolicValue> PROTECTED_SYMBOLIC_VALUES = ImmutableList.of((Object)NULL_LITERAL, (Object)TRUE_LITERAL, (Object)FALSE_LITERAL);
    private final int id;

    public static boolean isDisposable(SymbolicValue symbolicValue) {
        return !PROTECTED_SYMBOLIC_VALUES.contains(symbolicValue);
    }

    public SymbolicValue(int id) {
        this.id = id;
    }

    public boolean references(SymbolicValue other) {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolicValue that = (SymbolicValue)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "SV_" + this.id;
    }

    public void computedFrom(List<SymbolicValue> symbolicValues) {
    }

    public List<ProgramState> setConstraint(ProgramState programState, ObjectConstraint nullConstraint) {
        ObjectConstraint nc;
        Object data = programState.getConstraint(this);
        if (data instanceof ObjectConstraint && (nc = (ObjectConstraint)data).isNull() ^ nullConstraint.isNull()) {
            return ImmutableList.of();
        }
        if (data == null || !data.equals(nullConstraint)) {
            return ImmutableList.of((Object)programState.addConstraint(this, nullConstraint));
        }
        return ImmutableList.of((Object)programState);
    }

    public List<ProgramState> setConstraint(ProgramState programState, ConstraintManager.BooleanConstraint booleanConstraint) {
        ConstraintManager.BooleanConstraint bc;
        Object data = programState.getConstraint(this);
        if (data instanceof ConstraintManager.BooleanConstraint && !(bc = (ConstraintManager.BooleanConstraint)((Object)data)).equals((Object)booleanConstraint)) {
            return ImmutableList.of();
        }
        if ((data == null || !data.equals((Object)booleanConstraint)) && programState.canReach(this)) {
            return ImmutableList.of((Object)programState.addConstraint(this, (Object)booleanConstraint));
        }
        return ImmutableList.of((Object)programState);
    }

    public ProgramState setSingleConstraint(ProgramState programState, ObjectConstraint nullConstraint) {
        List<ProgramState> states = this.setConstraint(programState, nullConstraint);
        if (states.size() != 1) {
            throw new IllegalStateException("Only a single program state is expected at this location");
        }
        return states.get(0);
    }

    public SymbolicValue wrappedValue() {
        return this;
    }

    static class XorSymbolicValue
    extends BooleanExpressionSymbolicValue {
        public XorSymbolicValue(int id) {
            super(id);
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, ConstraintManager.BooleanConstraint booleanConstraint) {
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            if (ConstraintManager.BooleanConstraint.TRUE.equals((Object)booleanConstraint)) {
                List<ProgramState> trueFirstOp = this.leftOp.setConstraint(programState, ConstraintManager.BooleanConstraint.TRUE);
                List<ProgramState> falseFirstOp = this.leftOp.setConstraint(programState, ConstraintManager.BooleanConstraint.FALSE);
                for (ProgramState ps : trueFirstOp) {
                    states.addAll(this.rightOp.setConstraint(ps, ConstraintManager.BooleanConstraint.FALSE));
                }
                for (ProgramState ps : falseFirstOp) {
                    states.addAll(this.rightOp.setConstraint(ps, ConstraintManager.BooleanConstraint.TRUE));
                }
            } else {
                List<ProgramState> trueFirstOp = this.leftOp.setConstraint(programState, ConstraintManager.BooleanConstraint.TRUE);
                List<ProgramState> falseFirstOp = this.leftOp.setConstraint(programState, ConstraintManager.BooleanConstraint.FALSE);
                for (ProgramState ps : trueFirstOp) {
                    states.addAll(this.rightOp.setConstraint(ps, ConstraintManager.BooleanConstraint.TRUE));
                }
                for (ProgramState ps : falseFirstOp) {
                    states.addAll(this.rightOp.setConstraint(ps, ConstraintManager.BooleanConstraint.FALSE));
                }
            }
            return states;
        }

        @Override
        public String toString() {
            return this.leftOp + " ^ " + this.rightOp;
        }
    }

    static class OrSymbolicValue
    extends BooleanExpressionSymbolicValue {
        public OrSymbolicValue(int id) {
            super(id);
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, ConstraintManager.BooleanConstraint booleanConstraint) {
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            if (ConstraintManager.BooleanConstraint.TRUE.equals((Object)booleanConstraint)) {
                List<ProgramState> trueFirstOp = this.leftOp.setConstraint(programState, ConstraintManager.BooleanConstraint.TRUE);
                List<ProgramState> falseFirstOp = this.leftOp.setConstraint(programState, ConstraintManager.BooleanConstraint.FALSE);
                for (ProgramState ps : trueFirstOp) {
                    states.addAll(this.rightOp.setConstraint(ps, ConstraintManager.BooleanConstraint.TRUE));
                    states.addAll(this.rightOp.setConstraint(ps, ConstraintManager.BooleanConstraint.FALSE));
                }
                for (ProgramState ps : falseFirstOp) {
                    states.addAll(this.rightOp.setConstraint(ps, ConstraintManager.BooleanConstraint.TRUE));
                }
            } else {
                List<ProgramState> falseFirstOp = this.leftOp.setConstraint(programState, ConstraintManager.BooleanConstraint.FALSE);
                for (ProgramState ps : falseFirstOp) {
                    states.addAll(this.rightOp.setConstraint(ps, ConstraintManager.BooleanConstraint.FALSE));
                }
            }
            return states;
        }

        @Override
        public String toString() {
            return this.leftOp + " | " + this.rightOp;
        }
    }

    static class AndSymbolicValue
    extends BooleanExpressionSymbolicValue {
        public AndSymbolicValue(int id) {
            super(id);
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, ConstraintManager.BooleanConstraint booleanConstraint) {
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            if (ConstraintManager.BooleanConstraint.TRUE.equals((Object)booleanConstraint)) {
                List<ProgramState> trueFirstOp = this.leftOp.setConstraint(programState, ConstraintManager.BooleanConstraint.TRUE);
                for (ProgramState ps : trueFirstOp) {
                    states.addAll(this.rightOp.setConstraint(ps, ConstraintManager.BooleanConstraint.TRUE));
                }
            } else {
                List<ProgramState> falseFirstOp = this.leftOp.setConstraint(programState, ConstraintManager.BooleanConstraint.FALSE);
                List<ProgramState> trueFirstOp = this.leftOp.setConstraint(programState, ConstraintManager.BooleanConstraint.TRUE);
                for (ProgramState ps : falseFirstOp) {
                    states.addAll(this.rightOp.setConstraint(ps, ConstraintManager.BooleanConstraint.TRUE));
                    states.addAll(this.rightOp.setConstraint(ps, ConstraintManager.BooleanConstraint.FALSE));
                }
                for (ProgramState ps : trueFirstOp) {
                    states.addAll(this.rightOp.setConstraint(ps, ConstraintManager.BooleanConstraint.FALSE));
                }
            }
            return states;
        }

        @Override
        public String toString() {
            return this.leftOp + " & " + this.rightOp;
        }
    }

    static abstract class BooleanExpressionSymbolicValue
    extends BinarySymbolicValue {
        protected BooleanExpressionSymbolicValue(int id) {
            super(id);
        }

        @Override
        ConstraintManager.BooleanConstraint shouldNotInverse() {
            return ConstraintManager.BooleanConstraint.TRUE;
        }
    }

    static class InstanceOfSymbolicValue
    extends UnarySymbolicValue {
        public InstanceOfSymbolicValue(int id) {
            super(id);
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, ConstraintManager.BooleanConstraint booleanConstraint) {
            if (ConstraintManager.BooleanConstraint.TRUE.equals((Object)booleanConstraint)) {
                if (ObjectConstraint.NULL.equals(programState.getConstraint(this.operand))) {
                    return ImmutableList.of();
                }
                List<ProgramState> ps = this.operand.setConstraint(programState, ObjectConstraint.NOT_NULL);
                if (ps.size() == 1 && ps.get(0).equals(programState)) {
                    return ImmutableList.of((Object)programState.addConstraint(this, new ConstraintManager.TypedConstraint()));
                }
                return ps;
            }
            return ImmutableList.of((Object)programState);
        }
    }

    static class NotSymbolicValue
    extends UnarySymbolicValue {
        public NotSymbolicValue(int id) {
            super(id);
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, ConstraintManager.BooleanConstraint booleanConstraint) {
            return this.operand.setConstraint(programState, booleanConstraint.inverse());
        }

        @Override
        public String toString() {
            return "!" + this.operand;
        }
    }

    static abstract class UnarySymbolicValue
    extends SymbolicValue {
        protected SymbolicValue operand;

        public UnarySymbolicValue(int id) {
            super(id);
        }

        @Override
        public boolean references(SymbolicValue other) {
            return this.operand.equals(other) || this.operand.references(other);
        }

        @Override
        public void computedFrom(List<SymbolicValue> symbolicValues) {
            Preconditions.checkArgument((symbolicValues.size() == 1 ? 1 : 0) != 0);
            this.operand = symbolicValues.get(0);
        }
    }

    static class EqualToSymbolicValue
    extends BinarySymbolicValue {
        public EqualToSymbolicValue(int id) {
            super(id);
        }

        @Override
        ConstraintManager.BooleanConstraint shouldNotInverse() {
            return ConstraintManager.BooleanConstraint.TRUE;
        }
    }

    static class NotEqualToSymbolicValue
    extends BinarySymbolicValue {
        public NotEqualToSymbolicValue(int id) {
            super(id);
        }

        @Override
        public String toString() {
            return "NEQ_TO_" + super.toString();
        }

        @Override
        ConstraintManager.BooleanConstraint shouldNotInverse() {
            return ConstraintManager.BooleanConstraint.FALSE;
        }
    }

    static abstract class BinarySymbolicValue
    extends SymbolicValue {
        SymbolicValue leftOp;
        SymbolicValue rightOp;

        public BinarySymbolicValue(int id) {
            super(id);
        }

        abstract ConstraintManager.BooleanConstraint shouldNotInverse();

        @Override
        public boolean references(SymbolicValue other) {
            return this.leftOp.equals(other) || this.rightOp.equals(other) || this.leftOp.references(other) || this.rightOp.references(other);
        }

        @Override
        public void computedFrom(List<SymbolicValue> symbolicValues) {
            Preconditions.checkArgument((symbolicValues.size() == 2 ? 1 : 0) != 0);
            this.rightOp = symbolicValues.get(0);
            this.leftOp = symbolicValues.get(1);
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, ConstraintManager.BooleanConstraint booleanConstraint) {
            if (this.leftOp.equals(this.rightOp)) {
                if (this.shouldNotInverse().equals((Object)booleanConstraint)) {
                    return ImmutableList.of((Object)programState);
                }
                return ImmutableList.of();
            }
            List<ProgramState> copiedConstraints = this.copyConstraint(this.leftOp, this.rightOp, programState, booleanConstraint);
            if (copiedConstraints.isEmpty()) {
                return ImmutableList.of();
            }
            ArrayList<ProgramState> results = new ArrayList<ProgramState>();
            for (ProgramState ps : copiedConstraints) {
                List<ProgramState> copiedConstraintsRightToLeft = this.copyConstraint(this.rightOp, this.leftOp, ps, booleanConstraint);
                if (copiedConstraintsRightToLeft.size() == 1 && copiedConstraintsRightToLeft.get(0).equals(programState)) {
                    results.add(programState.addConstraint(this, (Object)booleanConstraint));
                    continue;
                }
                results.addAll(copiedConstraintsRightToLeft);
            }
            return results;
        }

        @Override
        public String toString() {
            return "EQ_TO_" + super.toString();
        }

        private List<ProgramState> copyConstraint(SymbolicValue from, SymbolicValue to, ProgramState programState, ConstraintManager.BooleanConstraint booleanConstraint) {
            Object constraintLeft = programState.getConstraint(from);
            if (constraintLeft instanceof ConstraintManager.BooleanConstraint) {
                ConstraintManager.BooleanConstraint boolConstraint = (ConstraintManager.BooleanConstraint)((Object)constraintLeft);
                return to.setConstraint(programState, this.shouldNotInverse().equals((Object)booleanConstraint) ? boolConstraint : boolConstraint.inverse());
            }
            if (constraintLeft instanceof ObjectConstraint) {
                ObjectConstraint nullConstraint = (ObjectConstraint)constraintLeft;
                if (nullConstraint.equals(ObjectConstraint.NULL)) {
                    return to.setConstraint(programState, this.shouldNotInverse().equals((Object)booleanConstraint) ? nullConstraint : nullConstraint.inverse());
                }
                if (this.shouldNotInverse().equals((Object)booleanConstraint)) {
                    return to.setConstraint(programState, nullConstraint);
                }
            }
            return ImmutableList.of((Object)programState);
        }
    }
}

