/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ObjectConstraint;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.SymbolicValue;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.checks.SyntaxTreeNameFinder;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2259", name="Null pointers should not be dereferenced", priority=Priority.BLOCKER)
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class NullDereferenceCheck
extends SECheck
implements JavaFileScanner {
    @Override
    public void scanFile(JavaFileScannerContext context) {
        Multimap<Tree, String> issues = ((DefaultJavaFileScannerContext)context).getSEIssues(NullDereferenceCheck.class);
        for (Map.Entry issue : issues.entries()) {
            context.reportIssue(this, (Tree)issue.getKey(), (String)issue.getValue());
        }
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        SymbolicValue currentVal = context.getState().peekValue();
        if (currentVal == null) {
            return context.getState();
        }
        Tree toCheck = syntaxNode;
        if (syntaxNode.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)syntaxNode;
            toCheck = methodInvocation.methodSelect();
        }
        if (toCheck.is(Tree.Kind.MEMBER_SELECT)) {
            return this.checkMemberSelect(context, (MemberSelectExpressionTree)toCheck, currentVal);
        }
        return context.getState();
    }

    private ProgramState checkMemberSelect(CheckerContext context, MemberSelectExpressionTree syntaxNode, SymbolicValue currentVal) {
        if ("class".equals(syntaxNode.identifier().name())) {
            return context.getState();
        }
        if (context.isNull(currentVal)) {
            context.reportIssue(syntaxNode, this, "NullPointerException might be thrown as '" + SyntaxTreeNameFinder.getName(syntaxNode) + "' is nullable here");
            return null;
        }
        return context.getState();
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        if (syntaxNode.is(Tree.Kind.SWITCH_STATEMENT) && context.isNull(context.getState().peekValue())) {
            context.reportIssue(syntaxNode, this, "NullPointerException might be thrown as '" + SyntaxTreeNameFinder.getName(syntaxNode) + "' is nullable here");
            context.createSink();
            return context.getState();
        }
        List<ProgramState> programStates = NullDereferenceCheck.setNullConstraint(context, syntaxNode);
        for (ProgramState programState : programStates) {
            context.addTransition(programState);
        }
        return context.getState();
    }

    private static List<ProgramState> setNullConstraint(CheckerContext context, Tree syntaxNode) {
        SymbolicValue val = context.getState().peekValue();
        if (syntaxNode.is(Tree.Kind.METHOD_INVOCATION) && NullDereferenceCheck.isAnnotatedCheckForNull((MethodInvocationTree)syntaxNode)) {
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            states.addAll(val.setConstraint(context.getState(), ObjectConstraint.NULL));
            states.addAll(val.setConstraint(context.getState(), ObjectConstraint.NOT_NULL));
            return states;
        }
        return Lists.newArrayList((Object[])new ProgramState[]{context.getState()});
    }

    private static boolean isAnnotatedCheckForNull(MethodInvocationTree syntaxNode) {
        return syntaxNode.symbol().metadata().isAnnotatedWith("javax.annotation.CheckForNull");
    }
}

