/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.maven;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.List;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.SonarComponents;
import org.sonar.maven.MavenCheck;
import org.sonar.maven.MavenFileScannerContext;
import org.sonar.maven.model.LocatedTree;
import org.sonar.maven.model.XmlLocation;
import org.sonar.maven.model.maven2.MavenProject;
import org.sonar.plugins.java.api.JavaCheck;

public class MavenFileScannerContextImpl
implements MavenFileScannerContext {
    private final MavenProject project;
    private final File file;
    private final SonarComponents sonarComponents;

    public MavenFileScannerContextImpl(MavenProject project, File file, SonarComponents sonarComponents) {
        this.project = project;
        this.file = file;
        this.sonarComponents = sonarComponents;
    }

    @Override
    public MavenProject getMavenProject() {
        return this.project;
    }

    @Override
    public void reportIssueOnFile(MavenCheck check, String message) {
        this.sonarComponents.addIssue(this.file, check, -1, message, null);
    }

    @Override
    public void reportIssue(MavenCheck check, LocatedTree tree, String message) {
        this.sonarComponents.addIssue(this.file, check, tree.startLocation().line(), message, null);
    }

    @Override
    public void reportIssue(MavenCheck check, int line, String message) {
        this.sonarComponents.addIssue(this.file, check, line, message, null);
    }

    @Override
    public void reportIssue(MavenCheck check, int line, String message, List<MavenFileScannerContext.Location> secondary) {
        AnalyzerMessage analyzerMessage = new AnalyzerMessage((JavaCheck)check, this.file, line, message, 0);
        for (MavenFileScannerContext.Location location : secondary) {
            AnalyzerMessage secondaryLocation = this.getSecondaryAnalyzerMessage(check, location);
            analyzerMessage.secondaryLocations.add(secondaryLocation);
        }
        this.sonarComponents.reportIssue(analyzerMessage);
    }

    @VisibleForTesting
    AnalyzerMessage getSecondaryAnalyzerMessage(MavenCheck check, MavenFileScannerContext.Location location) {
        XmlLocation startLocation = location.tree.startLocation();
        int startLine = startLocation.line();
        int startColumn = startLocation.column();
        if (startColumn == -1) {
            startColumn = 0;
        }
        AnalyzerMessage.TextSpan ts = new AnalyzerMessage.TextSpan(startLine, startColumn, startLine, startColumn);
        return new AnalyzerMessage((JavaCheck)check, this.file, ts, location.msg, 0);
    }
}

