/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import java.io.File;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.resources.Project;
import org.sonar.java.SonarComponents;
import org.sonar.java.checks.CheckList;
import org.sonar.java.xml.XmlAnalyzer;

public class XmlFileSensor
implements Sensor {
    private final FileSystem fs;
    private final FilePredicate xmlFilePredicate;
    private final SonarComponents sonarComponents;

    public XmlFileSensor(SonarComponents sonarComponents, FileSystem fs) {
        this.fs = fs;
        this.xmlFilePredicate = fs.predicates().matchesPathPattern("**/*.xml");
        this.sonarComponents = sonarComponents;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.fs.hasFiles(this.xmlFilePredicate);
    }

    public void analyse(Project module, SensorContext context) {
        this.sonarComponents.registerCheckClasses("squid", CheckList.getXmlChecks());
        new XmlAnalyzer(this.sonarComponents, this.sonarComponents.checkClasses()).scan(this.getXmlFiles());
    }

    private Iterable<File> getXmlFiles() {
        return this.fs.files(this.xmlFilePredicate);
    }

    public String toString() {
        return XmlFileSensor.class.getSimpleName();
    }
}

